/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.constant;

import com.wego168.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class MiniProgramMessageFormat {
    public static final String TIME = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm";
    public static final Integer TING_MAX_LENGTH = 20;
    public static final Integer PHRASE_MAX_LENGTH = 5;
    public static final String NO = "\u6682\u65e0";
    public static final Pattern NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9\\u4E00-\\u9FA5]+$");
    public static final Integer NAME_MAX_LENGTH = 20;
    public static final Integer CHINESE_NAME_MAX_LENGTH = 10;

    public static String messageTimeDetect(Date time) {
        if (time == null) {
            time = new Date();
        }
        return new SimpleDateFormat(TIME).format(time);
    }

    public static String messageTimeDetect(Date date1, Date date2) {
        date1 = date1 == null ? new Date() : date1;
        Date date = date2 = date2 == null ? new Date() : date2;
        if (date1.after(date2)) {
            return MiniProgramMessageFormat.messageTimeDetect(date2, date1);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME);
        return dateFormat.format(date1) + "~" + dateFormat.format(date2);
    }

    public static String messageTingDetect(String thing) {
        if (StringUtil.isBlank((String)thing)) {
            return NO;
        }
        if (thing.length() > TING_MAX_LENGTH) {
            return thing.substring(0, TING_MAX_LENGTH);
        }
        return thing;
    }

    public static String messageNameDetect(String name) {
        if (name == null) {
            return NO;
        }
        if (NAME_PATTERN.matcher(name).matches()) {
            if (name.length() < NAME_MAX_LENGTH) {
                return name;
            }
            return name.substring(0, NAME_MAX_LENGTH);
        }
        if (name.length() < CHINESE_NAME_MAX_LENGTH) {
            return name;
        }
        return name.substring(0, CHINESE_NAME_MAX_LENGTH);
    }
}

