/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.controller;

import com.simple.mybatis.Page;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.enums.ActivityOderTypeEnum;
import com.wego168.activity.enums.ActivityTypeEnum;
import com.wego168.activity.provider.ActivityProvider;
import com.wego168.activity.service.ActivityService;
import com.wego168.base.domain.Config;
import com.wego168.base.service.ConfigService;
import com.wego168.exception.WegoException;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.RequestUtil;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.wechat.api.IWechatQrcode;
import com.wego168.wxpay.enums.PayWayEnum;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminActivityController")
public class ActivityController
extends CrudController<Activity> {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityProvider activityProvider;
    @Autowired
    protected IWechatQrcode wechatQrcodeHelper;
    @Autowired
    protected ConfigService configService;

    public CrudService<Activity> getService() {
        return this.activityService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u6d3b\u52a8")
    @GetMapping(value={"/api/admin/v1/activity/get"})
    public RestResponse get(String id) {
        Activity activity = this.activityService.get(id);
        return RestResponse.success((Object)((Object)activity));
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6d3b\u52a8\u5217\u8868")
    @GetMapping(value={"/api/admin/v1/activity/list"})
    public RestResponse list(HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<Activity> activities = this.activityService.selectPages(page);
        return RestResponse.success(activities);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d3b\u52a8")
    @GetMapping(value={"/api/admin/v1/activity/page"})
    public RestResponse page(HttpServletRequest request) {
        Page page = this.buildPage(request);
        int type = RequestUtil.getIntegerParam((HttpServletRequest)request, (String)"type", (Integer)1);
        page.eq("type", (Object)type);
        Config config = this.configService.selectByKey("activity_order_type", this.getAppId());
        if (null != config) {
            this.setSort(page, config);
        }
        page.like("title");
        page.ge("startTime");
        page.le("endTime");
        page.eq("isEnableFee");
        page.eq("isRelease");
        List list = this.activityService.selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u65b0\u589e\u6d3b\u52a8")
    @PostMapping(value={"/api/admin/v1/activity/insert"})
    public RestResponse insert(@Valid @RequestBody Activity activity) {
        try {
            this.validInsert(activity);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
        activity.setType(ActivityTypeEnum.ADMIN.getIndex());
        String id = this.activityProvider.insert(activity);
        return RestResponse.success((String)id);
    }

    @ApiOperation(value="\u4fee\u6539\u6d3b\u52a8")
    @PostMapping(value={"/api/admin/v1/activity/update"})
    public RestResponse update(@Valid @RequestBody Activity activity) {
        String id = this.activityProvider.update(activity);
        return RestResponse.success((String)id);
    }

    @ApiOperation(value="\u4fee\u6539\u6d3b\u52a8\u53d1\u5e03\u72b6\u6001")
    @PostMapping(value={"/api/admin/v1/activity/updateRelease"})
    public RestResponse updateRelease(String id, Boolean isRelease) {
        this.activityService.updateRelease(id, isRelease);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u6d3b\u52a8")
    @PostMapping(value={"/api/admin/v1/activity/delete"})
    public RestResponse delete(String id) {
        this.activityService.deleteActivity(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u9ed8\u8ba4\u5e8f\u53f7")
    @GetMapping(value={"/api/admin/v1/activity/getActivitySort"})
    public RestResponse getActivitySort() {
        int sort = this.activityService.getActivitySort();
        return RestResponse.success((Object)sort);
    }

    private void validInsert(Activity activity) {
        ActivitySignSetting signSetting;
        Boolean auditAfterPay;
        Boolean enableSharePosterBackground;
        Boolean enableFee = activity.getIsEnableFee();
        if (enableFee != null && enableFee.booleanValue()) {
            String payWay = activity.getPayWay();
            Checker.checkCondition((boolean)StringUtil.isBlank((String)payWay), (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            Checker.checkCondition((!StringUtil.equals((String)payWay, (String)PayWayEnum.OFFLINE.value()) && !StringUtil.equals((String)payWay, (String)PayWayEnum.ONLINE.value()) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u652f\u4ed8\u65b9\u5f0f");
        }
        if ((enableSharePosterBackground = activity.getEnableSharePosterBackground()).booleanValue()) {
            Checker.checkBlankAndLength((String)activity.getSharePosterBackground(), (String)"\u5206\u4eab\u6d77\u62a5\u5e95\u56fe", (int)256);
        }
        Checker.checkCondition(((auditAfterPay = (signSetting = activity.getActivitySignSetting()).getAuditAfterPay()) == null ? 1 : 0) != 0, (String)"\u5ba1\u6838\u540e\u652f\u4ed8\u4e0d\u80fd\u4e3a\u7a7a");
        Boolean payAfterAudit = signSetting.getPayAfterAudit();
        Checker.checkCondition((payAfterAudit == null ? 1 : 0) != 0, (String)"\u652f\u4ed8\u540e\u5ba1\u6838\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void validUpdate(Activity activity) {
        this.validInsert(activity);
        String id = activity.getId();
        Activity activityDb = (Activity)((Object)this.activityService.selectById(id));
        Checker.checkCondition((activityDb == null ? 1 : 0) != 0, (String)"\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        if (activityDb.getIsRelease() != null && activityDb.getIsRelease().booleanValue()) {
            String payWayDb = activityDb.getPayWay();
            Checker.checkCondition((StringUtil.isNotBlank((String)payWayDb) && !StringUtil.equals((String)payWayDb, (String)activity.getPayWay()) ? 1 : 0) != 0, (String)"\u5df2\u53d1\u5e03\u7684\u6d3b\u52a8\u4e0d\u53ef\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f");
        }
    }

    private void setSort(Page page, Config config) {
        if (ActivityOderTypeEnum.SORT.getIndex() == Integer.parseInt(config.getValue())) {
            page.orderBy("seqNum desc, createTime desc");
            return;
        }
        if (ActivityOderTypeEnum.DEFAULT.getIndex() == Integer.parseInt(config.getValue())) {
            page.orderBy("seqNum desc");
            return;
        }
        if (ActivityOderTypeEnum.CREATE_TIME.getIndex() == Integer.parseInt(config.getValue())) {
            page.orderBy("createTime desc");
            return;
        }
        page.orderBy("createTime desc");
    }
}

