/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivitySignFileConfig;
import com.wego168.activity.domain.ActivitySignFileDownloadTask;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.handler.ActivitySignHandler;
import com.wego168.activity.model.response.ActivitySignFileDownloadTaskResponse;
import com.wego168.activity.provider.ActivityProvider;
import com.wego168.activity.scheduler.AsyncTask;
import com.wego168.activity.scheduler.RefundTask;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignFileConfigService;
import com.wego168.activity.service.ActivitySignFileDownloadTaskService;
import com.wego168.activity.service.ActivitySignService;
import com.wego168.activity.service.ActivitySignSettingService;
import com.wego168.activity.task.ActivityNotification;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignData;
import com.wego168.base.domain.SignDataSetting;
import com.wego168.base.enums.OrderTypeEnum;
import com.wego168.base.enums.SignDataSettingTypeEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.service.FileServerService;
import com.wego168.base.service.SignDataService;
import com.wego168.base.service.SignDataSettingService;
import com.wego168.base.service.SignService;
import com.wego168.base.service.StorableService;
import com.wego168.channel.service.ChannelService;
import com.wego168.distribute.util.DistributeSessionUtil;
import com.wego168.exception.WegoException;
import com.wego168.member.domain.Member;
import com.wego168.member.service.impl.MemberService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.InterfaceDispatcher;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.util.excel.ExcelData;
import com.wego168.util.excel.ExcelPoiUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.enums.PayChannelEnum;
import com.wego168.wxpay.enums.PaySceneEnum;
import com.wego168.wxpay.enums.PayStatusEnum;
import com.wego168.wxpay.enums.PayWayEnum;
import com.wego168.wxpay.service.PayService;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

@Validated
@RestController(value="AdminActivitySignController")
public class ActivitySignController
extends CrudController<Sign> {
    private final Logger logger = LoggerFactory.getLogger(ActivitySignController.class);
    private static final String downloadUrl = "https://athena-1255600302.cosgz.myqcloud.com/";
    @Autowired
    private SignService signService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivitySignService activitysignService;
    @Autowired
    private SignDataService signDataService;
    @Autowired
    private ActivitySignSettingService activitySignSettingService;
    @Autowired
    private SignDataSettingService signDataSettingService;
    @Autowired
    private ActivityProvider activityProvider;
    @Autowired
    private AsyncTask asyncTask;
    @Autowired
    private RefundTask refundTask;
    @Autowired
    private PayService payService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private ActivitySignFileConfigService signFileConfigService;
    @Value(value="${cos.path}")
    private String cosHost;
    @Autowired
    private ActivityNotification activityNotification;
    @Autowired
    private ActivitySignFileDownloadTaskService activitySignFileDownloadTaskService;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private StorableService storableService;

    public CrudService<Sign> getService() {
        return this.signService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u62a5\u540d")
    @GetMapping(value={"/api/admin/v1/activitySign/page"})
    public RestResponse page(HttpServletRequest request) {
        List<Sign> list;
        Page page = this.buildPage(request);
        boolean showChannel = false;
        String channelId = DistributeSessionUtil.getChannelId((HttpServletRequest)request);
        if (StringUtil.isNotBlank((String)channelId)) {
            page.put((Object)"channelId", (Object)channelId);
            showChannel = true;
        }
        if ((list = this.activitysignService.adminSignMember(page)) != null && list.size() > 0) {
            LinkedList<String> dataIdList = new LinkedList<String>();
            for (Sign sign2 : list) {
                String channel;
                if (!showChannel && StringUtil.isNotBlank((String)(channel = sign2.getChannel()))) {
                    showChannel = true;
                }
                dataIdList.add(sign2.getDataId());
            }
            List datas = this.signDataService.selectByDataIds(dataIdList, Boolean.valueOf(false));
            HashMap signMap = new HashMap();
            for (SignData signData : datas) {
                String dataId = signData.getDataId();
                if (!signMap.containsKey(dataId)) {
                    signMap.put(dataId, new LinkedList());
                }
                List tempList = (List)signMap.get(dataId);
                tempList.add(signData);
            }
            for (Sign sign : list) {
                sign.setSignDataList((List)signMap.get(sign.getDataId()));
                if (StringUtil.isBlank((String)sign.getMemberId())) continue;
                String memberId = sign.getMemberId();
                Member member = this.memberService.selectById(memberId);
                if (null != member) {
                    sign.setNickName(member.getAppellation());
                    sign.setHeadImage(member.getHeadImage());
                }
                InterfaceDispatcher.builder().collect(ActivitySignHandler.class).forEach(e -> e.setSurveyAnswer(sign, new Bootmap()));
            }
        }
        page.setList(list);
        Bootmap listConfig = new Bootmap();
        if (!showChannel) {
            showChannel = this.channelService.countByAppId(this.getAppId()) > 0;
        }
        listConfig.put((Object)"showChannel", (Object)showChannel);
        Bootmap response = new Bootmap();
        response.put((Object)"pageNum", (Object)page.getPageNum());
        response.put((Object)"pageSize", (Object)page.getPageSize());
        response.put((Object)"list", (Object)page.getList());
        response.put((Object)"total", (Object)page.getTotal());
        response.put((Object)"config", (Object)listConfig);
        return RestResponse.success((Object)response);
    }

    @GetMapping(value={"/api/admin/v1/activitySign/exportData"})
    public void exportData(HttpServletRequest request, HttpServletResponse response) {
        List<Sign> list;
        Page page = this.buildPage(request);
        page.setPageSize(Integer.MAX_VALUE);
        page.setCount(false);
        String channelId = DistributeSessionUtil.getChannelId((HttpServletRequest)request);
        if (StringUtil.isNotBlank((String)channelId)) {
            page.put((Object)"channelId", (Object)channelId);
        }
        if ((list = this.activitysignService.adminSignMember(page)) != null && list.size() > 0) {
            LinkedList<String> dataIdList = new LinkedList<String>();
            for (Sign sign2 : list) {
                dataIdList.add(sign2.getDataId());
            }
            List datas = this.signDataService.selectByDataIds(dataIdList, Boolean.valueOf(false));
            HashMap signMap = new HashMap();
            for (SignData signData : datas) {
                String dataId = signData.getDataId();
                if (!signMap.containsKey(dataId)) {
                    signMap.put(dataId, new LinkedList());
                }
                List tempList = (List)signMap.get(dataId);
                tempList.add(signData);
            }
            for (Sign sign : list) {
                sign.setSignDataList((List)signMap.get(sign.getDataId()));
            }
        }
        if (list != null && list.size() > 0) {
            String sourceId = (String)page.get((Object)"sourceId");
            Boolean showShare = (Boolean)page.get((Object)"transferMember");
            Shift.throwsIfInvalid((StringUtils.isBlank((CharSequence)sourceId) || showShare == null ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u53c2\u6570");
            Activity activity = (Activity)((Object)this.activityService.selectById(sourceId));
            List settingList = this.signDataSettingService.selectList(JpaCriteria.builder().eq("sourceId", (Object)sourceId).orderBy("sort"));
            ArrayList<ExcelExportEntity> arrayList = new ArrayList<ExcelExportEntity>();
            arrayList.add(new ExcelExportEntity("\u72b6\u6001", (Object)"status"));
            for (Object signDataSetting : settingList) {
                arrayList.add(new ExcelExportEntity(signDataSetting.getName(), (Object)signDataSetting.getId(), 20));
            }
            if (showShare.booleanValue()) {
                arrayList.add(new ExcelExportEntity("\u5206\u4eab\u8005", (Object)"shareMemberName"));
            }
            arrayList.add(new ExcelExportEntity("\u62a5\u540d\u65f6\u95f4", (Object)"signTime", 20));
            arrayList.add(new ExcelExportEntity("\u62a5\u540d\u6570\u91cf", (Object)"oneSignManyNum", 20));
            arrayList.add(new ExcelExportEntity("\u7b7e\u5230", (Object)"isCheck", 20));
            arrayList.add(new ExcelExportEntity("\u7b7e\u5230\u65f6\u95f4", (Object)"firstCheckinTime", 20));
            ArrayList lists = new ArrayList();
            for (Sign sign : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                List signDataList = sign.getSignDataList();
                map.put("status", SignStatusEnum.getNameByIndex((Integer)sign.getStatus()));
                if (signDataList != null && !signDataList.isEmpty()) {
                    for (SignData signData : signDataList) {
                        if (IntegerUtil.equals((Integer)SignDataSettingTypeEnum.FILE.getIndex(), (Integer)signData.getType())) {
                            map.put(signData.getSettingId(), downloadUrl + signData.getValue());
                            continue;
                        }
                        map.put(signData.getSettingId(), signData.getValue());
                    }
                }
                if (showShare.booleanValue()) {
                    map.put("shareMemberName", sign.getShareMemberName());
                }
                map.put("channelCodeName", sign.getChannelCodeName());
                map.put("signTime", DateTimeUtil.format((Date)sign.getSignTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (sign.getFirstCheckinTime() == null) {
                    map.put("isCheck", "\u5426");
                } else {
                    map.put("isCheck", "\u662f");
                    map.put("firstCheckinTime", DateTimeUtil.format((Date)sign.getFirstCheckinTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                map.put("oneSignManyNum", sign.getOneSignManyNum());
                lists.add(map);
            }
            ExportParams exportParams = new ExportParams(null, "\u62a5\u540d\u5217\u8868");
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, arrayList, lists);
            try {
                response.setCharacterEncoding("UTF-8");
                response.setHeader("content-Type", "application/vnd.ms-excel");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(activity.getTitle() + "\u62a5\u540d\u5217\u8868.xls", "UTF-8"));
                workbook.write((OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                throw new ValidationException(e.getMessage());
            }
        }
    }

    @GetMapping(value={"/api/admin/v1/activitySign/exportDataTemplate"})
    public void exportDataTemplate(HttpServletRequest request, HttpServletResponse response) {
        List signDataList = this.signDataSettingService.selectList(JpaCriteria.builder().eq("sourceId", (Object)request.getParameter("sourceId")).orderBy("sort"));
        ArrayList<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
        ArrayList lists = new ArrayList();
        HashSet<String> set = new HashSet<String>();
        for (SignDataSetting signDataSetting : signDataList) {
            set.add(signDataSetting.getName());
        }
        for (String str : set) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(str);
            excelExportEntity.setWidth(25.0);
            entity.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u62a5\u540d\u5217\u8868");
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entity, lists);
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u62a5\u540d\u5217\u8868\u6a21\u677f.xls", "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @GetMapping(value={"/api/admin/v1/activity-sign/has-file"})
    public RestResponse hasFile(@NotBlankAndLength(message="\u6d3b\u52a8\u975e\u6cd5") String sourceId) {
        List signDataSettingList = this.signDataSettingService.selectByActivityId(sourceId);
        return RestResponse.success((Object)this.hasFile(signDataSettingList));
    }

    private boolean hasFile(List<SignDataSetting> signDataSettingList) {
        if (Checker.listNotEmpty(signDataSettingList)) {
            for (SignDataSetting e : signDataSettingList) {
                if (!IntegerUtil.equals((Integer)e.getType(), (Integer)7)) continue;
                return true;
            }
        }
        return false;
    }

    @PostMapping(value={"/api/admin/v1/activity-sign-file-download-task/insert"})
    public RestResponse downloadFile(@NotBlankAndLength(message="\u6d3b\u52a8\u975e\u6cd5") String sourceId, @NotBlankAndLength(min=1, max=1024, message="\u62a5\u540d\u8bb0\u5f55\u975e\u6cd5") String signIdArrayString) {
        List signDataSettingList = this.signDataSettingService.selectByActivityId(sourceId);
        Checker.checkCondition((!this.hasFile(signDataSettingList) ? 1 : 0) != 0, (String)"\u8be5\u6d3b\u52a8\u4e0d\u5305\u542b\u9644\u52a0\uff0c\u65e0\u6cd5\u4e0b\u8f7d");
        String[] signIdArray = signIdArrayString.split(",");
        ActivitySignFileConfig fileConfig = this.signFileConfigService.ensure();
        List list = this.signDataService.selectSignDataBySignIdArray(signIdArray);
        Checker.checkCondition((boolean)Checker.listIsEmpty((List)list), (String)"\u62a5\u540d\u8bb0\u5f55\u4e0d\u5b58\u5728");
        FileServer server = this.fileServerService.ensure();
        ActivitySignFileDownloadTask task = this.activitySignFileDownloadTaskService.saveTaskAndUnit(fileConfig, list, signDataSettingList, server.getId());
        this.activitySignFileDownloadTaskService.runTask(task);
        return RestResponse.success((Object)task);
    }

    @GetMapping(value={"/api/admin/v1/activity-sign-file-download-task/page"})
    public RestResponse selectTaskPage(@NotBlankAndLength(message="\u6d3b\u52a8\u975e\u6cd5") String sourceId, HttpServletRequest request) {
        Page page = super.buildPage(request);
        page.eq("activityId", (Object)sourceId);
        page.orderBy("createTime DESC");
        List list = this.activitySignFileDownloadTaskService.selectList((JpaCriteria)page, ActivitySignFileDownloadTaskResponse.class);
        this.storableService.assembleHost(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/admin/v1/activitySign/importData"})
    public RestResponse importSign1(@RequestParam(name="file", required=false) MultipartFile file, String sourceId) {
        return this.importSign(file, sourceId);
    }

    @PostMapping(value={"/api/admin/v1/activitySign/importData2"})
    public RestResponse importSign2(MultipartFile file, String sourceId) {
        return this.importSign(file, sourceId);
    }

    @PostMapping(value={"/api/admin/v1/activitySign/importData3"})
    public RestResponse importSign3(@RequestParam(name="file", required=false) MultipartFile file, String sourceId, StandardMultipartHttpServletRequest request) {
        Map fileMap;
        if (file == null) {
            file = request.getFile("file");
        }
        if (file == null && (fileMap = request.getFileMap()) != null && fileMap.size() > 0) {
            for (Map.Entry entry : fileMap.entrySet()) {
                if (entry.getValue() == null) continue;
                file = (MultipartFile)entry.getValue();
            }
        }
        return this.importSign(file, sourceId);
    }

    private RestResponse importSign(MultipartFile file, String sourceId) {
        try {
            Checker.checkBlank((String)sourceId, (String)"\u6d3b\u52a8id");
            Checker.checkCondition((file == null || file.getSize() == 0L ? 1 : 0) != 0, (String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u6587\u4ef6\u5927\u5c0f\u4e3a0");
            ExcelData excelData = ExcelPoiUtil.getSimpleExcelDataAndCloseInputStream((MultipartFile)file);
            String[] head = excelData.getSimpleHead();
            Set body = excelData.getSimpleBody();
            List signDataSettingList = this.signDataSettingService.selectByActivityId(sourceId);
            Integer[] signDataSettingIndexArray = this.signDataSettingService.checkExcelHeadContainsAllSetting(head, signDataSettingList);
            Set mobileSet = this.signDataService.selectMobileSetByActivityId(sourceId);
            ArrayList<SignData> signDataList = new ArrayList<SignData>();
            ArrayList<Sign> signList = new ArrayList<Sign>();
            Date signTime = new Date();
            for (Map.Entry line : body) {
                int lineNumber = (Integer)line.getKey();
                Sign sign = new Sign();
                String dataId = GuidGenerator.generate();
                sign.setDataId(dataId);
                sign.setNum(Integer.valueOf(1));
                sign.setPrice(Integer.valueOf(0));
                sign.setAmount(Integer.valueOf(0));
                sign.setPayAmount(Integer.valueOf(0));
                sign.setSourceId(sourceId);
                sign.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
                sign.setStatus(SignStatusEnum.SIGN.getIndex());
                sign.setSignTime(signTime);
                String[] cells = (String[])line.getValue();
                int columnIndex = 0;
                for (String cell : cells) {
                    int signDataSettingIndex = signDataSettingIndexArray[columnIndex];
                    String position = "\u8868\u683c\u7b2c" + lineNumber + "\u884c\u7b2c" + (columnIndex + 1) + "\u5217";
                    if (signDataSettingIndex >= 0) {
                        SignDataSetting signDataSetting = (SignDataSetting)signDataSettingList.get(signDataSettingIndex);
                        Checker.checkCondition((signDataSetting.getIsRequired() != false && StringUtils.isBlank((CharSequence)cell) ? 1 : 0) != 0, (String)(position + "\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
                        SignData signData = new SignData();
                        signData.setDataId(dataId);
                        signData.setSettingId(signDataSetting.getId());
                        signData.setSourceId(sourceId);
                        signData.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
                        signData.setName(signDataSetting.getName());
                        signData.setValue(cell);
                        signData.setType(signDataSetting.getType());
                        signData.setIsShow(signDataSetting.getIsShow());
                        signDataList.add(signData);
                        if ("mobile".equals(signDataSetting.getFieldName())) {
                            Member member;
                            if (mobileSet.contains(cell)) {
                                // empty if block
                            }
                            if ((member = this.memberService.selectByMobile(cell)) != null) {
                                sign.setMemberId(member.getId());
                            }
                        }
                        if ("mobile".equals(signDataSetting.getFieldName()) && StringUtil.isBlank((String)cell)) {
                            return RestResponse.error((String)(position + "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
                        }
                    }
                    ++columnIndex;
                }
                signList.add(sign);
            }
            this.activitysignService.saveImportData(signList, signDataList);
            ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)sourceId)));
            this.activitySignSettingService.updateActivitySignNum(activitySignSetting);
            return RestResponse.success((String)"\u5bfc\u5165\u6210\u529f");
        }
        catch (WegoException e) {
            e.printStackTrace();
            return RestResponse.exception((WegoException)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResponse.error((String)"\u89e3\u6790\u8868\u683c\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u62a5\u540d\u5ba1\u6838")
    @PostMapping(value={"/api/admin/v1/activitySign/audit"})
    public RestResponse audit(@RequestBody List<Sign> signList) {
        Shift.throwsIfEmpty(signList, (String)"\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55");
        Sign sign = (Sign)this.signService.selectById((Object)signList.get(0).getId());
        ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)sign.getSourceId())));
        Activity activity = (Activity)((Object)this.activityService.selectById(sign.getSourceId()));
        this.activitysignService.audit(signList, activitySignSetting, activity);
        if (activitySignSetting.getIsEnableRemindMsg().booleanValue()) {
            this.asyncTask.sendMsg(activity, activitySignSetting, signList);
        }
        for (Sign sign1 : signList) {
            Sign sign2 = (Sign)this.signService.selectById((Object)sign1.getId());
            if (!IntegerUtil.equals((Integer)sign2.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex()) && !IntegerUtil.equals((Integer)sign2.getStatus(), (Integer)SignStatusEnum.AUDIT_NOT_PASS.getIndex()) || sign2.getMemberId() == null) continue;
            this.activityNotification.sendActivitySignSuccessNotification(activity, sign2.getMemberId(), sign2.getStatus());
        }
        return RestResponse.success((String)"\u6210\u529f");
    }

    @ApiOperation(value="\u53d6\u6d88\u62a5\u540d")
    @PostMapping(value={"/api/admin/v1/activitySign/cancel"})
    public RestResponse cancel(String id) {
        this.activityProvider.cancel(id, false);
        return RestResponse.success((String)"\u53d6\u6d88\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u53d6\u6d88\u62a5\u540d")
    @PostMapping(value={"/api/admin/v1/activitySign/batchCancel"})
    public RestResponse batchCancel(@RequestBody List<String> ids) {
        for (String id : ids) {
            this.activityProvider.cancel(id, false);
        }
        return RestResponse.success((String)"\u53d6\u6d88\u6210\u529f");
    }

    @ApiOperation(value="\u9000\u6b3e")
    @PostMapping(value={"/api/admin/v1/activitySign/refund"})
    public RestResponse refund(String id) {
        Sign sign = (Sign)this.signService.selectById((Object)id);
        Shift.throwsIfNull((Object)sign, (String)"\u62a5\u540d\u4e0d\u5b58\u5728");
        Shift.throwsIfInvalid((sign.getIsPay() == false ? 1 : 0) != 0, (String)"\u8be5\u62a5\u540d\u5c1a\u672a\u652f\u4ed8");
        Shift.throwsIfNull((Object)(sign.getStatus() != SignStatusEnum.CANCEL.getIndex() ? 1 : 0), (String)"\u8be5\u62a5\u540d\u5c1a\u672a\u53d6\u6d88");
        Pay refund = (Pay)this.payService.select(JpaCriteria.builder().eq("scene", (Object)PaySceneEnum.REFUND.value()).eq("orderId", (Object)id).eq("status", (Object)PayStatusEnum.SUCCESS.value()));
        Shift.throwsIfInvalid((refund != null ? 1 : 0) != 0, (String)"\u8be5\u62a5\u540d\u5df2\u7ecf\u9000\u8fc7\u6b3e\u4e86");
        Pay pay = (Pay)this.payService.select(JpaCriteria.builder().eq("scene", (Object)PaySceneEnum.TRADE.value()).eq("orderId", (Object)id).eq("status", (Object)PayStatusEnum.SUCCESS.value()));
        Shift.throwsIfNull((Object)pay, (String)"\u8be5\u62a5\u540d\u5c1a\u672a\u652f\u4ed8");
        String msg = this.refundTask.refund(pay);
        return RestResponse.success((String)msg);
    }

    @GetMapping(value={"/api/admin/v1/activitySign/charge_channel/list"})
    public RestResponse getChargeChannelList() {
        ArrayList channelList = new ArrayList();
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put("name", PayChannelEnum.ALIPAY.description());
        m1.put("value", PayChannelEnum.ALIPAY.value());
        channelList.add(m1);
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("name", PayChannelEnum.WECHAT.description());
        m2.put("value", PayChannelEnum.WECHAT.value());
        channelList.add(m2);
        HashMap<String, String> m3 = new HashMap<String, String>();
        m3.put("name", PayChannelEnum.CASH.description());
        m3.put("value", PayChannelEnum.CASH.value());
        channelList.add(m3);
        HashMap<String, String> m4 = new HashMap<String, String>();
        m4.put("name", PayChannelEnum.POS.description());
        m4.put("value", PayChannelEnum.POS.value());
        channelList.add(m4);
        HashMap<String, String> m5 = new HashMap<String, String>();
        m5.put("name", PayChannelEnum.UNION_PAY.description());
        m5.put("value", PayChannelEnum.UNION_PAY.value());
        channelList.add(m5);
        HashMap<String, String> m6 = new HashMap<String, String>();
        m6.put("name", PayChannelEnum.OTHER.description());
        m6.put("value", PayChannelEnum.OTHER.value());
        channelList.add(m6);
        return RestResponse.success(channelList);
    }

    @PostMapping(value={"/api/admin/v1/activitySign/charge"})
    public RestResponse chargeOffline(String id, String payChannel, String transactionNo) {
        try {
            Checker.checkBlank((String)id, (String)"\u62a5\u540d\u8bb0\u5f55id");
            Checker.checkBlank((String)payChannel, (String)"\u652f\u4ed8\u6e20\u9053");
            Checker.checkInRange((Object)PayChannelEnum.get((String)payChannel), (Object[])PayChannelEnum.values(), (String)"\u9519\u8bef\u7684\u652f\u4ed8\u6e20\u9053");
            Sign sign = (Sign)this.signService.selectById((Object)id);
            Checker.checkCondition((sign == null ? 1 : 0) != 0, (String)"\u8be5\u62a5\u540d\u8bb0\u5f55\u4e0d\u5b58\u5728");
            Checker.checkCondition((boolean)sign.getIsPay(), (String)"\u8be5\u62a5\u540d\u8bb0\u5f55\u5df2\u652f\u4ed8\uff0c\u4e0d\u53ef\u91cd\u590d\u652f\u4ed8");
            Pay pay = this.payService.createByCashTrade(sign.getPrice().intValue(), id, OrderTypeEnum.ACTIVITY.value(), "\u6d3b\u52a8\u8d39\u7528\u652f\u4ed8", sign.getAppId(), sign.getMemberId(), PayWayEnum.OFFLINE.value(), WxAppServiceTypeEnum.SERVICE.value());
            pay.setWay(PayWayEnum.OFFLINE.value());
            pay.setOutNotifyTime(new Date());
            pay.setStatus(Integer.valueOf(PayStatusEnum.SUCCESS.value()));
            pay.setChannel(payChannel);
            pay.setOutTradeNo(transactionNo);
            this.payService.insert((Object)pay);
            this.activitysignService.updateSignPay(sign, null, transactionNo, sign.getPrice());
            return RestResponse.success((String)"\u6536\u6b3e\u8bb0\u5f55\u6dfb\u52a0\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

