/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.controller;

import com.simple.mybatis.Page;
import com.wego168.activity.component.ActivitySignFileComponent;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivitySignFile;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignFileService;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.domain.BaseDomain;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.ParamUtils;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ActivitySignFileController
extends CrudController<ActivitySignFile> {
    @Autowired
    private ActivitySignFileService activitySignFileService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private ActivitySignFileComponent activitySignFileComponent;

    public CrudService<ActivitySignFile> getService() {
        return this.activitySignFileService;
    }

    @GetMapping(value={"/api/admin/v1/activitySignFile/batchDownloadSignFile"})
    public RestResponse batchDownloadSignFile2(String activityId, String id) {
        if (StringUtil.isNotBlank((String)id)) {
            return RestResponse.success((Object)this.activitySignFileService.selectById(id));
        }
        Activity activity = (Activity)((Object)this.activityService.selectById(activityId));
        Shift.throwsIfNull((Object)((Object)activity), (String)"\u627e\u4e0d\u5230\u6d3b\u52a8");
        ActivitySignFile activitySignFile = this.activitySignFileService.findZipByNow(activityId);
        if (null != activitySignFile) {
            return RestResponse.success((Object)((Object)activitySignFile));
        }
        String status = this.simpleRedisTemplate.getString("zip_" + activityId);
        if (StringUtil.isNotBlank((String)status) && StringUtil.equals((String)"start", (String)status)) {
            return RestResponse.error((String)"\u5f53\u524d\u6d3b\u52a8\u5df2\u6709\u6253\u5305\u4efb\u52a1");
        }
        this.activitySignFileComponent.zip2(activityId);
        return RestResponse.error((String)"\u5f00\u59cb\u6253\u5305...");
    }

    public RestResponse batchDownloadSignFile(String activityId, String id) {
        if (StringUtil.isNotBlank((String)id)) {
            return RestResponse.success((Object)this.activitySignFileService.selectById(id));
        }
        Activity activity = (Activity)((Object)this.activityService.selectById(activityId));
        Shift.throwsIfNull((Object)((Object)activity), (String)"\u627e\u4e0d\u5230\u6d3b\u52a8");
        ActivitySignFile activitySignFile = this.activitySignFileService.findZipByNow(activityId);
        if (null != activitySignFile) {
            return RestResponse.success((Object)((Object)activitySignFile));
        }
        String status = this.simpleRedisTemplate.getString("zip_" + activityId);
        if (StringUtil.isNotBlank((String)status) && StringUtil.equals((String)"start", (String)status)) {
            return RestResponse.error((String)"\u5f53\u524d\u6d3b\u52a8\u5df2\u6709\u6253\u5305\u4efb\u52a1");
        }
        this.activitySignFileComponent.zip(activityId);
        return RestResponse.error((String)"\u5f00\u59cb\u6253\u5305...");
    }

    @GetMapping(value={"/api/admin/v1/activitySignFile/page"})
    public RestResponse get(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("activityId");
        page.orderBy("createTime desc");
        List list = this.activitySignFileService.selectPage(page);
        if (null == list || list.size() == 0) {
            LinkedList<ActivitySignFile> linkedList = new LinkedList<ActivitySignFile>(list);
            ActivitySignFile activitySignFile = new ActivitySignFile();
            BaseDomainUtil.initBaseDomain((BaseDomain)activitySignFile, (String)this.getAppId());
            activitySignFile.setActivityId(ParamUtils.getString((ServletRequest)request, (String)"activityId"));
            activitySignFile.setId(null);
            linkedList.add(0, activitySignFile);
            page.setList(linkedList);
            return RestResponse.success((Object)page);
        }
        page.setList(list);
        LinkedList<ActivitySignFile> linkedList = new LinkedList<ActivitySignFile>(list);
        Date date = ((ActivitySignFile)((Object)linkedList.get(0))).getCreateTime();
        Date now = new Date();
        String s1 = DateTimeUtil.format((Date)date, (String)"yyyy-MM-dd");
        String s2 = DateTimeUtil.format((Date)now, (String)"yyyy-MM-dd");
        if (StringUtil.equals((String)s1, (String)s2)) {
            return RestResponse.success((Object)page);
        }
        ActivitySignFile activitySignFile = new ActivitySignFile();
        BaseDomainUtil.initBaseDomain((BaseDomain)activitySignFile, (String)this.getAppId());
        activitySignFile.setActivityId(ParamUtils.getString((ServletRequest)request, (String)"activityId"));
        activitySignFile.setId(null);
        linkedList.add(0, activitySignFile);
        page.setList(linkedList);
        return RestResponse.success((Object)page);
    }
}

