/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.mobile;

import com.simple.mybatis.Page;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivityFee;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.provider.ActivityProvider;
import com.wego168.activity.response.ActivityResponseParam;
import com.wego168.activity.service.ActivityFeeService;
import com.wego168.activity.service.ActivityPointService;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignService;
import com.wego168.activity.service.ActivitySignSettingService;
import com.wego168.activity.task.ActivityNotification;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignData;
import com.wego168.base.domain.SignDataSetting;
import com.wego168.base.domain.SignParam;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.service.SignDataService;
import com.wego168.base.service.SignDataSettingService;
import com.wego168.base.service.SignService;
import com.wego168.member.service.impl.points.PointsService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class ActivitySignController
extends CrudController<Sign> {
    @Autowired
    private ActivitySignService activitySignService;
    @Autowired
    private ActivityProvider activityProvider;
    @Autowired
    private SignService signService;
    @Autowired
    private SignDataService signDataService;
    @Autowired
    private ActivitySignSettingService activitySignSettingService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityFeeService activityFeeService;
    @Autowired
    private SignDataSettingService signDataSettingService;
    @Autowired
    private PointsService pointsService;
    @Autowired
    private ActivityPointService activityPointService;
    @Autowired
    private ActivityNotification activityNotification;
    private final Logger logger = LoggerFactory.getLogger(ActivitySignController.class);

    public CrudService<Sign> getService() {
        return this.activitySignService;
    }

    @ApiOperation(value="\u6d3b\u52a8\u62a5\u540d")
    @PostMapping(value={"/api/v1/activitySign/sign"})
    public RestResponse sign(@RequestBody SignParam activitySign, String code, HttpServletRequest request) {
        String mobile = this.activityProvider.isMobileVerify(activitySign, code, request);
        if (StringUtil.isNotBlank((String)mobile)) {
            return RestResponse.error((int)2011, (String)"\u6b64\u6d3b\u52a8\u9700\u8981\u624b\u673a\u9a8c\u8bc1", null);
        }
        ActivityResponseParam responseParam = this.activityProvider.sign(activitySign);
        Activity activity = responseParam.getActivity();
        String memberId = responseParam.getMemberId();
        this.activityNotification.sendActivitySignNotificationToAppManager(activity.getTitle(), activity.getAppId(), memberId, activity.getStartTime());
        return RestResponse.success((String)responseParam.getId());
    }

    @ApiOperation(value="\u83b7\u53d6\u5df2\u62a5\u540d\u7684\u4eba")
    @GetMapping(value={"/api/v1/activitySign/signMembers"})
    public RestResponse signMembers(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.setPageSize(100);
        ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingService.select(page.eq("activityId", (Object)page.getString("sourceId"))));
        if (activitySignSetting != null) {
            ArrayList<String> showSignStatus = new ArrayList<String>();
            if (activitySignSetting.getIsEnableToAuditShow().booleanValue()) {
                showSignStatus.add(SignStatusEnum.NOT_AUDIT.getIndex().toString());
            }
            if (activitySignSetting.getIsEnableUnpaidShow().booleanValue()) {
                showSignStatus.add(SignStatusEnum.NOT_PAY.getIndex().toString());
            }
            if (activitySignSetting.getIsEnableSignShow().booleanValue()) {
                showSignStatus.add(SignStatusEnum.SIGN.getIndex().toString());
            }
            if (showSignStatus.size() == 0) {
                showSignStatus.add("0");
            }
            page.put((Object)"list", showSignStatus);
        }
        List<Sign> list = this.activitySignService.mobileSignMember(page);
        List signDataSettings = this.signDataSettingService.selectByActivityId(page.getString("sourceId"));
        if (list != null && list.size() > 0) {
            LinkedList<String> dataIdList = new LinkedList<String>();
            for (Sign sign2 : list) {
                sign2.setSignTimeStr(DateTimeUtil.convertFormat((Date)sign2.getSignTime()));
                dataIdList.add(sign2.getDataId());
            }
            List datas = this.signDataService.selectByDataIds(dataIdList, Boolean.valueOf(true));
            HashMap signMap = new HashMap();
            for (SignData signData : datas) {
                String phone = signData.getValue();
                String name = signData.getValue();
                for (SignDataSetting signDataSetting : signDataSettings) {
                    if (StringUtil.equals((String)signDataSetting.getId(), (String)signData.getSettingId()) && StringUtil.equals((String)signDataSetting.getFieldName(), (String)"mobile") && phone.length() == 11) {
                        signData.setValue(phone.substring(0, 3) + "****" + phone.substring(7, phone.length()));
                    }
                    if (!StringUtil.equals((String)signDataSetting.getId(), (String)signData.getSettingId()) || !StringUtil.equals((String)signDataSetting.getFieldName(), (String)"name") || name.length() <= 1) continue;
                    signData.setValue(name.substring(0, 1) + "**");
                }
                String dataId = signData.getDataId();
                if (!signMap.containsKey(dataId)) {
                    signMap.put(dataId, new LinkedList());
                }
                List tempList = (List)signMap.get(dataId);
                tempList.add(signData);
            }
            for (Sign sign : list) {
                sign.setSignDataList((List)signMap.get(sign.getDataId()));
            }
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u53d6\u6d88\u62a5\u540d")
    @PostMapping(value={"/api/v1/activitySign/cancel"})
    public RestResponse cancel(String id) {
        try {
            this.activityProvider.cancel(id, true);
        }
        catch (Exception e) {
            this.logger.error("\u624b\u673a\u7aef\u53d6\u6d88\u62a5\u540d\u5931\u8d25  -> {}", (Throwable)e);
            return RestResponse.error((String)"\u53d6\u6d88\u5931\u8d25");
        }
        return RestResponse.success((String)"\u53d6\u6d88\u6210\u529f");
    }

    @GetMapping(value={"/api/v1/activitySign/getByMemberId"})
    public RestResponse getActivitySignByMemberId(String activityId) {
        Sign sign = this.activitySignService.selectSignByMemberId(activityId, SessionUtil.getMemberIdIfAbsentToThrow(), SignStatusEnum.SIGN.getIndex());
        return RestResponse.success((Object)sign);
    }

    @PostMapping(value={"/api/v1/activity-sign/point-pay"})
    public RestResponse pointPay(@NotBlankAndLength(message="\u7b7e\u5230id\u975e\u6cd5") String signId) {
        int point;
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Sign sign = (Sign)this.signService.selectById((Object)signId);
        Checker.checkCondition((sign == null || !StringUtil.equals((String)memberId, (String)sign.getMemberId()) ? 1 : 0) != 0, (String)"\u8be5\u62a5\u540d\u8bb0\u5f55\u4e0d\u5b58\u5728");
        if (sign.getIsPay().booleanValue()) {
            return RestResponse.success(null, (String)"\u8be5\u62a5\u540d\u5df2\u652f\u4ed8");
        }
        String activityId = sign.getSourceId();
        ActivityFee activityFee = this.activityFeeService.selectByActivityId(activityId);
        Checker.checkCondition((activityFee == null ? 1 : 0) != 0, (String)"\u8be5\u6d3b\u52a8\u672a\u914d\u7f6e\u652f\u4ed8");
        int pointFee = activityFee.getPoint() == null ? 0 : activityFee.getPoint();
        Checker.checkCondition((pointFee <= 0 ? 1 : 0) != 0, (String)"\u8be5\u6d3b\u52a8\u672a\u5f00\u542f\u79ef\u5206\u652f\u4ed8");
        Activity activity = (Activity)((Object)this.activityService.selectById(sign.getSourceId()));
        int oneSignManyNum = 1;
        if (activity.getIsOneSignMany().booleanValue()) {
            oneSignManyNum = sign.getOneSignManyNum() == null ? 1 : sign.getOneSignManyNum();
        }
        Checker.checkCondition(((pointFee *= oneSignManyNum) > (point = this.pointsService.getAmount(sign.getMemberId())) ? 1 : 0) != 0, (String)"\u60a8\u7684\u79ef\u5206\u4e0d\u8db3\uff0c\u65e0\u6cd5\u652f\u4ed8\u6d3b\u52a8\u62a5\u540d\u8d39\u7528\u3002");
        String appId = sign.getAppId();
        this.activityPointService.pointPayActivitySign(sign, activity.getTitle(), sign.getMemberId(), pointFee, appId);
        return RestResponse.success(null, (String)"ok");
    }
}

