/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.mobile;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.scheduler.AsyncTask;
import com.wego168.activity.service.ActivityCheckinService;
import com.wego168.activity.service.ActivityPointService;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignService;
import com.wego168.activity.task.ActivityNotification;
import com.wego168.base.domain.Checkin;
import com.wego168.base.domain.CheckinSetting;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignData;
import com.wego168.base.enums.CheckWayEnum;
import com.wego168.base.enums.CheckinStatusEnum;
import com.wego168.base.enums.LevelTypeEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.scheduler.ExperienceAsync;
import com.wego168.base.service.CheckinSettingService;
import com.wego168.base.service.SignDataService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.persistence.MemberMapper;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.util.SessionUtil;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="activityMobileCheckinController")
public class CheckinController
extends CrudController<Checkin> {
    @Autowired
    private ActivityCheckinService checkinService;
    @Autowired
    private CheckinSettingService checkinSettingService;
    @Autowired
    private ActivitySignService activitySignService;
    @Autowired
    private SignDataService signDataService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityPointService activityPointsService;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private AsyncTask asyncTask;
    @Autowired
    private ExperienceAsync experienceAsync;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private ActivityNotification activityNotification;
    BiFunction<String, Sign, SignData> function = (str, sign) -> this.signDataService.selectSignDataByFieldName(sign.getDataId(), str, sign.getSourceId());

    public CrudService<Checkin> getService() {
        return this.checkinService;
    }

    @PostMapping(value={"/api/v1/activityCheckin/checkin"})
    @Transactional(rollbackFor={Exception.class})
    public RestResponse checkin(String code, String checkinSettingId, Integer checkinWay, String msg) {
        CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
        Shift.throwsIfNull((Object)checkinSetting, (String)"\u7b7e\u5230\u4e0d\u5b58\u5728");
        Shift.throwsIfInvalid((boolean)new Date().after(checkinSetting.getCheckinEndTime()), (String)"\u7b7e\u5230\u5df2\u7ed3\u675f");
        Shift.throwsIfInvalid((boolean)new Date().before(checkinSetting.getCheckinStartTime()), (String)"\u7b7e\u5230\u672a\u5f00\u59cb");
        Shift.throwsIfNull((Object)checkinSetting, (String)"\u6d3b\u52a8\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Member member = (Member)this.memberMapper.selectById((Object)memberId);
        MemberAccount memberAccount = this.memberAccountService.selectWechatAccount(memberId);
        if (null == memberAccount) {
            memberAccount = this.memberAccountService.selectMiniProgramAccount(memberId);
        }
        Shift.throwsIfNull((Object)memberAccount, (String)"\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        String openId = memberAccount.getUsername();
        Shift.throwsIfBlank((String)memberId, (String)"\u4f1a\u5458\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        if (checkinSetting.getIsEnableSMSVerify().booleanValue()) {
            if (StringUtil.isNotBlank((String)code) && checkinSetting.getIsEnableSMSVerify().booleanValue()) {
                return RestResponse.error((int)2011, (String)"\u6b64\u6d3b\u52a8\u9700\u8981\u624b\u673a\u9a8c\u8bc1", null);
            }
            Checker.checkBlank((String)code, (String)"\u9a8c\u8bc1\u7801");
            String key = String.format("activity_sign_%s", member.getMobilePhoneNumber());
            String validateCode = this.simpleRedisTemplate.getString(key);
            Shift.throwsIfInvalid((boolean)StringUtils.isBlank((CharSequence)validateCode), (String)"\u9a8c\u8bc1\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f");
            Shift.throwsIfInvalid((!StringUtils.equals((CharSequence)validateCode, (CharSequence)code) ? 1 : 0) != 0, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        Checkin checkin = new Checkin();
        Sign sign = null;
        int count = this.checkinService.selectCount(JpaCriteria.builder().eq("memberId", (Object)memberId).eq("checkinSettingId", (Object)checkinSettingId));
        checkin.setMemberId(memberId);
        if (IntegerUtil.equals((Integer)checkinWay, (Integer)CheckWayEnum.MOBILE.getIndex())) {
            Checker.checkMobilePhoneNumber((String)msg);
            sign = this.activitySignService.getBySignMobile(checkinSetting.getSourceId(), msg);
            if (sign != null) {
                if (checkinSetting.getIsRequireSelfCheckin().booleanValue()) {
                    String signMemberId = sign.getMemberId();
                    Shift.throwsIfInvalid((StringUtils.isNotBlank((CharSequence)signMemberId) && !StringUtil.equals((String)signMemberId, (String)memberId) ? 1 : 0) != 0, (String)"\u9700\u8981\u62a5\u540d\u672c\u4eba\u7b7e\u5230");
                } else {
                    count = this.checkinService.selectCount(JpaCriteria.builder().eq("signId", (Object)sign.getId()).eq("checkinSettingId", (Object)checkinSettingId));
                    if (!StringUtil.equals((String)memberId, (String)sign.getMemberId())) {
                        checkin.setProxyMemberId(memberId);
                        if (StringUtil.isNotBlank((String)sign.getMemberId())) {
                            checkin.setMemberId(sign.getMemberId());
                        }
                    }
                }
            }
        } else if (checkinWay == CheckWayEnum.CODE.getIndex()) {
            sign = (Sign)this.activitySignService.select(JpaCriteria.builder().eq("memberId", (Object)memberId).eq("sourceId", (Object)checkinSetting.getSourceId()).eq("status", (Object)SignStatusEnum.SIGN.getIndex()));
        }
        if (!checkinSetting.getIsEnableSudden().booleanValue() && sign == null) {
            this.asyncTask.sendCheckinMsg(CheckinStatusEnum.FAIL.getIndex(), checkinSetting, openId, sign);
            return RestResponse.error((String)"\u60a8\u672a\u62a5\u540d\uff0c\u4e0d\u80fd\u7b7e\u5230");
        }
        checkin.setId(GuidGenerator.generate());
        checkin.setCheckWay(checkinWay);
        if (checkinWay == CheckWayEnum.CODE.getIndex()) {
            boolean enableCheckinCode = checkinSetting.getIsCheckinCode();
            Shift.throwsIfInvalid((!enableCheckinCode ? 1 : 0) != 0, (String)"\u672a\u5f00\u542f\u6697\u53f7\u7b7e\u5230");
            String checkinCode = checkinSetting.getCheckinCode();
            Shift.throwsIfInvalid((StringUtils.isBlank((CharSequence)checkinCode) || !msg.equals(checkinCode) ? 1 : 0) != 0, (String)"\u6697\u53f7\u4e0d\u6b63\u786e");
        }
        if (count > 0) {
            this.asyncTask.sendCheckinMsg(CheckinStatusEnum.REPEAT.getIndex(), checkinSetting, openId, sign);
            return RestResponse.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7b7e\u5230\uff0c\u8bf7\u52ff\u91cd\u590d\u7b7e\u5230");
        }
        checkin.setSourceId(checkinSetting.getSourceId());
        checkin.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
        checkin.setCheckinSettingId(checkinSettingId);
        checkin.setCheckinTime(new Date());
        checkin.setIsLate(Boolean.valueOf(false));
        if (new Date().after(checkinSetting.getCheckinLateTime())) {
            checkin.setIsLate(Boolean.valueOf(true));
        }
        if (sign != null) {
            checkin.setSignId(sign.getId());
            if (sign.getFirstCheckinTime() == null) {
                sign.setFirstCheckinTime(checkin.getCheckinTime());
            }
            if (StringUtils.isBlank((CharSequence)sign.getMemberId())) {
                sign.setMemberId(memberId);
            }
        }
        this.checkinService.checkin(checkin, sign);
        this.experienceAsync.addExperience(LevelTypeEnum.STUDY.getIndex().intValue(), "activity_checkin", checkin.getMemberId(), checkin.getId(), member.getAppId());
        if (checkinSetting.getIsEnableSudden().booleanValue() && sign == null) {
            this.asyncTask.sendCheckinMsg(CheckinStatusEnum.NOT_SIGN.getIndex(), checkinSetting, openId, sign);
        } else {
            this.asyncTask.sendCheckinMsg(CheckinStatusEnum.SUCCESS.getIndex(), checkinSetting, openId, sign);
        }
        Integer sourceType = checkinSetting.getSourceType();
        if (IntegerUtil.equals((Integer)sourceType, (Integer)SourceTypeEnum.ACTIVITY.getIndex())) {
            this.activityPointsService.giveActivityCheckinPointAsync(checkin);
            Activity activity = (Activity)((Object)this.activityService.selectById(checkinSetting.getSourceId()));
            this.activityNotification.sendActivityCheckinNotificationToAppManagerAsync(activity.getTitle(), activity.getAppId(), memberId);
        }
        return RestResponse.success((String)"\u7b7e\u5230\u6210\u529f");
    }

    @GetMapping(value={"/api/v1/activityCheckin/getCheckData"})
    public RestResponse getCheckData(@NotBlankAndLength(message="\u53c2\u6570\u975e\u6cd5") String checkinSettingId) {
        Sign sign;
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
        Shift.throwsIfNull((Object)checkinSetting, (String)"\u7b7e\u5230\u4e0d\u5b58\u5728");
        Checkin checkin = null;
        List list = this.checkinService.selectList(JpaCriteria.builder().eq("memberId", (Object)memberId).eq("checkinSettingId", (Object)checkinSettingId).orderBy("checkinTime DESC"));
        if (Checker.listIsEmpty((List)list)) {
            list = this.checkinService.selectList(JpaCriteria.builder().eq("proxyMemberId", (Object)memberId).eq("checkinSettingId", (Object)checkinSettingId).orderBy("checkinTime DESC"));
            if (Checker.listNotEmpty((List)list)) {
                if (IntegerUtil.equals((Integer)list.size(), (Integer)1)) {
                    checkin = (Checkin)list.get(0);
                } else {
                    Checker.checkCondition((boolean)true, (String)"\u5b58\u5728\u591a\u6761\u4ee3\u7b7e\u8bb0\u5f55\uff0c\u7cfb\u7edf\u65e0\u6cd5\u83b7\u53d6\u7b7e\u5230\u6570\u636e");
                }
            }
        } else {
            checkin = (Checkin)list.get(0);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (checkin != null && StringUtils.isNotBlank((CharSequence)checkin.getSignId()) && (sign = (Sign)this.activitySignService.selectById(checkin.getSignId())) != null) {
            List signDataList = this.signDataService.selectSignData(sign.getDataId(), sign.getSourceId());
            map.put("signDataList", signDataList);
        }
        map.put("checkinSetting", checkinSetting);
        map.put("checkin", checkin == null ? 0 : 1);
        String title = "\u7b7e\u5230";
        if (checkinSetting.getSourceType().equals(SourceTypeEnum.ACTIVITY.getIndex())) {
            title = (String)this.activityService.select(JpaCriteria.builder().select("title").eq("id", (Object)checkinSetting.getSourceId()), String.class);
        }
        map.put("title", title);
        map.put("sourceId", checkinSetting.getSourceId());
        map.put("sourceType", checkinSetting.getSourceType());
        return RestResponse.success(map);
    }

    @GetMapping(value={"/api/v1/activityCheckin/getCheckBySourceId"})
    public RestResponse getCheckBySourceId(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("sourceId").eq("memberId");
        return RestResponse.success((Object)this.checkinService.select((JpaCriteria)page));
    }

    @GetMapping(value={"/api/v1/activityCheckin/getActivityId"})
    public RestResponse getActivityId(String checkinSettingId) {
        CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
        Shift.throwsIfNull((Object)checkinSetting, (String)"\u627e\u4e0d\u5230\u7b7e\u5230\u8bbe\u7f6e");
        return RestResponse.success((String)checkinSetting.getSourceId());
    }
}

