/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.scheduler.AsyncTask;
import com.wego168.base.domain.Checkin;
import com.wego168.base.domain.CheckinSetting;
import com.wego168.base.domain.Sign;
import com.wego168.base.enums.CheckWayEnum;
import com.wego168.base.enums.CheckinStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.persistence.CheckinMapper;
import com.wego168.base.persistence.SignMapper;
import com.wego168.base.service.CheckinSettingService;
import com.wego168.domain.BaseDomain;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Shift;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityCheckinService
extends BaseService<Checkin> {
    private Logger logger = LoggerFactory.getLogger(ActivityCheckinService.class);
    @Autowired
    private CheckinSettingService checkinSettingService;
    @Autowired
    private CheckinMapper checkinMapper;
    @Autowired
    private SignMapper signMapper;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private AsyncTask asyncTask;

    public CrudMapper<Checkin> getMapper() {
        return this.checkinMapper;
    }

    @Transactional
    public void checkin(Checkin checkin, Sign sign) {
        this.logger.info("\u63d2\u5165\u7b7e\u5230\u8bb0\u5f55 -> {}", (Object)checkin);
        super.insert((Object)checkin);
        if (sign != null) {
            sign.setUpdateTime(new Date());
            this.logger.info("\u66f4\u65b0\u8bb0\u5f55 -> {}", (Object)sign);
            this.signMapper.updateSelective((Object)sign);
        }
    }

    public void activityCheckinByWriteOff(Sign sign, String checkinSettingId) {
        String proxyMemberId = "50918bf713854523909788b897621ea3";
        String signId = sign.getId();
        CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
        Shift.throwsIfNull((Object)checkinSetting, (String)"\u7b7e\u5230\u4e0d\u5b58\u5728");
        Shift.throwsIfInvalid((boolean)new Date().after(checkinSetting.getCheckinEndTime()), (String)"\u7b7e\u5230\u5df2\u7ed3\u675f");
        Shift.throwsIfInvalid((boolean)new Date().before(checkinSetting.getCheckinStartTime()), (String)"\u7b7e\u5230\u672a\u5f00\u59cb");
        Shift.throwsIfNull((Object)checkinSetting, (String)"\u6d3b\u52a8\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        Checkin checkin = new Checkin();
        BaseDomainUtil.initBaseDomain((BaseDomain)checkin, (String)this.getAppId());
        Member member = this.memberService.selectById(sign.getMemberId());
        Shift.throwsIfNull((Object)member, (String)"\u627e\u4e0d\u5230\u62a5\u540d\u7528\u6237");
        MemberAccount memberAccount = this.memberAccountService.selectMiniProgramAccount(sign.getMemberId());
        int count = 1;
        count = this.selectCount(JpaCriteria.builder().eq("signId", (Object)signId).eq("checkinSettingId", (Object)checkinSetting.getId()));
        if (count > 0) {
            Shift.throwsIfInvalid((count > 0 ? 1 : 0) != 0, (String)"\u62a5\u540d\u5df2\u7b7e\u5230");
        }
        checkin.setMemberId(sign.getMemberId());
        checkin.setProxyMemberId(proxyMemberId);
        checkin.setSourceId(sign.getSourceId());
        checkin.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
        checkin.setCheckWay(CheckWayEnum.WRITE_OFF.getIndex());
        checkin.setCheckinSettingId(checkinSetting.getId());
        checkin.setCheckinTime(new Date());
        checkin.setSignId(signId);
        checkin.setIsLate(Boolean.valueOf(false));
        if (sign.getFirstCheckinTime() == null) {
            sign.setFirstCheckinTime(checkin.getCheckinTime());
        }
        this.checkin(checkin, sign);
        this.asyncTask.sendCheckinMsg(CheckinStatusEnum.SUCCESS.getIndex(), checkinSetting, memberAccount.getUsername(), sign);
    }
}

