/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.ActivitySignFileConfig;
import com.wego168.activity.domain.ActivitySignFileDownloadTask;
import com.wego168.activity.domain.ActivitySignFileDownloadTaskUnit;
import com.wego168.activity.persistence.ActivitySignFileDownloadTaskMapper;
import com.wego168.activity.persistence.ActivitySignFileDownloadTaskUnitMapper;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.SignDataSetting;
import com.wego168.base.model.response.ActivitySignDataResponse;
import com.wego168.base.persistence.FileServerMapper;
import com.wego168.base.util.FileUtil;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivitySignFileDownloadTaskService
extends CrudService<ActivitySignFileDownloadTask> {
    @Autowired
    private ActivitySignFileDownloadTaskMapper mapper;
    @Autowired
    private ActivitySignFileDownloadTaskUnitMapper unitMapper;
    @Autowired
    private FileServerMapper fileServerMapper;
    private Logger logger = LoggerFactory.getLogger(ActivitySignFileDownloadTaskService.class);

    public CrudMapper<ActivitySignFileDownloadTask> getMapper() {
        return this.mapper;
    }

    public ActivitySignFileDownloadTask saveTaskAndUnit(ActivitySignFileConfig fileConfig, List<ActivitySignDataResponse> signDataList, List<SignDataSetting> signDataSettingList, String serverId) {
        Integer type;
        String taskId = SequenceUtil.createUuid();
        Date now = new Date();
        String activityId = signDataSettingList.get(0).getSourceId();
        ActivitySignFileDownloadTask task = new ActivitySignFileDownloadTask();
        task.setActivityId(activityId);
        task.setCreateTime(now);
        task.setDirPath(fileConfig.getTempFilePath() + File.separator + taskId);
        task.setFinishTime(null);
        task.setId(taskId);
        task.setServerId(serverId);
        task.setSize(null);
        task.setStatus("new");
        task.setStorationDurationMinutes(fileConfig.getCosStorationDurationMinutes());
        task.setZipUrl(null);
        ArrayList<ActivitySignFileDownloadTaskUnit> unitList = new ArrayList<ActivitySignFileDownloadTaskUnit>(signDataList.size());
        String currentSignId = null;
        int fileNameAppendMaxTimes = 3;
        int fileNameAppendTimes = 0;
        HashMap<String, String> signFileNameMap = new HashMap<String, String>();
        StringBuffer signFileNameBuffer = new StringBuffer();
        for (ActivitySignDataResponse e : signDataList) {
            String string = e.getId();
            if (!StringUtil.equals((String)string, currentSignId)) {
                fileNameAppendTimes = 0;
                signFileNameBuffer = new StringBuffer();
                signFileNameBuffer.append(StringUtil.asFileName((String)e.getValue()));
                ++fileNameAppendTimes;
                currentSignId = string;
                continue;
            }
            if (fileNameAppendTimes >= fileNameAppendMaxTimes) continue;
            signFileNameBuffer.append(StringUtil.asFileName((String)e.getValue()));
            if (!IntegerUtil.equals((Integer)(++fileNameAppendTimes), (Integer)fileNameAppendMaxTimes)) continue;
            String signFileName = signFileNameBuffer.toString();
            if (signFileName.length() > 120) {
                signFileName = signFileName.substring(0, 120);
            }
            signFileNameMap.put(string, signFileName);
        }
        HashMap<String, String> signDirNameMap = new HashMap<String, String>();
        for (SignDataSetting signDataSetting : signDataSettingList) {
            type = signDataSetting.getType();
            if (!IntegerUtil.equals((Integer)type, (Integer)7)) continue;
            signDirNameMap.put(signDataSetting.getId(), StringUtil.asFileName((String)signDataSetting.getName()));
        }
        for (ActivitySignDataResponse activitySignDataResponse : signDataList) {
            type = activitySignDataResponse.getType();
            if (!IntegerUtil.equals((Integer)type, (Integer)7)) continue;
            ActivitySignFileDownloadTaskUnit taskUnit = new ActivitySignFileDownloadTaskUnit();
            taskUnit.setCreateTime(now);
            taskUnit.setDir(task.getDirPath() + File.separator + (String)signDirNameMap.get(activitySignDataResponse.getSettingId()) + File.separator);
            String url = activitySignDataResponse.getValue();
            int dotIndex = url.lastIndexOf(".");
            if (dotIndex > 0) {
                String subfix = url.substring(dotIndex);
                taskUnit.setFileName((String)signFileNameMap.get(activitySignDataResponse.getId()) + subfix);
            } else {
                taskUnit.setFileName((String)signFileNameMap.get(activitySignDataResponse.getId()));
            }
            taskUnit.setFinishTime(null);
            taskUnit.setId(SequenceUtil.createUuid());
            taskUnit.setName(activitySignDataResponse.getName());
            taskUnit.setStatus("new");
            taskUnit.setTaskId(taskId);
            taskUnit.setUrl(activitySignDataResponse.getValue());
            unitList.add(taskUnit);
        }
        return this.saveTaskAndUnit(task, unitList);
    }

    @Transactional
    private ActivitySignFileDownloadTask saveTaskAndUnit(ActivitySignFileDownloadTask task, List<ActivitySignFileDownloadTaskUnit> unitList) {
        this.mapper.insert(task);
        this.unitMapper.insertBatch(unitList);
        return task;
    }

    @Async
    public void runTask(ActivitySignFileDownloadTask taskDb) {
        String taskStatus = taskDb.getStatus();
        Checker.checkCondition((!StringUtil.equals((String)taskStatus, (String)"new") ? 1 : 0) != 0, (String)"\u8be5\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d\u6216\u5df2\u7ed3\u675f");
        ActivitySignFileDownloadTask param = new ActivitySignFileDownloadTask();
        param.setId(taskDb.getId());
        param.setStatus("ongoing");
        this.updateSelective(param);
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("taskId", (Object)taskDb.getId());
        List unitList = this.unitMapper.selectList(criteria);
        for (ActivitySignFileDownloadTaskUnit e : unitList) {
            File dir = new File(e.getDir());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileUtil.downloadFile((String)("https://athena-1255600302.cosgz.myqcloud.com" + e.getUrl()), (String)e.getFileName(), (String)e.getDir());
            ActivitySignFileDownloadTaskUnit unitParam = new ActivitySignFileDownloadTaskUnit();
            unitParam.setId(e.getId());
            unitParam.setFinishTime(new Date());
            unitParam.setStatus("finished");
            this.unitMapper.updateSelective(unitParam);
        }
        File dir = new File(taskDb.getDirPath());
        File zip = new File(taskDb.getDirPath() + ".zip");
        ZipUtil.doCompress((File)dir, (File)zip);
        FileServer server = (FileServer)this.fileServerMapper.selectById((Object)taskDb.getServerId());
        String url = FileUploadUtil.upload2Cos((File)zip, (String)"sign-zip", (String)(taskDb.getId() + ".zip"), (FileServer)server);
        param.setId(taskDb.getId());
        param.setStatus("finished");
        param.setSize(zip.length());
        param.setZipUrl(url);
        param.setFinishTime(new Date());
        this.updateSelective(param);
        try {
            FileUtils.deleteDirectory((File)dir);
            FileUtils.deleteQuietly((File)zip);
        }
        catch (IOException e) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0c{}", (Throwable)e);
        }
    }
}

