/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.ActivitySignFile;
import com.wego168.activity.persistence.ActivitySignFileMapper;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitySignFileService
extends BaseService<ActivitySignFile> {
    @Autowired
    private ActivitySignFileMapper activitySignFileMapper;

    public CrudMapper<ActivitySignFile> getMapper() {
        return this.activitySignFileMapper;
    }

    public ActivitySignFile findLastZip(String activityId) {
        List activitySignFiles = this.selectList(JpaCriteria.builder().eq("activityId", (Object)activityId).orderBy("createTime desc"));
        if (activitySignFiles.size() == 0) {
            return null;
        }
        return (ActivitySignFile)((Object)activitySignFiles.get(0));
    }

    public static void main(String[] args) {
        System.out.println(new Date().getTime() > new Date().getTime());
    }

    public List<ActivitySignFile> getThreeDaysAge() {
        Calendar c = Calendar.getInstance();
        c.add(5, -3);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date time = c.getTime();
        return this.activitySignFileMapper.getThreeDaysAge(sdf.format(time));
    }

    public void deleteFile(ActivitySignFile activitySignFile) {
        Date now = new Date();
        activitySignFile.setRemoveLocalPath(true);
        activitySignFile.setRemoveLocalPathTime(now);
        activitySignFile.setRemoveCosPath(true);
        activitySignFile.setRemoveCosPathTime(now);
        super.updateSelective((Object)activitySignFile);
    }

    public ActivitySignFile findZipByNow(String activityId) {
        String now = DateTimeUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        return this.activitySignFileMapper.findZipByDay(now, activityId);
    }
}

