/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivityPointSetting;
import com.wego168.activity.domain.ActivitySignSetting;
import com.wego168.activity.handler.ActivitySignHandler;
import com.wego168.activity.model.response.SignResponse;
import com.wego168.activity.persistence.ActivitySignMapper;
import com.wego168.activity.scheduler.AsyncTask;
import com.wego168.activity.scheduler.RefundTask;
import com.wego168.activity.service.ActivityCheckinService;
import com.wego168.activity.service.ActivityPointService;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignSettingService;
import com.wego168.activity.task.ActivityNotification;
import com.wego168.activity.task.ActivitySignPayPublisher;
import com.wego168.base.component.ActivitySignPaySubscriber;
import com.wego168.base.domain.CalendarEvent;
import com.wego168.base.domain.Checkin;
import com.wego168.base.domain.CheckinSetting;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignData;
import com.wego168.base.domain.SignDataSetting;
import com.wego168.base.domain.SignParam;
import com.wego168.base.enums.CheckWayEnum;
import com.wego168.base.enums.LevelTypeEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.enums.SourceTypeEnum;
import com.wego168.base.persistence.SignMapper;
import com.wego168.base.scheduler.ExperienceAsync;
import com.wego168.base.service.CalendarEventService;
import com.wego168.base.service.CheckinSettingService;
import com.wego168.base.service.SignDataService;
import com.wego168.base.service.SignDataSettingService;
import com.wego168.base.service.SignService;
import com.wego168.exception.NullObjectException;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberCalendarEvent;
import com.wego168.member.domain.MemberData;
import com.wego168.member.persistence.MemberMapper;
import com.wego168.member.service.impl.CouponService;
import com.wego168.member.service.impl.MemberCalendarEventService;
import com.wego168.member.service.impl.MemberDataService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.IntegerUtil;
import com.wego168.util.InterfaceDispatcher;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.util.GuidGenerator;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.enums.PayCurrencyEnum;
import com.wego168.wxpay.enums.PaySceneEnum;
import com.wego168.wxpay.enums.PayStatusEnum;
import com.wego168.wxpay.persistence.PayMapper;
import com.wego168.wxpay.service.PayService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivitySignService
extends BaseService<Sign> {
    @Autowired
    private MemberCalendarEventService memberCalendarEventService;
    @Autowired
    private CalendarEventService calendarEventService;
    @Autowired
    private SignService signService;
    @Autowired
    private SignMapper signMapper;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivitySignMapper activitySignMapper;
    @Autowired
    private ActivitySignSettingService activitySignSettingService;
    @Autowired
    private SignDataService signDataService;
    @Autowired
    protected AuthenticationUser authenticationUser;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private MemberDataService memberDataService;
    @Autowired
    private PayService payService;
    @Autowired
    private AsyncTask asyncTask;
    @Autowired
    private RefundTask refundTask;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CheckinSettingService checkinSettingService;
    @Autowired
    private ActivityCheckinService checkinService;
    @Autowired
    private ExperienceAsync experienceAsync;
    @Autowired
    private PayMapper payMapper;
    @Autowired
    private ActivityCheckinService activityCheckinService;
    @Autowired
    private SignDataSettingService signDataSettingService;
    @Autowired
    private ActivityPointService activityPointService;
    @Autowired
    private ActivitySignPayPublisher activitySignPayPublisher;
    @Autowired
    private ActivityNotification activityNotification;
    private final Logger logger = LoggerFactory.getLogger(ActivitySignService.class);

    public CrudMapper<Sign> getMapper() {
        return this.signMapper;
    }

    @Transactional
    public String sign(Activity activity, SignParam activitySign, ActivitySignSetting activitySignSetting, Member member, boolean paid, List<Pay> tokenPayList) {
        return this.sign(activity, activitySign, activitySignSetting, member, paid, tokenPayList, null).getSignId();
    }

    @Transactional
    public SignResponse sign(Activity activity, SignParam activitySign, ActivitySignSetting signSetting, Member member, boolean paid, List<Pay> tokenPayList, ActivityPointSetting activityPoint) {
        int signGivePoint = activityPoint == null ? 0 : activityPoint.getSignPoint();
        int inviteSignPoint = activityPoint == null ? 0 : activityPoint.getInviteSignPoint();
        int receivedSignPoint = 0;
        Sign sign = activitySign.getSign();
        sign.setAppId(signSetting.getAppId());
        sign.setMemberId(member.getId());
        sign.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
        sign.setSignTime(new Date());
        sign.setIsPay(Boolean.valueOf(false));
        sign.setIsAudit(Boolean.valueOf(false));
        if (paid) {
            sign.setStatus(SignStatusEnum.SIGN.getIndex());
            sign.setIsPay(Boolean.valueOf(true));
        }
        String dataId = GuidGenerator.generate();
        sign.setDataId(dataId);
        this.creataSignData(sign, activitySign, member);
        this.signService.insert((Object)sign);
        this.activitySignSettingService.updateActivitySignNum(signSetting);
        if (IntegerUtil.equals((Integer)sign.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex())) {
            Object activityTitle2;
            this.saveCalendarEventIfAvailable(signSetting, member.getId());
            if (signGivePoint >= 0) {
                receivedSignPoint = signGivePoint;
                activityTitle2 = activity.getTitle();
                this.activityPointService.giveActivitySignPointAsync(sign, (String)activityTitle2);
                this.logger.error("\u6d3b\u52a8\u62a5\u540d\u6210\u529f\uff0c\u5df2\u53d1\u653e\u79ef\u5206\uff1a" + receivedSignPoint);
            }
            if (inviteSignPoint >= 0) {
                activityTitle2 = activity.getTitle();
                this.activityPointService.giveActivityInviteSignPointAsync(sign, (String)activityTitle2);
                this.logger.error("\u6d3b\u52a8\u62a5\u540d\u6210\u529f\uff0c\u5df2\u53d1\u653e\u9080\u8bf7\u79ef\u5206\uff1a" + inviteSignPoint);
            }
            this.createAirboneCheckin(sign);
            this.activitySignPayPublisher.publishActivitySignFreeAsync(sign);
            try {
                if (IntegerUtil.equals((Integer)sign.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex()) && sign.getMemberId() != null) {
                    this.activityNotification.sendActivitySignSuccessNotification(activity, sign.getMemberId(), SignStatusEnum.SIGN.getIndex());
                }
            }
            catch (Exception activityTitle2) {
                // empty catch block
            }
        }
        if (tokenPayList != null && tokenPayList.size() > 0) {
            for (Pay tokenPay : tokenPayList) {
                if (!IntegerUtil.equals((Integer)tokenPay.getCurrency(), (Integer)PayCurrencyEnum.TKT.value())) continue;
                this.couponService.useCoupon(tokenPay.getCurrencyMessage());
            }
            this.payMapper.insertBatch(tokenPayList);
        }
        if (signSetting.getIsEnableRemindMsg().booleanValue()) {
            ArrayList<Sign> list = new ArrayList<Sign>();
            list.add(sign);
            this.asyncTask.sendMsg(activity, signSetting, list);
        }
        InterfaceDispatcher.builder().collect(ActivitySignHandler.class).forEach(e -> e.sign(sign, new Bootmap()));
        SignResponse response = new SignResponse();
        response.setSignId(sign.getId());
        response.setGivePoint(receivedSignPoint);
        return response;
    }

    public void creataSignData(Sign sign, SignParam activitySign, Member member) {
        List signDataList = activitySign.getSignDataList();
        if (signDataList != null && signDataList.size() > 0) {
            MemberData memberData = (MemberData)this.memberDataService.selectById((Object)member.getId());
            if (memberData == null) {
                memberData = new MemberData();
                memberData.setId(member.getId());
                this.memberDataService.insert((Object)memberData);
            }
            for (SignData signData : signDataList) {
                signData.setId(GuidGenerator.generate());
                signData.setAppId(sign.getAppId());
                signData.setDataId(sign.getDataId());
                signData.setMemberId(member.getId());
                signData.setSourceId(sign.getSourceId());
                signData.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
                String signDataSettingId = signData.getSettingId();
                SignDataSetting signDataSetting = (SignDataSetting)this.signDataSettingService.selectById((Object)signDataSettingId);
                if (null == signDataSetting) {
                    this.logger.error("\u4e0d\u662f\u7cfb\u7edf\u62a5\u540d\u5b57\u6bb5\uff0c\u8df3\u8fc7\u66f4\u65b0->{}", (Object)signData.getId());
                    continue;
                }
                String value = signData.getValue();
                if (StringUtils.equals((CharSequence)"name", (CharSequence)signDataSetting.getFieldName())) {
                    Shift.throwsIfInvalid((StringUtils.isBlank((CharSequence)value) || value.length() < 2 ? 1 : 0) != 0, (String)"\u59d3\u540d\u4e0d\u80fd\u5c11\u4e8e\u4e24\u4e2a\u5b57");
                    if (StringUtils.isBlank((CharSequence)member.getName()) || member.getName().length() == 11) {
                        member.setName(value);
                    }
                }
                if (StringUtils.equals((CharSequence)"mobile", (CharSequence)signDataSetting.getFieldName())) {
                    int count = this.activitySignMapper.selectSignMobile(value, sign.getSourceId());
                    Shift.throwsIfInvalid((count > 0 ? 1 : 0) != 0, (String)"\u8be5\u624b\u673a\u5df2\u7ecf\u62a5\u8fc7\u540d\u4e86\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    int existMemberCount = this.memberMapper.selectCount(JpaCriteria.builder().eq("appId", (Object)sign.getAppId()).eq("mobilePhoneNumber", (Object)value));
                    if (existMemberCount == 0 && StringUtils.isBlank((CharSequence)member.getMobilePhoneNumber())) {
                        member.setMobilePhoneNumber(value);
                    }
                }
                if (StringUtils.equals((CharSequence)"company", (CharSequence)signDataSetting.getFieldName()) && StringUtils.isBlank((CharSequence)memberData.getCompany()) && StringUtils.isNotBlank((CharSequence)value)) {
                    memberData.setCompany(value);
                }
                if (!StringUtils.equals((CharSequence)"position", (CharSequence)signDataSetting.getFieldName()) || !StringUtils.isBlank((CharSequence)memberData.getPosition()) || !StringUtils.isNotBlank((CharSequence)value)) continue;
                memberData.setPosition(value);
            }
            this.memberMapper.updateSelective((Object)member);
            this.memberDataService.updateSelective((Object)memberData);
            this.signDataService.insertBatch(signDataList);
        }
    }

    public Checkin createAirboneCheckin(Sign sign) {
        String checkinSettingId = sign.getCheckinSettingId();
        if (StringUtil.isBlank((String)checkinSettingId)) {
            return null;
        }
        CheckinSetting checkinSetting = (CheckinSetting)this.checkinSettingService.selectById((Object)checkinSettingId);
        Checkin checkin = new Checkin();
        checkin.setId(GuidGenerator.generate());
        checkin.setCheckWay(CheckWayEnum.AIRBORNE.getIndex());
        checkin.setMemberId(sign.getMemberId());
        checkin.setSourceId(sign.getSourceId());
        checkin.setSourceType(SourceTypeEnum.ACTIVITY.getIndex());
        checkin.setCheckinSettingId(checkinSettingId);
        checkin.setCheckinTime(new Date());
        checkin.setIsLate(Boolean.valueOf(false));
        if (new Date().after(checkinSetting.getCheckinLateTime())) {
            checkin.setIsLate(Boolean.valueOf(true));
        }
        checkin.setSignId(sign.getId());
        sign.setFirstCheckinTime(checkin.getCheckinTime());
        if (sign.getFirstCheckinTime() == null) {
            sign.setFirstCheckinTime(checkin.getCheckinTime());
        }
        this.checkinService.checkin(checkin, sign);
        this.experienceAsync.addExperience(LevelTypeEnum.STUDY.getIndex().intValue(), "activity_checkin", checkin.getMemberId(), checkin.getId(), sign.getAppId());
        this.activityNotification.sendActivityCheckinNotificationToAppManagerAsync(sign);
        this.activityPointService.giveActivityCheckinPointAsync(checkin);
        return checkin;
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancel(Sign activitySign, ActivitySignSetting activitySignSetting) {
        activitySign.setUnsignTime(new Date());
        activitySign.setStatus(SignStatusEnum.CANCEL.getIndex());
        this.signService.updateSelective((Object)activitySign);
        CalendarEvent calendarEvent = this.calendarEventService.selectBySourceId(activitySign.getSourceId());
        if (calendarEvent != null) {
            this.memberCalendarEventService.delete(JpaCriteria.builder().eq("calendarEventId", (Object)calendarEvent.getId()).eq("memberId", (Object)activitySign.getMemberId()));
        }
        this.activitySignSettingService.updateActivitySignNum(activitySignSetting);
        List payList = this.payService.selectList(JpaCriteria.builder().eq("orderId", (Object)activitySign.getId()).eq("scene", (Object)PaySceneEnum.TRADE.value()).eq("status", (Object)PayStatusEnum.SUCCESS.value()));
        this.logger.error("\u6d3b\u52a8\u53d6\u6d88\u62a5\u540d\t->\t{},\t\u9700\u8981\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c\t->\t{}", (Object)activitySign, (Object)payList);
        if (payList != null && payList.size() > 0) {
            for (Pay pay : payList) {
                if (IntegerUtil.equals((Integer)PayCurrencyEnum.CNY.value(), (Integer)pay.getCurrency()) && pay.getCash().booleanValue()) {
                    this.refundTask.refundAsync(pay);
                    InterfaceDispatcher.builder().collect(ActivitySignPaySubscriber.class).forEach(e -> e.subscribeActivitySignRefund(activitySign.getId(), "", activitySign.getMemberId(), activitySign.getAppId()));
                    continue;
                }
                if (!IntegerUtil.equals((Integer)PayCurrencyEnum.TKT.value(), (Integer)pay.getCurrency())) continue;
                this.payService.deleteById((Object)pay.getId());
                this.couponService.refundCoupon(pay.getCurrencyMessage());
            }
        }
        this.activityPointService.deductActivitySignPointAsync(activitySign);
        String signId = activitySign.getId();
        String memberId = activitySign.getMemberId();
        this.activityPointService.returnActivitySignPointIfPaid(signId, memberId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void audit(List<Sign> signRequestList, ActivitySignSetting activitySignSetting, Activity activity) {
        String activityTitle = activity.getTitle();
        for (Sign signRequest : signRequestList) {
            MemberCalendarEvent memberCalendarEventList;
            Sign signDb = (Sign)this.signService.selectById((Object)signRequest.getId());
            signDb.setIsAudit(Boolean.valueOf(true));
            signDb.setAuditBy(this.authenticationUser.getUserId());
            signDb.setAuditTime(new Date());
            boolean auditAfterPay = activitySignSetting.getAuditAfterPay();
            boolean payAfterAudit = activitySignSetting.getPayAfterAudit();
            if (SignStatusEnum.AUDIT_PASS.getIndex().equals(signRequest.getStatus())) {
                if (auditAfterPay) {
                    if (activity.getIsEnableFee().booleanValue()) {
                        signDb.setStatus(SignStatusEnum.NOT_PAY.getIndex());
                    } else {
                        signDb.setStatus(SignStatusEnum.SIGN.getIndex());
                    }
                }
                if (payAfterAudit) {
                    Pay pay = (Pay)this.payService.select(JpaCriteria.builder().eq("orderId", (Object)signDb.getId()).eq("status", (Object)PayStatusEnum.SUCCESS.value()).eq("scene", (Object)PaySceneEnum.TRADE.value()));
                    Optional<Pay> op = Optional.ofNullable(pay);
                    op.orElseThrow(() -> new NullObjectException(new Object[]{"\u672a\u627e\u5230\u652f\u4ed8\u8bb0\u5f55"}));
                    op.ifPresent(s -> signDb.setStatus(SignStatusEnum.SIGN.getIndex()));
                }
            }
            if (SignStatusEnum.AUDIT_NOT_PASS.getIndex().equals(signRequest.getStatus())) {
                if (payAfterAudit) {
                    Pay refund = (Pay)this.payService.select(JpaCriteria.builder().eq("scene", (Object)PaySceneEnum.REFUND.value()).eq("orderId", (Object)signDb.getId()).eq("status", (Object)PayStatusEnum.SUCCESS.value()));
                    Pay pay = (Pay)this.payService.select(JpaCriteria.builder().eq("scene", (Object)PaySceneEnum.TRADE.value()).eq("orderId", (Object)signDb.getId()).eq("status", (Object)PayStatusEnum.SUCCESS.value()));
                    Shift.throwsIfNull((Object)pay, (String)"\u8be5\u62a5\u540d\u5c1a\u672a\u652f\u4ed8");
                    if (refund == null && pay != null) {
                        String msg = this.refundTask.refund(pay);
                        this.logger.error("\u5ba1\u6838\u4e0d\u901a\u8fc7\u9700\u9000\u6b3e\u8fd4\u56de\u7ed3\u679c- -> {}", (Object)msg);
                    }
                }
                signDb.setStatus(SignStatusEnum.AUDIT_NOT_PASS.getIndex());
                this.signService.updateSelective((Object)signDb);
                this.activityPointService.deductActivitySignPointAsync(signDb);
                continue;
            }
            this.signService.updateSelective((Object)signDb);
            CalendarEvent calendarEvent = this.calendarEventService.selectBySourceId(activity.getId());
            if (calendarEvent != null && (memberCalendarEventList = (MemberCalendarEvent)this.memberCalendarEventService.select(JpaCriteria.builder().eq("calendarEventId", (Object)calendarEvent.getId()).eq("memberId", (Object)signDb.getMemberId()))) == null) {
                MemberCalendarEvent memberCalendarEvent = new MemberCalendarEvent();
                memberCalendarEvent.setId(GuidGenerator.generate());
                memberCalendarEvent.setAppId(activity.getAppId());
                memberCalendarEvent.setCreateTime(new Date());
                memberCalendarEvent.setMemberId(signDb.getMemberId());
                memberCalendarEvent.setCalendarEventId(calendarEvent.getId());
                memberCalendarEvent.setRemaindTime(activitySignSetting.getRemaindTime());
                memberCalendarEvent.setIsEnableSmsRemind(activitySignSetting.getIsEnableSmsRemind());
                memberCalendarEvent.setIsEnableWxRemind(activitySignSetting.getIsEnableWxRemind());
                memberCalendarEvent.setIsEnableWxTemplateRemind(activitySignSetting.getIsEnableWxTemplateRemind());
                this.memberCalendarEventService.insert((Object)memberCalendarEvent);
            }
            if (!IntegerUtil.equals((Integer)signDb.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex())) continue;
            this.activityPointService.giveActivitySignPointAsync(signDb, activityTitle);
            this.activityPointService.giveActivityInviteSignPointAsync(signDb, activityTitle);
            this.activitySignPayPublisher.publishActivitySignFreeAsync(signDb);
        }
        this.activitySignSettingService.updateActivitySignNum(activitySignSetting);
    }

    public Boolean selectExsist(String memberId, String sourceId) {
        List signList = super.selectList(JpaCriteria.builder().eq("memberId", (Object)memberId).eq("sourceId", (Object)sourceId).ne("status", (Object)SignStatusEnum.CANCEL.getIndex()));
        if (signList != null && signList.size() > 0) {
            return true;
        }
        return false;
    }

    @Transactional
    public void saveImportData(List<Sign> signList, List<SignData> signDataList) {
        this.signService.insertBatch(signList);
        this.signDataService.insertBatch(signDataList);
    }

    public List<Sign> adminSignMember(Page page) {
        return this.activitySignMapper.adminSignMember(page);
    }

    public List<Sign> mobileSignMember(Page page) {
        return this.activitySignMapper.mobileSignMember(page);
    }

    public Sign getBySignMobile(String sourceId, String mobile) {
        return this.activitySignMapper.getBySignMobile(sourceId, mobile);
    }

    @Transactional
    public void updateSignPay(Sign sign, Pay payDb, String outTradeNumber, int payAmount) {
        sign.setPayAmount(Integer.valueOf(sign.getPayAmount() + payAmount));
        Activity a = (Activity)((Object)this.activityService.selectById(sign.getSourceId()));
        if (a.getIsOneSignMany().booleanValue()) {
            sign.setAmount(Integer.valueOf(sign.getPrice() * sign.getOneSignManyNum() - sign.getPayAmount()));
        } else {
            sign.setAmount(Integer.valueOf(sign.getPrice() - sign.getPayAmount()));
        }
        sign.setPayTime(new Date());
        if (sign.getAmount() <= 0) {
            ActivitySignSetting activitySignSetting = this.activitySignSettingService.selectByActivityId(sign.getSourceId());
            boolean auditAfterPay = activitySignSetting.getAuditAfterPay();
            boolean payAfterAudit = activitySignSetting.getPayAfterAudit();
            if (auditAfterPay) {
                sign.setStatus(SignStatusEnum.SIGN.getIndex());
            }
            if (payAfterAudit) {
                sign.setStatus(SignStatusEnum.NOT_AUDIT.getIndex());
            }
            sign.setIsPay(Boolean.valueOf(true));
        }
        this.signService.updateSelective((Object)sign);
        if (payDb != null) {
            this.payService.updateWechatPay(outTradeNumber, payDb.getId());
        }
        this.createAirboneCheckin(sign);
        if (SourceTypeEnum.ACTIVITY.getIndex().equals(sign.getSourceType())) {
            Activity activity = (Activity)((Object)this.activityService.selectById(sign.getSourceId()));
            ActivitySignSetting activitySignSetting = (ActivitySignSetting)((Object)this.activitySignSettingService.select(JpaCriteria.builder().eq("activityId", (Object)sign.getSourceId())));
            if (activitySignSetting.getIsEnableRemindMsg().booleanValue()) {
                ArrayList<Sign> list = new ArrayList<Sign>();
                list.add(sign);
                this.asyncTask.sendMsg(activity, activitySignSetting, list);
            }
            this.activitySignSettingService.updateActivitySignNum(activitySignSetting);
            String activityTitle = activity.getTitle();
            if (IntegerUtil.equals((Integer)sign.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex())) {
                this.activityPointService.giveActivitySignPointAsync(sign, activityTitle);
            }
            if (IntegerUtil.equals((Integer)sign.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex())) {
                this.activityPointService.giveActivityInviteSignPointAsync(sign, activityTitle);
            }
            if (IntegerUtil.equals((Integer)sign.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex()) && sign.getMemberId() != null) {
                this.activityNotification.sendActivitySignSuccessNotification(activity, sign.getMemberId(), SignStatusEnum.SIGN.getIndex());
            }
        }
    }

    @Transactional
    public void updateSignPointPay(Sign sign, int payPoint) {
        sign.setPayAmount(Integer.valueOf(0));
        sign.setPayPoint(Integer.valueOf(payPoint));
        sign.setAmount(Integer.valueOf(0));
        sign.setPayTime(new Date());
        ActivitySignSetting activitySignSetting = this.activitySignSettingService.selectByActivityId(sign.getSourceId());
        boolean auditAfterPay = activitySignSetting.getAuditAfterPay();
        boolean payAfterAudit = activitySignSetting.getPayAfterAudit();
        if (auditAfterPay) {
            sign.setStatus(SignStatusEnum.SIGN.getIndex());
        }
        if (payAfterAudit) {
            sign.setStatus(SignStatusEnum.NOT_AUDIT.getIndex());
        }
        sign.setIsPay(Boolean.valueOf(true));
        this.signService.updateSelective((Object)sign);
        this.createAirboneCheckin(sign);
        if (SourceTypeEnum.ACTIVITY.getIndex() == sign.getSourceType()) {
            Activity activity = (Activity)((Object)this.activityService.selectById(sign.getSourceId()));
            if (activitySignSetting.getIsEnableRemindMsg().booleanValue()) {
                ArrayList<Sign> list = new ArrayList<Sign>();
                list.add(sign);
                this.asyncTask.sendMsg(activity, activitySignSetting, list);
            }
            this.activitySignSettingService.updateActivitySignNum(activitySignSetting);
            String activityTitle = activity.getTitle();
            if (IntegerUtil.equals((Integer)sign.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex())) {
                this.activityPointService.giveActivitySignPointAsync(sign, activityTitle);
            }
            if (IntegerUtil.equals((Integer)sign.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex())) {
                this.activityPointService.giveActivityInviteSignPointAsync(sign, activityTitle);
            }
            if (IntegerUtil.equals((Integer)sign.getStatus(), (Integer)SignStatusEnum.SIGN.getIndex()) && sign.getMemberId() != null) {
                this.activityNotification.sendActivitySignSuccessNotification(activity, sign.getMemberId(), SignStatusEnum.SIGN.getIndex());
            }
        }
    }

    public int deleteByDataId(String dataId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("dataId", (Object)dataId);
        return this.delete(jpaCriteria);
    }

    @Transactional
    public void writeOffSign(String signId, String checkinSettingId) {
        Sign activitySign = (Sign)this.selectById(signId);
        this.activityCheckinService.activityCheckinByWriteOff(activitySign, checkinSettingId);
        Activity activity = (Activity)((Object)this.activityService.selectById(((Sign)this.signService.selectById((Object)signId)).getSourceId()));
        Shift.throwsIfNull((Object)((Object)activity), (String)"\u627e\u4e0d\u5230\u76f8\u5173\u6d3b\u52a8");
        if (null != activity.getIsEnableCheckinRefund() && activity.getIsEnableCheckinRefund().booleanValue()) {
            Pay pay = this.validateRefund(signId);
            this.refundTask.refund(pay);
        }
    }

    private Pay validateRefund(String signId) {
        Sign sign = (Sign)this.signService.selectById((Object)signId);
        Shift.throwsIfNull((Object)sign, (String)"\u627e\u4e0d\u5230\u62a5\u540d");
        Shift.throwsIfInvalid((sign.getIsPay() == false ? 1 : 0) != 0, (String)"\u8be5\u62a5\u540d\u5c1a\u672a\u652f\u4ed8");
        Pay refund = (Pay)this.payService.select(JpaCriteria.builder().eq("scene", (Object)PaySceneEnum.REFUND.value()).eq("orderId", (Object)signId).eq("status", (Object)PayStatusEnum.SUCCESS.value()));
        Shift.throwsIfInvalid((refund != null ? 1 : 0) != 0, (String)"\u8be5\u62a5\u540d\u5df2\u7ecf\u9000\u8fc7\u6b3e\u4e86");
        Pay pay = (Pay)this.payService.select(JpaCriteria.builder().eq("scene", (Object)PaySceneEnum.TRADE.value()).eq("orderId", (Object)signId).eq("status", (Object)PayStatusEnum.SUCCESS.value()));
        Shift.throwsIfNull((Object)pay, (String)"\u8be5\u62a5\u540d\u5c1a\u672a\u652f\u4ed8");
        return pay;
    }

    public Sign selectSignByMemberId(String activityId, String memberId, Integer status) {
        return (Sign)super.select(JpaCriteria.builder().eq("appId", (Object)this.getAppId()).eq("sourceId", (Object)activityId).eq("status", (Object)status).eq("memberId", (Object)memberId).eq("type", (Object)SourceTypeEnum.ACTIVITY.getIndex()));
    }

    public List<String> selectDataIdBySourceId(String appId, String sourceId) {
        int status = SignStatusEnum.SIGN.getIndex();
        JpaCriteria criteria = JpaCriteria.builder().select("dataId").eq("appId", (Object)appId).eq("sourceId", (Object)sourceId).eq("status", (Object)status);
        return this.selectList(criteria, String.class);
    }

    private void saveCalendarEventIfAvailable(ActivitySignSetting signSetting, String memberId) {
        String activityId = signSetting.getActivityId();
        CalendarEvent calendarEvent = this.calendarEventService.selectBySourceId(activityId);
        if (calendarEvent != null) {
            MemberCalendarEvent memberCalendarEvent = new MemberCalendarEvent();
            memberCalendarEvent.setId(GuidGenerator.generate());
            memberCalendarEvent.setAppId(signSetting.getAppId());
            memberCalendarEvent.setCreateTime(new Date());
            memberCalendarEvent.setMemberId(memberId);
            memberCalendarEvent.setCalendarEventId(calendarEvent.getId());
            memberCalendarEvent.setRemaindTime(signSetting.getRemaindTime());
            memberCalendarEvent.setIsEnableSmsRemind(signSetting.getIsEnableSmsRemind());
            memberCalendarEvent.setIsEnableWxRemind(signSetting.getIsEnableWxRemind());
            memberCalendarEvent.setIsEnableWxTemplateRemind(signSetting.getIsEnableWxTemplateRemind());
            this.memberCalendarEventService.insert((Object)memberCalendarEvent);
        }
    }
}

