/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.task;

import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivityFee;
import com.wego168.activity.service.ActivityFeeService;
import com.wego168.activity.service.ActivityService;
import com.wego168.base.component.ActivitySignPaySubscriber;
import com.wego168.base.domain.Sign;
import com.wego168.base.service.AppAbilityService;
import com.wego168.util.InterfaceDispatcher;
import com.wego168.wxpay.domain.Pay;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ActivitySignPayPublisher {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityFeeService activityFeeService;
    @Autowired
    private AppAbilityService appAbilityService;

    @Async
    public void publishActivitySignPaymentAsync(Sign sign, Pay pay) {
        String memberId = sign.getMemberId();
        String activityId = sign.getSourceId();
        Activity activity = (Activity)((Object)this.activityService.selectById(activityId));
        if (activity != null) {
            String activityTitle = activity.getTitle();
            int payAmount = pay.getAmount();
            ActivityFee activityFee = this.activityFeeService.selectByActivityId(activityId);
            int signNum = sign.getOneSignManyNum() == null ? 1 : sign.getOneSignManyNum();
            int activityAmount = activityFee.getPrice() * signNum;
            Integer sharerCommission = (activityFee.getSharerCommission() == null ? 0 : activityFee.getSharerCommission()) * signNum;
            Integer sharerScore = (activityFee.getSharerPoint() == null ? 0 : activityFee.getSharerPoint()) * signNum;
            Integer distributerCommission = (activityFee.getDistributerCommission() == null ? 0 : activityFee.getDistributerCommission()) * signNum;
            Boolean commissionNeedAudit = activityFee.getDistributerCommissionNeedAudit();
            String appId = activity.getAppId();
            String signId = sign.getId();
            String activityImage = activity.getIconUrl();
            InterfaceDispatcher.builder().collect(ActivitySignPaySubscriber.class).forEach(e -> e.subscribeActivitySignPay(Integer.valueOf(payAmount), Integer.valueOf(activityAmount), distributerCommission, sharerCommission, sharerScore.intValue(), commissionNeedAudit, activityTitle, activityImage, memberId, signId, appId));
        }
    }

    @Async
    public void publishActivitySignFreeAsync(Sign sign) {
        String appId = sign.getAppId();
        if (!this.freeActivityCommissionEnabled(appId)) {
            return;
        }
        String memberId = sign.getMemberId();
        String activityId = sign.getSourceId();
        Activity activity = (Activity)((Object)this.activityService.selectById(activityId));
        if (activity != null) {
            String activityTitle = activity.getTitle();
            int payAmount = 0;
            ActivityFee activityFee = this.activityFeeService.selectByActivityId(activityId);
            int activityAmount = 0;
            Integer sharerCommission = activityFee.getSharerCommission();
            int sharerScore = 0;
            Integer distributerCommission = 0;
            Boolean commissionNeedAudit = activityFee.getDistributerCommissionNeedAudit();
            String signId = sign.getId();
            String activityImage = activity.getIconUrl();
            InterfaceDispatcher.builder().collect(ActivitySignPaySubscriber.class).forEach(e -> e.subscribeActivitySignPay(Integer.valueOf(payAmount), Integer.valueOf(activityAmount), distributerCommission, sharerCommission, sharerScore, commissionNeedAudit, activityTitle, activityImage, memberId, signId, appId));
        }
    }

    private boolean freeActivityCommissionEnabled(String appId) {
        boolean open = this.appAbilityService.isOpen(appId, "share-activity-free-commission");
        return open;
    }
}

