/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Attachment;
import com.wego168.base.service.AttachmentService;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.Checker;
import com.wego168.util.Shift;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/v1/appAttachment"})
public class AdminAppAttachmentController
extends SimpleController {
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private AuthenticationUser authenticationUser;

    @PostMapping(value={"/insert"})
    public RestResponse insertAppAttachment(String name, String url, String href, String categoryId, Integer seqNum, String note) {
        this.checkInsertParameter(name, seqNum);
        String appId = this.authenticationUser.getAppId();
        Long fileSize = (Long)this.simpleRedisTemplate.get(url, Long.class);
        fileSize = fileSize == null ? 0L : fileSize;
        Attachment attachment = AttachmentService.create((String)appId, (String)categoryId, (String)name, (String)href, (String)url, (String)note, (int)seqNum, (long)fileSize);
        this.attachmentService.insert((Object)attachment);
        return RestResponse.success((Object)attachment);
    }

    @PostMapping(value={"/delete"})
    public RestResponse deleteAppAttachment(String id) {
        Checker.checkBlank((String)id, (String)"id");
        this.attachmentService.deleteById((Object)id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/update"})
    public RestResponse updateAppAttachment(String name, String url, String href, Integer seqNum, String note, String id) {
        this.checkUpdateParameter(name, url, href, seqNum, note, id);
        Long fileSize = (Long)this.simpleRedisTemplate.get(url, Long.class);
        this.attachmentService.update(name, url, href, seqNum.intValue(), note, fileSize, id);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/page"})
    public RestResponse listAppAttachment(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.orderBy("seq_num");
        List list = this.attachmentService.selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/get"})
    public RestResponse getAppAttachment(String id) {
        Checker.checkBlank((String)id, (String)"id");
        Attachment attachment = (Attachment)this.attachmentService.selectById((Object)id);
        return RestResponse.success((Object)attachment);
    }

    @PostMapping(value={"/connectAttachmemt"})
    public RestResponse connectAttachmemt(String id, String href) {
        Checker.checkBlank((String)id, (String)"\u5e7f\u544a\u4f4d");
        Attachment attachment = (Attachment)this.attachmentService.selectById((Object)id);
        Shift.throwsIfInvalid((attachment == null || attachment.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u5e7f\u544a\u4f4d\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        attachment.setHref(href);
        this.attachmentService.updateSelective((Object)attachment);
        return RestResponse.success((String)"\u5173\u8054\u6210\u529f");
    }

    private void checkInsertParameter(String name, Integer seqNum) {
        Checker.checkBlank((String)name, (String)"\u540d\u79f0");
        Checker.checkNull((Object)seqNum, (String)"\u5e8f\u53f7");
    }

    private void checkUpdateParameter(String name, String url, String href, Integer seqNum, String note, String id) {
        Checker.checkBlank((String)name, (String)"\u540d\u79f0");
        Checker.checkBlank((String)url, (String)"\u8def\u5f84");
        Checker.checkBlank((String)id, (String)"id");
        Checker.checkNull((Object)seqNum, (String)"\u5e8f\u53f7");
    }
}

