/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.base.domain.FileServer;
import com.wego168.base.service.FileServerService;
import com.wego168.coweb.domain.BusinessCardBackground;
import com.wego168.coweb.domain.BusinessCardStyleTemplate;
import com.wego168.coweb.model.response.BusinessCardBackgroundResponse;
import com.wego168.coweb.service.BusinessCardBackgroundService;
import com.wego168.coweb.service.BusinessCardStyleTemplateService;
import com.wego168.domain.BaseDomain;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.validation.constraints.NotBlankOrLength;
import com.wego168.validation.constraints.UnsignedInteger;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class AdminBusinessCardBackgroundController
extends SimpleController {
    @Autowired
    private BusinessCardBackgroundService service;
    @Autowired
    private BusinessCardStyleTemplateService templateService;
    @Autowired
    private FileServerService fileServerService;

    @PostMapping(value={"/api/admin/v1/business-card-background/insert"})
    public RestResponse insert(@RequestParam(name="sortNumber") @UnsignedInteger(message="\u5e8f\u53f7\u975e\u6cd5") String sortNumberString, @NotBlankAndLength(min=1, max=256, message="\u80cc\u666f\u56fe\u8def\u5f84\u975e\u6cd5") String url, @NotBlankAndLength(message="\u6a21\u7248\u975e\u6cd5") String templateId) {
        BusinessCardStyleTemplate template;
        FileServer fileServer = this.fileServerService.ensure();
        int sortNumber = 0;
        if (StringUtil.isNotBlank((String)sortNumberString)) {
            sortNumber = Integer.parseInt(sortNumberString);
        }
        Checker.checkCondition(((template = (BusinessCardStyleTemplate)((Object)this.templateService.selectById(templateId))) == null ? 1 : 0) != 0, (String)"\u8be5\u6a21\u677f\u4e0d\u5b58\u5728");
        BusinessCardBackground background = new BusinessCardBackground();
        BaseDomainUtil.initBaseDomain((BaseDomain)background, (String)template.getAppId());
        background.setServerId(fileServer.getId());
        background.setSortNumber(sortNumber);
        background.setTemplateId(templateId);
        background.setUrl(url);
        this.service.insert((Object)background);
        return RestResponse.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/business-card-background/update"})
    public RestResponse update(@NotBlankAndLength String id, @RequestParam(name="sortNumber") @UnsignedInteger(message="\u5e8f\u53f7\u975e\u6cd5") String sortNumberString, @NotBlankAndLength(min=1, max=256, message="\u80cc\u666f\u56fe\u8def\u5f84\u975e\u6cd5") String url, @NotBlankAndLength(message="\u6a21\u7248\u975e\u6cd5") String templateId) {
        BusinessCardStyleTemplate template;
        int sortNumber = 0;
        if (StringUtil.isNotBlank((String)sortNumberString)) {
            sortNumber = Integer.parseInt(sortNumberString);
        }
        Checker.checkCondition(((template = (BusinessCardStyleTemplate)((Object)this.templateService.selectById(templateId))) == null ? 1 : 0) != 0, (String)"\u8be5\u6a21\u677f\u4e0d\u5b58\u5728");
        BusinessCardBackground param = new BusinessCardBackground();
        param.setId(id);
        param.setSortNumber(sortNumber);
        param.setTemplateId(templateId);
        param.setUrl(url);
        param.setUpdateTime(new Date());
        this.service.updateSelective((Object)param);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/business-card-background/delete"})
    public RestResponse delete(@NotBlankAndLength String id) {
        this.service.deleteById(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/business-card-background/page"})
    public RestResponse selectPage(@NotBlankOrLength(message="\u6a21\u677f\u975e\u6cd5") String templateId, HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<BusinessCardBackgroundResponse> list = this.service.selectPageForAdmin(templateId, this.getAppId(), page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }
}

