/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import com.wego168.coweb.domain.BusinessCardStyleTemplate;
import com.wego168.coweb.enums.BusinessCardTemplateVisibility;
import com.wego168.coweb.model.response.BusinessCardStyleTemplateResponse;
import com.wego168.coweb.service.BusinessCardStyleTemplateService;
import com.wego168.util.Checker;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class AdminBusinessCardStyleTemplateController
extends SimpleController {
    @Autowired
    private BusinessCardStyleTemplateService service;

    @GetMapping(value={"/api/admin/v1/business-card-style-template/list"})
    public RestResponse selectList() {
        String appId = this.getAppId();
        List<BusinessCardStyleTemplate> list = this.service.selectListByAppId(appId);
        return RestResponse.success(this.toResponseList(list), (String)"ok");
    }

    @PostMapping(value={"/api/admin/v1/business-card-style-template/update-visibility"})
    public RestResponse hide(@NotBlankAndLength String id, String visibility) {
        Checker.checkInRange((Object)((Object)BusinessCardTemplateVisibility.get(visibility)), (Object[])BusinessCardTemplateVisibility.values(), (String)"\u9519\u8bef\u7684\u53ef\u89c1\u6027");
        BusinessCardStyleTemplate param = new BusinessCardStyleTemplate();
        param.setId(id);
        param.setUpdateTime(new Date());
        param.setVisibility(visibility);
        this.service.updateSelective((Object)param);
        return RestResponse.success((String)"ok");
    }

    private List<BusinessCardStyleTemplateResponse> toResponseList(List<BusinessCardStyleTemplate> list) {
        if (Checker.listNotEmpty(list)) {
            ArrayList<BusinessCardStyleTemplateResponse> responseList = new ArrayList<BusinessCardStyleTemplateResponse>(list.size());
            for (BusinessCardStyleTemplate templateDb : list) {
                responseList.add(new BusinessCardStyleTemplateResponse(templateDb));
            }
            return responseList;
        }
        return null;
    }
}

