/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.simple.mybatis.Page;
import com.wego168.base.util.FileUtil;
import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.provider.ImportProvider;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class AdminClassAndGradeController
extends CrudController<ClassAndGrade> {
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private ImportProvider importProvider;

    public CrudService<ClassAndGrade> getService() {
        return this.classAndGradeService;
    }

    @PostMapping(value={"/api/admin/v1/class/importData"})
    public RestResponse importData(@Valid MultipartFile file) {
        ArrayList<ClassAndGrade> list = new ArrayList();
        try {
            list = FileUtil.importExcel((MultipartFile)file, (ImportParams)new ImportParams(), ClassAndGrade.class);
        }
        catch (Exception e) {
            return RestResponse.error((String)e.getMessage());
        }
        Shift.throwsIfEmpty(list, (String)"\u6570\u636e\u4e3a\u7a7a\u6216\u5f02\u5e38");
        Map<String, Object> map = this.importProvider.importClassByDefaultDataProcessing(list);
        return RestResponse.success(map);
    }

    @PostMapping(value={"/api/admin/v1/class/insert"})
    public RestResponse insert(ClassAndGrade classAndGrade, HttpServletRequest request) {
        Shift.throwsIfInvalid((StringUtil.isBlank((String)classAndGrade.getDegreeId()) && StringUtil.isBlank((String)classAndGrade.getDepartmentId()) && StringUtil.isBlank((String)classAndGrade.getProfessionId()) && StringUtil.isBlank((String)classAndGrade.getClassName()) && StringUtil.isBlank((String)classAndGrade.getYear()) ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u53c2\u6570");
        this.classAndGradeService.insertClassAndGrade(classAndGrade);
        return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/class/update"})
    public RestResponse update(ClassAndGrade classAndGrade, HttpServletRequest request, HttpServletResponse response) {
        Checker.checkBlank((String)classAndGrade.getId(), (String)"\u73ed\u7ea7");
        ClassAndGrade oldClassAndGrade = (ClassAndGrade)((Object)this.classAndGradeService.selectById(classAndGrade.getId()));
        Shift.throwsIfInvalid((oldClassAndGrade == null || oldClassAndGrade.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        String fullClassName = this.classAndGradeService.generateClassName(classAndGrade);
        ClassAndGrade vo = this.classAndGradeService.selectByClassName(fullClassName);
        Shift.throwsIfInvalid((vo != null && !StringUtils.equals((CharSequence)classAndGrade.getId(), (CharSequence)vo.getId()) ? 1 : 0) != 0, (String)"\u8be5\u73ed\u7ea7\u5df2\u5b58\u5728");
        classAndGrade.setId(oldClassAndGrade.getId());
        classAndGrade.setClassName(fullClassName);
        classAndGrade.setUpdateTime(new Date());
        this.classAndGradeService.updateSelective((Object)classAndGrade);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/class/page"})
    public RestResponse page(HttpServletRequest request, HttpServletResponse response) {
        Page page = this.buildPage(request);
        page.ne("id", (Object)"admin").orderBy("seq_num,class_name");
        List list = this.classAndGradeService.selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/class/list"})
    public RestResponse list(HttpServletRequest request, HttpServletResponse response) {
        Page page = this.buildPage(request);
        page.setPageNum(1);
        page.setPageSize(Integer.MAX_VALUE);
        page.ne("id", (Object)"admin").orderBy("seq_num,class_name");
        List list = this.classAndGradeService.selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/class/get"})
    public RestResponse get(String id, HttpServletRequest request, HttpServletResponse response) {
        return super.get(id);
    }

    @PostMapping(value={"/api/admin/v1/class/refresh"})
    public RestResponse refreshClassMemberAmount() {
        this.classAndGradeService.refreshClassMemberAmount();
        return RestResponse.success((String)"\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/class/delete"})
    public RestResponse delete(String id, HttpServletRequest request) {
        ClassAndGrade classAndGrade = (ClassAndGrade)((Object)this.classAndGradeService.selectById(id));
        Shift.throwsIfInvalid((classAndGrade == null || classAndGrade.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Shift.throwsIfInvalid((classAndGrade.getClassMemberAmount() > 0 ? 1 : 0) != 0, (String)"\u8be5\u73ed\u7ea7\u5b58\u5728\u6821\u53cb\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        this.classAndGradeService.updateDelete(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

