/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Comment;
import com.wego168.base.domain.Config;
import com.wego168.base.domain.SourceData;
import com.wego168.base.enums.CommentAuditStatusEnum;
import com.wego168.base.service.CommentService;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.SourceDataService;
import com.wego168.bbs.controller.AdminCommentControllerSupport;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.service.BBSCommentService;
import com.wego168.bbs.service.InformationService;
import com.wego168.coweb.enums.CommentSourceTypeEnum;
import com.wego168.coweb.service.MyCommentService;
import com.wego168.domain.GenericDomain;
import com.wego168.util.IntegerUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.StatusCode;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="communityAdminCommentController")
public class AdminCommentController
extends AdminCommentControllerSupport {
    @Autowired
    private CommentService commentService;
    @Autowired
    private BBSCommentService bbsCommentService;
    @Autowired
    private MyCommentService myCommentService;
    @Autowired
    private SourceDataService sourceDataService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private AuthenticationUser authenticationUser;

    @GetMapping(value={"/api/admin/comment/v1/pageByDate"})
    public RestResponse selectPageByDate(String startDate, String endDate, HttpServletRequest request, HttpServletResponse response) {
        return super.selectCommentPageByDate(startDate, endDate, request, response);
    }

    @GetMapping(value={"/api/admin/comment/v1/page"})
    public RestResponse selectPage(String sourceId, HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<Comment> list = this.myCommentService.selectPageWithoutSubComments(sourceId, CommentAuditStatusEnum.AUDITED.value(), page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/comment/v1/get"})
    public RestResponse selectComment(String id) {
        return super.get(id);
    }

    @PostMapping(value={"/api/admin/comment/v1/audit"})
    public RestResponse auditComment(@NotBlankAndLength String id) {
        String userId = this.authenticationUser.getUserId();
        RestResponse response = super.auditComment(id, userId);
        return response;
    }

    @PostMapping(value={"/api/admin/comment/v1/refuse"})
    public RestResponse refuseComment(String id) {
        String userId = this.authenticationUser.getUserId();
        return super.refuseComment(id, userId);
    }

    @PostMapping(value={"/api/admin/comment/v1/delete"})
    public RestResponse deleteComment(String id) {
        RestResponse restResponse = super.deleteComment(id);
        if (restResponse.getCode() == StatusCode.OK.code()) {
            Config config = this.configService.getByKey("heat_rate");
            String[] scoreValue = config.getValue().split("_");
            Integer score = Integer.valueOf(scoreValue[2]);
            this.sourceDataService.updateHeatRate(id, Integer.valueOf(-score.intValue()));
        }
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    protected CommentService getCommentService() {
        return this.commentService;
    }

    protected BBSCommentService getBBSCommentService() {
        return this.bbsCommentService;
    }

    protected GenericDomain sourceIsValid(String sourceId, Integer sourceType) {
        Information information;
        SourceData sourceData;
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.BBS_INFORMATION.value()) && (sourceData = this.sourceDataService.selectBySourceId(sourceId)) != null && (information = (Information)this.informationService.selectById((Object)sourceId)) != null) {
            return sourceData;
        }
        return null;
    }
}

