/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.interceptor.ApiLog;
import com.wego168.base.util.FileUtil;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.ContactsSetting;
import com.wego168.coweb.provider.ExportProvider;
import com.wego168.coweb.provider.ImportProvider;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.ContactsSettingService;
import com.wego168.member.domain.PersonalityLabel;
import com.wego168.member.model.PersonalityLabelImportModel;
import com.wego168.member.model.response.PersonalityLabelMemberPageResponse;
import com.wego168.member.service.impl.MemberLevelJoinService;
import com.wego168.member.service.impl.PersonalityLabelService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class AdminContactsController
extends CrudController<Contacts> {
    private final Logger logger = LoggerFactory.getLogger(AdminContactsController.class);
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private ImportProvider importProvider;
    @Autowired
    private ContactsSettingService contactsSettingService;
    @Autowired
    private ExportProvider exportProvider;
    @Autowired
    private PersonalityLabelService personalityLabelService;
    @Autowired
    private MemberLevelJoinService memberLevelJoinService;

    public CrudService<Contacts> getService() {
        return this.contactsService;
    }

    @PostMapping(value={"/api/admin/v1/contacts/deleteMemberLevel"})
    public RestResponse deleteMemberLevel(@RequestParam(required=true, name="id") String id, @RequestParam(name="transferMember") Boolean transferMember, @RequestParam(value="newId") String newId) {
        String appId = this.getAppId();
        return RestResponse.success((Object)this.contactsService.deleteMemberLevel(id, transferMember, newId, appId));
    }

    @ApiLog(value="\u5ba1\u6838\u6821\u53cb")
    @PostMapping(value={"/api/admin/v1/contacts/audit"})
    public RestResponse auditContacts(Integer status, String id) {
        Contacts contacts = (Contacts)((Object)this.contactsService.selectById(id));
        Shift.throwsIfNull((Object)((Object)contacts), (String)"\u627e\u4e0d\u5230\u8be5\u6821\u53cb");
        contacts.setStatus(status);
        this.contactsService.auditContacts(contacts);
        return RestResponse.success((String)"\u5ba1\u6838\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v2/contacts/template"})
    public void templatev2(HttpServletRequest request, HttpServletResponse response) {
        List<ContactsSetting> list = this.contactsSettingService.getField();
        ArrayList<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
        ArrayList lists = new ArrayList();
        HashSet<String> set = new HashSet<String>();
        set.add("\u5165\u5b66\u65f6\u95f4");
        set.add("\u5b66\u4f4d");
        set.add("\u7cfb\u522b");
        set.add("\u6807\u7b7e");
        set.add("\u7b49\u7ea7/\u5934\u8854");
        set.add("\u5230\u671f\u65f6\u95f4");
        for (ContactsSetting contactsSetting : list) {
            set.add(contactsSetting.getFieldName());
        }
        for (String str : set) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(str);
            excelExportEntity.setWidth(25.0);
            entity.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u62a5\u540d\u5217\u8868");
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entity, lists);
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u901a\u8baf\u5f55\u5bfc\u5165\u6a21\u677f.xls", "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @PostMapping(value={"/api/admin/v1/contacts/importData"})
    public RestResponse importData(@Valid MultipartFile file, HttpServletRequest request) {
        ArrayList<Contacts> list = new ArrayList();
        long start = new Date().getTime();
        try {
            list = FileUtil.importExcel((MultipartFile)file, (ImportParams)new ImportParams(), Contacts.class);
        }
        catch (Exception e) {
            return RestResponse.error((String)e.getMessage());
        }
        Shift.throwsIfEmpty(list, (String)"\u6570\u636e\u4e3a\u7a7a\u6216\u5f02\u5e38");
        long end = new Date().getTime();
        String time = String.valueOf(end - start);
        this.logger.error("importData time =========== " + time);
        Map<String, Object> result = this.importProvider.importContactsByDefaultDataProcessing(list);
        Integer importCount = (Integer)result.get("importCount");
        if (importCount != null) {
            return RestResponse.success((String)("\u5bfc\u5165\u6210\u529f,\u672c\u6b21\u65b0\u589e " + importCount + " \u6761\u6570\u636e"));
        }
        return RestResponse.error((Object)result.get("errMap"));
    }

    @GetMapping(value={"/api/admin/v1/contacts/exportData"})
    public void exportList(HttpServletRequest request, HttpServletResponse response) {
        try {
            List<ContactsSetting> contactsSettings = this.contactsSettingService.getField();
            JpaCriteria jpaCriteria = JpaCriteria.builder();
            jpaCriteria.select(this.builderSelectField(contactsSettings));
            Page page = this.buildPage(request);
            page.setPageSize(Integer.MAX_VALUE);
            page.setCount(false);
            List<Contacts> list = this.contactsService.selectPageByAdmin(page);
            ExportParams exportParams = new ExportParams(null, null);
            ArrayList<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
            List<ContactsSetting> contactsSettingsList = this.contactsSettingService.getExportField();
            for (ContactsSetting contactsSetting : contactsSettingsList) {
                if (StringUtil.equals((String)contactsSetting.getFieldId(), (String)"departmentName") || StringUtil.equals((String)contactsSetting.getFieldId(), (String)"year") || StringUtil.equals((String)contactsSetting.getFieldId(), (String)"degreeName")) continue;
                entity.add(new ExcelExportEntity(contactsSetting.getFieldName(), (Object)contactsSetting.getFieldId(), 20));
            }
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entity, this.exportProvider.builderExportParam(list));
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u6821\u53cb\u5e93\u5bfc\u51fa.xls", "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
    }

    @GetMapping(value={"/api/admin/v1/contacts/page"})
    public RestResponse page(Contacts contacts, HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<Contacts> list = this.contactsService.selectPageByAdmin(page);
        for (Contacts c : list) {
            String memberId = c.getMemberId();
            if (StringUtil.isNotBlank((String)memberId)) {
                contacts.setMemberLevelJoin(this.memberLevelJoinService.findByMemberId(memberId));
            }
            String labelOrderBy = "newFirst";
            this.assemblePersonalityLabelIfNecessary2(c, labelOrderBy);
            if (StringUtil.isBlank((String)c.getMemberId()) && StringUtil.isNotBlank((String)c.getTagName())) {
                String tagName = c.getTagName();
                String[] tagNames = tagName.split("/");
                ArrayList<PersonalityLabelMemberPageResponse> pList = new ArrayList<PersonalityLabelMemberPageResponse>();
                for (String s : tagNames) {
                    PersonalityLabel pl = new PersonalityLabel();
                    pl.setId(SequenceUtil.createUuid());
                    pl.setName(s);
                    pl.setSortNumber(Integer.valueOf(0));
                    pList.add(new PersonalityLabelMemberPageResponse(pl));
                }
                c.setLabels(pList);
            }
            this.contactsService.setMemberLevelInfo(c);
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/contacts/get"})
    public RestResponse getContact(String id) {
        Contacts contacts = (Contacts)((Object)this.contactsService.selectById(id));
        String memberId = contacts.getMemberId();
        if (StringUtil.isNotBlank((String)memberId)) {
            contacts.setMemberLevelJoin(this.memberLevelJoinService.findByMemberId(memberId));
        }
        String labelOrderBy = "newFirst";
        this.assemblePersonalityLabelIfNecessary2(contacts, labelOrderBy);
        if (StringUtil.isBlank((String)contacts.getMemberId()) && StringUtil.isNotBlank((String)contacts.getTagName())) {
            String tagName = contacts.getTagName();
            String[] tagNames = tagName.split("/");
            ArrayList<PersonalityLabelMemberPageResponse> pList = new ArrayList<PersonalityLabelMemberPageResponse>();
            for (String s : tagNames) {
                PersonalityLabelMemberPageResponse plmp = new PersonalityLabelMemberPageResponse();
                plmp.setId(SequenceUtil.createUuid());
                plmp.setName(s);
                plmp.setSortNumber(Integer.valueOf(0));
                pList.add(plmp);
            }
            contacts.setLabels(pList);
        }
        this.contactsService.setMemberLevelInfo(contacts);
        return RestResponse.success((Object)((Object)contacts));
    }

    @PostMapping(value={"/api/admin/v1/contacts/insert"})
    public RestResponse insert(@RequestBody Contacts contacts, HttpServletRequest request) {
        Checker.checkBlank((String)contacts.getName(), (String)"\u59d3\u540d");
        Checker.checkBlank((String)contacts.getPhone(), (String)"\u624b\u673a");
        Checker.checkBlank((String)contacts.getClassId(), (String)"\u73ed\u7ea7");
        this.contactsService.insertContacts(contacts);
        return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/contacts/update"})
    public RestResponse update(@RequestBody Contacts contacts, HttpServletRequest request) {
        this.contactsService.updateContactsByAdmin(contacts);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/contacts/updateTagName"})
    public RestResponse updateTagName(String tagName, String id) {
        Contacts vo = (Contacts)((Object)this.contactsService.selectById(id));
        String voTagName = vo.getTagName();
        if (StringUtil.isNotBlank((String)voTagName) && voTagName.split("/").length + 1 > 3) {
            Shift.throwsIfInvalid((boolean)true, (String)"\u4e0d\u53ef\u4ee5\u7ee7\u7eed\u6dfb\u52a0\u6807\u7b7e");
        }
        if (StringUtil.isBlank((String)voTagName)) {
            vo.setTagName(tagName);
        } else {
            vo.setTagName(voTagName + "/" + tagName);
        }
        return RestResponse.success((Object)this.contactsService.updateSelective((Object)vo));
    }

    @PostMapping(value={"/api/admin/v1/contacts/deleteTagName"})
    public RestResponse deleteTag(String tagName, String id) {
        Contacts vo = (Contacts)((Object)this.contactsService.selectById(id));
        String[] voTagName = vo.getTagName().split("/");
        String newTagName = "";
        for (int i = 0; i < voTagName.length; ++i) {
            if (tagName.equals(voTagName[i])) continue;
            newTagName = newTagName + voTagName[i];
            if (voTagName.length - 1 >= i) continue;
            newTagName = newTagName + "/";
        }
        vo.setTagName(newTagName);
        return RestResponse.success((Object)this.contactsService.updateSelective((Object)vo));
    }

    @PostMapping(value={"/api/admin/v1/contacts/delete"})
    public RestResponse delete(String id, HttpServletRequest request) {
        Contacts vo = this.contactsService.selectContactsById(id);
        this.contactsService.deleteContacts(vo);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/contacts/isFrozen"})
    public RestResponse frozen(String id, Boolean isFrozen) {
        Contacts contacts = (Contacts)((Object)this.contactsService.selectById(id));
        Shift.throwsIfInvalid((contacts == null || contacts.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        this.contactsService.frozen(contacts, isFrozen);
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/contacts/refreshMembershipStatus"})
    public RestResponse refreshMembershipStatus(HttpServletRequest request) {
        this.contactsService.updateMembershipStatus();
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/contacts/template"})
    public void template(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<Contacts> list = new ArrayList<Contacts>(1);
        list.add(new Contacts());
        ExportParams exportParams = new ExportParams(null, null);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, Contacts.class, list);
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u901a\u8baf\u5f55\u5bfc\u5165\u6a21\u677f.xls", "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @GetMapping(value={"/api/admin/v1/contacts/checkRealName"})
    public RestResponse checkRealName(String memberId) {
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        Shift.throwsIfInvalid((contacts == null || contacts.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        contacts.setIsReal(1);
        this.contactsService.updateSelective((Object)contacts);
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    private String builderSelectField(List<ContactsSetting> contactsSettings) {
        int index = contactsSettings.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < contactsSettings.size(); ++i) {
            sb.append("c.");
            sb.append(contactsSettings.get(i).getFieldId());
            if (i + 1 == index) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @PostMapping(value={"/api/admin/v1/contacts/importPersonalityLabel"})
    public RestResponse importPersonalityLabel(@Valid @RequestParam(name="file") MultipartFile file) {
        if (null == file || file.getSize() == 0L) {
            return RestResponse.error((String)"\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u4e3a\u7a7a");
        }
        List list = FileUtil.importExcel((MultipartFile)file, (ImportParams)new ImportParams(), PersonalityLabelImportModel.class);
        if (list == null || list.size() == 0) {
            return RestResponse.error((String)"\u5bfc\u5165\u5931\u8d25");
        }
        this.contactsService.importPersonalityLabel(list);
        return RestResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/contacts/importPersonalityLabelTemplate"})
    public void importPersonalityLabelTemplate(HttpServletResponse response) {
        ArrayList memberLevelModels = new ArrayList();
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), PersonalityLabelImportModel.class, memberLevelModels);
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u4f1a\u5458\u6807\u7b7e\u6a21\u677f.xls", "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            Shift.throwsIfInvalid((boolean)true, (String)"\u4f1a\u5458\u6807\u7b7e\u6a21\u677f");
        }
    }

    private void assemblePersonalityLabelIfNecessary2(Contacts contacts, String labelOrderBy) {
        if (contacts == null) {
            return;
        }
        String appId = contacts.getAppId();
        boolean assemble = this.needAssemblePersonalityLabel(appId);
        if (!assemble) {
            return;
        }
        ArrayList<Contacts> list = new ArrayList<Contacts>();
        list.add(contacts);
        Map map = this.personalityLabelService.selectMapInMemberIdList(list, labelOrderBy);
        String memberId = contacts.getMemberId();
        if (StringUtil.isBlank((String)memberId)) {
            return;
        }
        List memberLabelList = (List)map.get(memberId);
        if (Checker.listNotEmpty((List)memberLabelList)) {
            ArrayList<PersonalityLabelMemberPageResponse> responseLabelList = new ArrayList<PersonalityLabelMemberPageResponse>(memberLabelList.size());
            for (PersonalityLabel labelDb : memberLabelList) {
                responseLabelList.add(new PersonalityLabelMemberPageResponse(labelDb));
            }
            contacts.setLabels(responseLabelList);
        }
    }

    private boolean needAssemblePersonalityLabel(String appId) {
        return true;
    }
}

