/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.simple.mybatis.JpaCriteria;
import com.wego168.base.util.FileUtil;
import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.Profession;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.ProfessionService;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class AdminContactsTempController
extends CrudController<Contacts> {
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private ProfessionService professionService;

    public CrudService<Contacts> getService() {
        return this.contactsService;
    }

    @GetMapping(value={"/api/admin/v1/contacts/tempExportData"})
    public void exportList(HttpServletRequest request, HttpServletResponse response) {
        ArrayList list = new ArrayList(5000);
        List classAndGrades = this.classAndGradeService.selectList(JpaCriteria.builder().eq("isDeleted", (Object)false).ne("id", (Object)"admin").orderBy("seq_num,class_name"));
        for (ClassAndGrade classAndGrade : classAndGrades) {
            List tempList = this.contactsService.selectList(JpaCriteria.builder().eq("classAndGrade", (Object)classAndGrade.getClassName()).eq("isDeleted", (Object)false).orderBy("name_initial"));
            list.addAll(tempList);
        }
        ExportParams exportParams = new ExportParams(null, null);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, Contacts.class, list);
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u6821\u53cb\u5e93\u5bfc\u51fa.xls", "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @GetMapping(value={"/api/admin/v1/contacts/temp"})
    public RestResponse test() {
        Map<String, Profession> professionMap = this.professionService.getProfessionMap();
        return RestResponse.success(professionMap);
    }

    @PostMapping(value={"/api/admin/v1/contacts/testImport"})
    public RestResponse test(@Valid MultipartFile file) {
        List list = new ArrayList();
        try {
            list = FileUtil.importExcel((MultipartFile)file, (ImportParams)new ImportParams(), Contacts.class);
        }
        catch (Exception e) {
            return RestResponse.error((String)e.getMessage());
        }
        Shift.throwsIfEmpty(list, (String)"\u6570\u636e\u4e3a\u7a7a\u6216\u5f02\u5e38");
        HashMap<String, AbstractSet> map = new HashMap<String, AbstractSet>();
        HashSet<String> degreeSet = new HashSet<String>();
        HashSet<String> departmentSet = new HashSet<String>();
        HashSet<String> professionSet = new HashSet<String>();
        TreeSet<String> yearSet = new TreeSet<String>();
        for (Contacts contacts : list) {
            yearSet.add(contacts.getYear());
            degreeSet.add(contacts.getDegreeName());
            departmentSet.add(contacts.getDepartmentName());
            professionSet.add(contacts.getProfessionName());
        }
        map.put("degreeSet", degreeSet);
        map.put("departmentSet", departmentSet);
        map.put("professionSet", professionSet);
        map.put("yearSet", yearSet);
        return RestResponse.success(map);
    }
}

