/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.coweb.domain.Donate;
import com.wego168.coweb.service.DonateService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class AdminDonateController
extends CrudController<Donate> {
    @Autowired
    private DonateService donateService;

    public CrudService<Donate> getService() {
        return this.donateService;
    }

    @PostMapping(value={"/api/admin/v1/donate/insert"})
    public RestResponse insert(@Valid Donate donate, HttpServletRequest request) {
        Checker.checkBlank((String)donate.getTitle(), (String)"\u6807\u9898");
        Checker.checkBlank((String)donate.getContent(), (String)"\u6d3b\u52a8\u5185\u5bb9");
        Checker.checkBlank((String)donate.getSponsor(), (String)"\u4e3b\u529e\u65b9");
        Checker.checkBlank((String)donate.getCredentialContent(), (String)"\u8bc1\u4e66\u5185\u5bb9");
        Checker.checkNull((Object)donate.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4");
        this.donateService.insertDonate(donate);
        return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/donate/page"})
    public RestResponse page(HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<Donate> list = this.donateService.selectDonatePage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/donate/get"})
    public RestResponse get(String id) {
        Donate donate = this.donateService.selectDonateById(id);
        return RestResponse.success((Object)((Object)donate));
    }

    @PostMapping(value={"/api/admin/v1/donate/update"})
    public RestResponse update(Donate donate, HttpServletRequest request) {
        this.donateService.updateDonate(donate);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/donate/delete"})
    public RestResponse delete(String id, HttpServletRequest request) {
        Donate donate = (Donate)((Object)this.donateService.selectById(id));
        Shift.throwsIfInvalid((donate == null || donate.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        this.donateService.updateDelete(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

