/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.sdk.green.AliyunGreenSDK;
import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.bbs.controller.AdminInformationControllerSupport;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.enums.InformationAuditStatusEnum;
import com.wego168.bbs.service.BBSCommentService;
import com.wego168.bbs.service.BbsPointService;
import com.wego168.bbs.service.InformationService;
import com.wego168.bbs.service.ReportService;
import com.wego168.coweb.scheduler.Task;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class AdminInformationController
extends AdminInformationControllerSupport {
    @Autowired
    private InformationService informationService;
    @Autowired
    private BBSCommentService bbsCommentService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private Task task;
    @Autowired
    private BbsPointService bbsPointService;

    @PostMapping(value={"/api/admin/v1/information/save"})
    public RestResponse save(@Valid Information information, HttpServletRequest request, HttpServletResponse response) {
        Date createTime = new Date();
        return super.publishInformation(information, createTime);
    }

    @GetMapping(value={"/api/admin/v1/information/get"})
    public RestResponse get(String id) {
        return super.getInformation(id);
    }

    @GetMapping(value={"/api/admin/v1/information/auditPage"})
    public RestResponse auditPage(Integer pageNum, Integer pageSize, String areaId, String categoryId, String phone, String keyword, Integer type, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.initPage(pageNum, pageSize);
        List<Bootmap> list = super.selectPage(page, areaId, categoryId, phone, keyword, type, Integer.valueOf(InformationAuditStatusEnum.AUDIT.value()), null, Boolean.valueOf(true), null, request, response);
        list = this.addCommentAndReportToList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/information/unAutoAuditPage"})
    public RestResponse unAutoAuditPage(Integer pageNum, Integer pageSize, Boolean isAccepted, String areaId, String categoryId, String phone, String keyword, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.initPage(pageNum, pageSize);
        Integer auditStatus = null;
        auditStatus = isAccepted != false ? Integer.valueOf(InformationAuditStatusEnum.UNAUDIT.value()) : Integer.valueOf(InformationAuditStatusEnum.WAIT.value());
        List<Bootmap> list = super.selectPage(page, areaId, categoryId, phone, keyword, null, auditStatus, Boolean.valueOf(false), null, null, request, response);
        list = this.addCommentAndReportToList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/information/unReportAuditPage"})
    public RestResponse unReportAuditPage(Integer pageNum, Integer pageSize, Boolean isAccepted, String areaId, String categoryId, String phone, String keyword, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.initPage(pageNum, pageSize);
        List<Bootmap> list = super.selectPage(page, areaId, categoryId, phone, keyword, null, null, null, Boolean.valueOf(false), isAccepted, request, response);
        list = this.addCommentAndReportToList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/information/unAuditPage"})
    public RestResponse unAuditPage(Integer pageNum, Integer pageSize, String areaId, String categoryId, String phone, String keyword, Boolean isWait, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.initPage(pageNum, pageSize);
        Integer auditStatus = null;
        auditStatus = isWait != null && isWait != false ? Integer.valueOf(InformationAuditStatusEnum.WAIT.value()) : Integer.valueOf(InformationAuditStatusEnum.UNAUDIT.value());
        List<Bootmap> list = super.selectPage(page, areaId, categoryId, phone, keyword, null, auditStatus, null, null, null, request, response);
        list = this.addCommentAndReportToList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/admin/v1/information/update"})
    public RestResponse update(String id, String content, String imgUrl, String address, String phone, String areaCode, String appellation, Boolean isEnableCommentAudit, HttpServletResponse response) {
        isEnableCommentAudit = isEnableCommentAudit == null ? true : isEnableCommentAudit;
        Information information = (Information)this.getInformationService().selectById((Object)id);
        Shift.throwsIfInvalid((information == null || information.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        JSONObject jsonObject = AliyunGreenSDK.sendScanTask((String)information.getContent());
        Shift.throwsIfInvalid((boolean)StringUtil.equals((String)((String)jsonObject.get((Object)"suggestion")), (String)"block"), (String)"\u5185\u5bb9\u672a\u901a\u8fc7\u68c0\u6d4b");
        information.setContent(content);
        information.setImgUrl(imgUrl);
        information.setAddress(address);
        information.setPhone(phone);
        information.setAreaCode(areaCode);
        information.setAppellation(appellation);
        information.setIsEnableCommentAudit(isEnableCommentAudit);
        return super.updateInformation(information);
    }

    @PostMapping(value={"/api/admin/v1/information/delete"})
    public RestResponse delete(String id, HttpServletResponse response) {
        return super.deleteInformation(id);
    }

    @PostMapping(value={"/api/admin/v1/information/unaudit"})
    public RestResponse unaudit(@NotBlankAndLength String id) {
        Information information = (Information)this.informationService.selectById((Object)id);
        Checker.checkCondition((information == null ? 1 : 0) != 0, (String)"\u5ba1\u6838\u5931\u8d25\uff1a\u8be5\u54a8\u8be2\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        Integer auditStatus = information.getAuditStatus();
        boolean alreadyCanceled = IntegerUtil.equals((Integer)auditStatus, (Integer)InformationAuditStatusEnum.UNAUDIT.value());
        information = super.audit(id, Boolean.valueOf(false));
        this.task.sendInformationAuditTemple(information, "\u4e0a\u67b6\u5ba1\u6838", false);
        if (!alreadyCanceled) {
            this.bbsPointService.deductPublishTopicPointAsync(information);
        }
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/information/audit"})
    public RestResponse audit(@NotBlankAndLength String id) {
        Information information = (Information)this.informationService.selectById((Object)id);
        Checker.checkCondition((information == null ? 1 : 0) != 0, (String)"\u5ba1\u6838\u5931\u8d25\uff1a\u8be5\u54a8\u8be2\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        Integer auditStatus = information.getAuditStatus();
        boolean alreadyAudited = IntegerUtil.equals((Integer)auditStatus, (Integer)InformationAuditStatusEnum.AUDIT.value());
        information = super.audit(information, Boolean.valueOf(true));
        this.task.sendInformationAuditTemple(information, "\u4e0a\u67b6\u5ba1\u6838", true);
        if (!alreadyAudited) {
            this.bbsPointService.givePublishTopicPointAsync(information);
        }
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/information/reportAudit"})
    public RestResponse reportAudit(String id, HttpServletResponse response) {
        Information information = super.reportAudit(id, Boolean.valueOf(true));
        this.task.sendInformationAuditTemple(information, "\u4e3e\u62a5\u5ba1\u6838", true);
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/information/reportUnAudit"})
    public RestResponse reportUnAudit(String id, HttpServletResponse response) {
        Information information = super.reportAudit(id, Boolean.valueOf(false));
        this.task.sendInformationAuditTemple(information, "\u4e3e\u62a5\u5ba1\u6838", false);
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    private Page initPage(Integer pageNum, Integer pageSize) {
        Page page = new Page();
        page.setPageNum((pageNum == null ? page.getInteger("pageNum") : pageNum).intValue());
        page.setPageSize((pageSize == null ? page.getInteger("pageSize") : pageSize).intValue());
        return page;
    }

    private List<Bootmap> addCommentAndReportToList(List<Bootmap> list) {
        if (list != null && list.size() > 0) {
            list = this.bbsCommentService.addCommentToList(list, Integer.valueOf(Integer.MAX_VALUE));
            list = this.reportService.addReportToList(list, Integer.valueOf(Integer.MAX_VALUE));
        }
        return list;
    }

    protected InformationService getInformationService() {
        return this.informationService;
    }
}

