/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.coweb.domain.MembershipRecord;
import com.wego168.coweb.service.MembershipOrderService;
import com.wego168.coweb.service.MembershipRecordService;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminMembershipController
extends CrudController<MembershipRecord> {
    @Autowired
    private MembershipRecordService membershipRecordService;
    @Autowired
    private MembershipOrderService membershipOrderService;

    public CrudService<MembershipRecord> getService() {
        return this.membershipRecordService;
    }

    @GetMapping(value={"/api/admin/v1/membership/getRecord"})
    public RestResponse get(String studentId, HttpServletRequest request) {
        Map<String, List<String>> recordMap = this.membershipRecordService.getRecordByStudentId(studentId);
        return RestResponse.success(recordMap);
    }

    @PostMapping(value={"/api/admin/v1/membership/open"})
    public RestResponse open(String contactsId, String openYear, Integer amount, HttpServletRequest request) {
        Shift.throwsIfInvalid((this.membershipOrderService.checkYear(openYear) == false ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u5e74\u4efd");
        MembershipRecord record = this.membershipRecordService.selectByContactsIdAndOpenYear(contactsId, openYear);
        Shift.throwsIfInvalid((record != null ? 1 : 0) != 0, (String)("\u8be5\u7528\u6237\u5df2\u7ecf\u5f00\u901a\u8fc7" + openYear + "\u5e74\u4f1a\u7c4d\u4e86"));
        this.membershipOrderService.openMembershipByAdmin(contactsId, openYear, amount);
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/membershipOrder/page"})
    public RestResponse membershipOrder(HttpServletRequest request) {
        Page page = this.buildPage(request);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/activityOreder/page"})
    public RestResponse activityOreder() {
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

