/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.admin;

import com.wego168.base.domain.Config;
import com.wego168.base.domain.Content;
import com.wego168.base.interceptor.ApiLog;
import com.wego168.base.service.ContentService;
import com.wego168.coweb.enums.ConfigEnum;
import com.wego168.coweb.enums.CowebCheckEnum;
import com.wego168.coweb.enums.VerifyTypeEnum;
import com.wego168.coweb.service.MyConfigService;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.IntegerUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminMyConfigController
extends CrudController<Config> {
    @Autowired
    private MyConfigService myConfigService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private ContentService contentService;

    public CrudService<Config> getService() {
        return this.myConfigService;
    }

    @GetMapping(value={"/api/admin/v1/tradeConfig/get"})
    public RestResponse getTradeConfig(HttpServletRequest request, HttpServletResponse response) {
        Config config = this.myConfigService.getByKey("trade");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u884c\u4e1a");
        return RestResponse.success((Object)config);
    }

    @PostMapping(value={"/api/admin/v1/tradeConfig/update"})
    public RestResponse updateTradeConfig(String value, HttpServletRequest request, HttpServletResponse response) {
        Config config = this.myConfigService.getByKey("trade");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u884c\u4e1a");
        config.setValue(value);
        this.myConfigService.updateSelective(config);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/city/get"})
    public RestResponse getHotCity(HttpServletRequest request, HttpServletResponse response) {
        Config config = this.myConfigService.getByKey("hot_city");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u70ed\u95e8\u57ce\u5e02");
        return RestResponse.success((Object)config);
    }

    @PostMapping(value={"/api/admin/v1/city/update"})
    public RestResponse updateHotCity(String value, HttpServletRequest request, HttpServletResponse response) {
        Config config = this.myConfigService.getByKey("hot_city");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u70ed\u95e8\u57ce\u5e02");
        config.setValue(value);
        this.myConfigService.updateSelective(config);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/key/get"})
    public RestResponse getTemporaryKey(HttpServletRequest request, HttpServletResponse response) {
        String temporaryKey = SequenceUtil.createRandomNumberSequence((int)6);
        this.simpleRedisTemplate.setStringEx("temporaryKey", temporaryKey, 600L);
        return RestResponse.success((String)temporaryKey);
    }

    @GetMapping(value={"/api/admin/v1/membership/getAmount"})
    public RestResponse getAmount(HttpServletRequest request) {
        Config config = this.myConfigService.getByKey("membership_amount");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u4f1a\u8d39\u4ef7\u683c");
        return RestResponse.success((String)config.getValue());
    }

    @PostMapping(value={"/api/admin/v1/membership/update"})
    public RestResponse updateAmount(String value, HttpServletRequest request, HttpServletResponse response) {
        Config config = this.myConfigService.getByKey("membership_amount");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u4f1a\u8d39\u4ef7\u683c");
        config.setValue(value);
        this.myConfigService.updateSelective(config);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/verifyType/get"})
    public RestResponse getVerifyType(HttpServletRequest request) {
        Integer verifyType = this.myConfigService.getVerifyType();
        return RestResponse.success((Object)verifyType);
    }

    @PostMapping(value={"/api/admin/v1/verifyType/update"})
    public RestResponse updateVerifyType(String value, HttpServletRequest request, HttpServletResponse response) {
        Shift.throwsIfInvalid((!VerifyTypeEnum.isValid(Integer.valueOf(value)) ? 1 : 0) != 0, (String)"\u9a8c\u8bc1\u65b9\u5f0f\u914d\u7f6e\u9519\u8bef");
        Config config = this.myConfigService.getVerifyTypeConfig();
        config.setValue(value);
        this.myConfigService.updateSelective(config);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/appCustomer/get"})
    public RestResponse getAppCustomer() {
        return RestResponse.success((Object)this.myConfigService.getAppCustomer());
    }

    @ApiLog(value="\u66f4\u65b0\u5c0f\u7a0b\u5e8f\u5ba2\u670d")
    @PostMapping(value={"/api/admin/v1/appCustomer/saveOrUpdate"})
    public RestResponse saveAppCustomer(@RequestBody Config config) {
        this.myConfigService.saveOrUpdate(config);
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiLog(value="\u5f00\u542f\u4f1a\u5458\u6ce8\u518c\u5ba1\u6838")
    @PostMapping(value={"/api/admin/v1/registerAudit/saveOrUpdate"})
    public RestResponse saveOrUpdateRegisterAudit(@Valid @RequestBody Config config) {
        int cobweCheck = this.myConfigService.getCowebCheck();
        Shift.throwsIfInvalid((boolean)IntegerUtil.equals((Integer)CowebCheckEnum.AUTHENTICATE.value(), (Integer)cobweCheck), (String)"\u8ba4\u8bc1\u65b9\u5f0f\u4e0d\u652f\u6301\u5f00\u542f\u5ba1\u6838");
        if (StringUtil.isBlank((String)config.getId())) {
            this.myConfigService.insert(config);
        } else {
            this.myConfigService.update(config);
        }
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/coweb/getAboutUs"})
    public RestResponse get() {
        Config config = this.myConfigService.selectByKey(ConfigEnum.COWEB_ABOUT.name());
        Content content = new Content();
        if (config != null) {
            content = (Content)this.contentService.selectById((Object)config.getValue());
        }
        return RestResponse.success((Object)content);
    }

    @PostMapping(value={"/api/admin/v1/coweb/updateAboutUs"})
    public RestResponse update(String content) {
        Config config = this.myConfigService.selectByKey(ConfigEnum.COWEB_ABOUT.name());
        int row = 0;
        if (config != null) {
            Content ct = (Content)this.contentService.selectById((Object)config.getValue());
            ct.setContent(content);
            row = this.contentService.update((Object)ct);
        } else {
            Content ct = this.contentService.create(content, this.getAppId());
            this.contentService.insert((Object)ct);
            Config cg = this.myConfigService.create(0, ConfigEnum.COWEB_ABOUT.name(), "\u5173\u4e8e\u6211\u4eec", ct.getId(), null, 0, "", (short)0, false);
            row = this.myConfigService.insert(cg);
        }
        return super.responseByRows(row);
    }
}

