/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.mobile;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Comment;
import com.wego168.base.domain.Config;
import com.wego168.base.domain.SourceData;
import com.wego168.base.enums.CommentAuditStatusEnum;
import com.wego168.base.service.CommentService;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.SourceDataService;
import com.wego168.bbs.controller.AdminCommentControllerSupport;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.service.BBSCommentService;
import com.wego168.bbs.service.InformationService;
import com.wego168.coweb.enums.CommentSourceTypeEnum;
import com.wego168.coweb.service.MyCommentService;
import com.wego168.domain.GenericDomain;
import com.wego168.util.IntegerUtil;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.StatusCode;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MobileAdminCommentController
extends AdminCommentControllerSupport {
    @Autowired
    private CommentService commentService;
    @Autowired
    private BBSCommentService bbsCommentService;
    @Autowired
    private MyCommentService myCommentService;
    @Autowired
    private SourceDataService sourceDataService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private ConfigService configService;

    @GetMapping(value={"/api/mobileAdmin/v1/comment/pageByDate"})
    public RestResponse selectPageByDate(String startDate, String endDate, HttpServletRequest request, HttpServletResponse response) {
        return super.selectCommentPageByDate(startDate, endDate, request, response);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/comment/page"})
    public RestResponse selectPage(String sourceId, HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<Comment> list = this.myCommentService.selectPageWithoutSubComments(sourceId, CommentAuditStatusEnum.AUDITED.value(), page);
        list = this.myCommentService.convertFormat(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/mobileAdmin/v1/comment/delete"})
    public RestResponse deleteComment(String id) {
        RestResponse restResponse = super.deleteComment(id);
        if (restResponse.getCode() == StatusCode.OK.code()) {
            Config config = this.configService.getByKey("heat_rate");
            String[] scoreValue = config.getValue().split("_");
            Integer score = Integer.valueOf(scoreValue[2]);
            this.sourceDataService.updateHeatRate(id, Integer.valueOf(-score.intValue()));
        }
        return restResponse;
    }

    protected CommentService getCommentService() {
        return this.commentService;
    }

    protected BBSCommentService getBBSCommentService() {
        return this.bbsCommentService;
    }

    protected GenericDomain sourceIsValid(String sourceId, Integer sourceType) {
        Information information;
        SourceData sourceData;
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.BBS_INFORMATION.value()) && (sourceData = this.sourceDataService.selectBySourceId(sourceId)) != null && (information = (Information)this.informationService.selectById((Object)sourceId)) != null) {
            return sourceData;
        }
        return null;
    }
}

