/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.mobile;

import com.wego168.base.domain.Config;
import com.wego168.coweb.service.MyConfigService;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.web.response.RestResponse;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MobileAdminConfigController {
    @Autowired
    private MyConfigService myConfigService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;

    @GetMapping(value={"/api/mobileAdmin/v1/getConfigList"})
    public RestResponse getConfigList(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> map = this.myConfigService.getClassAndTradeList();
        return RestResponse.success(map);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/key/get"})
    public RestResponse getTemporaryKey(HttpServletRequest request, HttpServletResponse response) {
        String temporaryKey = SequenceUtil.createRandomNumberSequence((int)6);
        this.simpleRedisTemplate.setStringEx("temporaryKey", temporaryKey, 600L);
        return RestResponse.success((String)temporaryKey);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/profession/get"})
    public RestResponse getProfession(HttpServletRequest request) {
        Config config = this.myConfigService.getByKey("profession");
        Shift.throwsIfNull((Object)config, (String)"\u8bf7\u5148\u914d\u7f6e\u4e13\u4e1a");
        return RestResponse.success((String)config.getValue());
    }
}

