/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.mobile;

import com.simple.mybatis.Page;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.service.ContactsService;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MobileAdminContactsController
extends CrudController<Contacts> {
    @Autowired
    private ContactsService contactsService;

    public CrudService<Contacts> getService() {
        return this.contactsService;
    }

    @GetMapping(value={"/api/mobileAdmin/v1/contacts/page"})
    public RestResponse page(HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<Contacts> list = this.contactsService.selectPageByAdmin(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/contacts/get"})
    public RestResponse get(String id, String memberId) {
        Shift.throwsIfInvalid((StringUtil.isBlank((String)memberId) && StringUtil.isBlank((String)id) ? 1 : 0) != 0, (String)"\u53c2\u6570\u9519\u8bef");
        Contacts contacts = null;
        contacts = StringUtils.isBlank((CharSequence)id) ? this.contactsService.selectByMemberId(memberId) : this.contactsService.selectContactsById(id);
        return RestResponse.success((Object)((Object)contacts));
    }

    @PostMapping(value={"/api/mobileAdmin/v1/contacts/insert"})
    public RestResponse insert(@Valid Contacts contacts) {
        this.contactsService.insertContacts(contacts);
        return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/api/mobileAdmin/v1/contacts/update"})
    public RestResponse update(Contacts contacts) {
        this.contactsService.updateContactsByAdmin(contacts);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/api/mobileAdmin/v1/contacts/delete"})
    public RestResponse delete(String id) {
        Contacts vo = this.contactsService.selectContactsById(id);
        this.contactsService.deleteContacts(vo);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/mobileAdmin/v1/contacts/isFrozen"})
    public RestResponse frozen(String studentId, Boolean isFrozen) {
        Contacts contacts = this.contactsService.selectByStudentIdCheckNull(studentId);
        Shift.throwsIfInvalid((boolean)StringUtil.isBlank((String)contacts.getMemberId()), (String)"\u8be5\u7528\u6237\u5c1a\u672a\u7ed1\u5b9a");
        this.contactsService.frozen(contacts, isFrozen);
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

