/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.mobile;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.sdk.green.AliyunGreenSDK;
import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.bbs.controller.AdminInformationControllerSupport;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.enums.InformationAuditStatusEnum;
import com.wego168.bbs.service.BBSCommentService;
import com.wego168.bbs.service.InformationService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.service.ContactsService;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MobileAdminInformationController
extends AdminInformationControllerSupport {
    @Autowired
    private InformationService informationService;
    @Autowired
    private BBSCommentService bbsCommentService;
    @Autowired
    private ContactsService contactsService;

    @PostMapping(value={"/api/mobileAdmin/v1/information/save"})
    public RestResponse save(@Valid Information information, HttpServletRequest request, HttpServletResponse response) {
        Date createTime = new Date();
        return super.publishInformation(information, createTime);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/information/get"})
    public RestResponse get(String id) {
        return super.getInformation(id);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/information/auditPage"})
    public RestResponse auditPage(Integer pageNum, Integer pageSize, String areaId, String categoryId, String phone, String keyword, Integer type, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.initPage(pageNum, pageSize);
        List<Bootmap> list = super.selectPage(page, areaId, categoryId, phone, keyword, type, Integer.valueOf(InformationAuditStatusEnum.AUDIT.value()), null, Boolean.valueOf(true), null, request, response);
        list = this.addIsMembershipToList(list);
        list = this.addCommentAndConvertFormatToList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/information/unAutoAuditPage"})
    public RestResponse unAutoAuditPage(Integer pageNum, Integer pageSize, Boolean isAccepted, String areaId, String categoryId, String phone, String keyword, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.initPage(pageNum, pageSize);
        Integer auditStatus = null;
        auditStatus = isAccepted == null || isAccepted == false ? Integer.valueOf(InformationAuditStatusEnum.WAIT.value()) : Integer.valueOf(InformationAuditStatusEnum.UNAUDIT.value());
        List<Bootmap> list = super.selectPage(page, areaId, categoryId, phone, keyword, null, auditStatus, Boolean.valueOf(false), null, null, request, response);
        list = this.addIsMembershipToList(list);
        list = this.addCommentAndConvertFormatToList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/information/unReportAuditPage"})
    public RestResponse unReportAuditPage(Integer pageNum, Integer pageSize, Boolean isAccepted, String areaId, String categoryId, String phone, String keyword, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.initPage(pageNum, pageSize);
        List<Bootmap> list = super.selectPage(page, areaId, categoryId, phone, keyword, null, null, null, Boolean.valueOf(false), isAccepted, request, response);
        list = this.addCommentAndConvertFormatToList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/mobileAdmin/v1/information/unAuditPage"})
    public RestResponse unAuditPage(Integer pageNum, Integer pageSize, String areaId, String categoryId, String phone, String keyword, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.initPage(pageNum, pageSize);
        List<Bootmap> list = super.selectPage(page, areaId, categoryId, phone, keyword, null, Integer.valueOf(InformationAuditStatusEnum.UNAUDIT.value()), null, null, null, request, response);
        list = this.addCommentAndConvertFormatToList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/mobileAdmin/v1/information/update"})
    public RestResponse update(String id, String content, String imgUrl, String address, String phone, String areaCode, String appellation, HttpServletResponse response) {
        Information information = (Information)this.getInformationService().selectById((Object)id);
        Shift.throwsIfInvalid((information == null || information.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        JSONObject jsonObject = AliyunGreenSDK.sendScanTask((String)content);
        Shift.throwsIfInvalid((boolean)StringUtil.equals((String)((String)jsonObject.get((Object)"suggestion")), (String)"block"), (String)"\u5185\u5bb9\u672a\u901a\u8fc7\u68c0\u6d4b");
        information.setContent(content);
        information.setImgUrl(imgUrl);
        information.setAddress(address);
        information.setPhone(phone);
        information.setAreaCode(areaCode);
        information.setAppellation(appellation);
        return super.updateInformation(information);
    }

    @PostMapping(value={"/api/mobileAdmin/v1/information/delete"})
    public RestResponse delete(String id, HttpServletResponse response) {
        return super.deleteInformation(id);
    }

    @PostMapping(value={"/api/mobileAdmin/v1/information/unaudit"})
    public RestResponse unaudit(String id, HttpServletRequest request) {
        super.audit(id, Boolean.valueOf(false));
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/api/mobileAdmin/v1/information/audit"})
    public RestResponse audit(String id, HttpServletResponse response) {
        super.audit(id, Boolean.valueOf(true));
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/api/mobileAdmin/v1/information/reportAudit"})
    public RestResponse reportAudit(String id, HttpServletResponse response) {
        super.reportAudit(id, Boolean.valueOf(true));
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/api/mobileAdmin/v1/information/reportUnAudit"})
    public RestResponse reportUnAudit(String id, HttpServletResponse response) {
        super.audit(id, Boolean.valueOf(false));
        return RestResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    private Page initPage(Integer pageNum, Integer pageSize) {
        Page page = new Page();
        page.setPageNum((pageNum == null ? page.getInteger("pageNum") : pageNum).intValue());
        page.setPageSize((pageSize == null ? page.getInteger("pageSize") : pageSize).intValue());
        return page;
    }

    private List<Bootmap> addCommentAndConvertFormatToList(List<Bootmap> list) {
        if (list != null && list.size() > 0) {
            list = this.bbsCommentService.addCommentToList(list, Integer.valueOf(3));
            list = this.informationService.convertFormat((List)list);
            list = this.contactsService.addClassToList(list);
        }
        return list;
    }

    protected InformationService getInformationService() {
        return this.informationService;
    }

    private List<Bootmap> addIsMembershipToList(List<Bootmap> list) {
        if (list != null && list.size() > 0) {
            for (Bootmap map : list) {
                if (map.get((Object)"memberId") == null) continue;
                String memberId = map.get((Object)"memberId").toString();
                Contacts contacts = this.contactsService.selectByMemberId(memberId);
                map.put((Object)"isMembership", (Object)contacts.getIsMembership());
            }
        }
        return list;
    }
}

