/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.wechat;

import com.simple.mybatis.Page;
import com.wego168.coweb.domain.BusinessCard;
import com.wego168.coweb.domain.BusinessCardQrcode;
import com.wego168.coweb.domain.BusinessCardVisibility;
import com.wego168.coweb.model.response.BusinessCardListResponse;
import com.wego168.coweb.model.response.BusinessCardResponse;
import com.wego168.coweb.service.BusinessCardCollectionService;
import com.wego168.coweb.service.BusinessCardQrcodeService;
import com.wego168.coweb.service.BusinessCardService;
import com.wego168.coweb.service.BusinessCardVisibilityService;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class BusinessCardController
extends SimpleController {
    @Autowired
    private BusinessCardService service;
    @Autowired
    private BusinessCardCollectionService collectionService;
    @Autowired
    private BusinessCardVisibilityService visibilityService;
    @Autowired
    private BusinessCardQrcodeService qrcodeService;

    @PostMapping(value={"/api/v1/business-card/collect"})
    public RestResponse collect(@NotBlankAndLength String id) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCard businessCard = (BusinessCard)((Object)this.service.selectById(id));
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        if (this.collectionService.collected(id, memberId)) {
            return RestResponse.success(null, (String)"\u5df2\u6536\u85cf");
        }
        this.collectionService.collect(id, memberId);
        return RestResponse.success(null, (String)"ok");
    }

    @PostMapping(value={"/api/v1/business-card/cancel-collect"})
    public RestResponse cancelCollect(@NotBlankAndLength String id) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        this.collectionService.cancelCollect(id, memberId);
        return RestResponse.success(null, (String)"ok");
    }

    @GetMapping(value={"/api/v1/business-card/page"})
    public RestResponse selectPage(String keyword, String orderBy, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        String appId = this.getAppId();
        Page page = super.buildPage(request);
        List<BusinessCardListResponse> list = this.service.selectWechatPage(appId, keyword, orderBy, page);
        this.collectionService.assembleCollect(list, memberId);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/business-card/get"})
    public RestResponse get(@NotBlankAndLength String id, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        BusinessCard businessCard = (BusinessCard)((Object)this.service.selectById(id));
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        BusinessCardVisibility visibility = (BusinessCardVisibility)((Object)this.visibilityService.selectById(id));
        BusinessCardResponse cardResponse = new BusinessCardResponse(businessCard, visibility);
        this.collectionService.assembleCollect(cardResponse, memberId);
        this.service.addViewQuantityAsync(id);
        return RestResponse.success((Object)cardResponse, (String)"ok");
    }

    @GetMapping(value={"/api/v1/business-card/get-qrcode", "/api/v1/my-business-card/get-qrcode"})
    public RestResponse getOrCreateQrcode(@NotBlankAndLength String id, String pagePath) {
        BusinessCard businessCard = (BusinessCard)((Object)this.service.selectById(id));
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        if (StringUtil.isBlank((String)pagePath)) {
            pagePath = "pages/index/index";
        }
        BusinessCardQrcode businessCardQrcode = this.qrcodeService.getOrCreate(id, pagePath, this.getAppId());
        return RestResponse.success((Object)((Object)businessCardQrcode), (String)"ok");
    }
}

