/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.wechat;

import com.wego168.coweb.domain.BusinessCardStyleTemplate;
import com.wego168.coweb.enums.BusinessCardTemplateVisibility;
import com.wego168.coweb.model.response.BusinessCardStyleTemplateResponse;
import com.wego168.coweb.service.BusinessCardStyleTemplateService;
import com.wego168.util.Checker;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BusinessCardStyleTemplateController
extends SimpleController {
    @Autowired
    private BusinessCardStyleTemplateService service;

    @GetMapping(value={"/api/v1/business-card-style-template/list"})
    public RestResponse selectList() {
        String appId = this.getAppId();
        String[] visibility = new String[]{BusinessCardTemplateVisibility.PUBLIC.value()};
        List<BusinessCardStyleTemplate> list = this.service.selectListByAppId(appId, visibility);
        return RestResponse.success(this.toResponseList(list), (String)"ok");
    }

    private List<BusinessCardStyleTemplateResponse> toResponseList(List<BusinessCardStyleTemplate> list) {
        if (Checker.listNotEmpty(list)) {
            ArrayList<BusinessCardStyleTemplateResponse> responseList = new ArrayList<BusinessCardStyleTemplateResponse>(list.size());
            for (BusinessCardStyleTemplate templateDb : list) {
                responseList.add(new BusinessCardStyleTemplateResponse(templateDb));
            }
            return responseList;
        }
        return null;
    }
}

