/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.wechat;

import com.simple.mybatis.Page;
import com.wego168.coweb.domain.BusinessCard;
import com.wego168.coweb.domain.BusinessCardVisibility;
import com.wego168.coweb.model.response.BusinessCardCollectionListResponse;
import com.wego168.coweb.model.response.MyBusinessCardListResponse;
import com.wego168.coweb.model.response.MyBusinessCardResponse;
import com.wego168.coweb.service.BusinessCardService;
import com.wego168.coweb.service.BusinessCardVisibilityService;
import com.wego168.domain.BaseDomain;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.validation.constraints.NotBlankOrLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class MyBusinessCardController
extends SimpleController {
    @Autowired
    private BusinessCardService service;
    @Autowired
    private BusinessCardVisibilityService visibilityService;

    @PostMapping(value={"/api/v1/my-business-card/insert"})
    public RestResponse insert(@NotBlankAndLength(min=1, max=16, message="\u59d3\u540d\u975e\u6cd5") String name, @NotBlankAndLength(min=1, max=64, message="\u516c\u53f8\u975e\u6cd5") String company, @NotBlankAndLength(min=1, max=32, message="\u804c\u4f4d\u975e\u6cd5") String position, @NotBlankAndLength(min=1, max=16, message="\u624b\u673a\u975e\u6cd5") String phone, @NotBlankOrLength(min=1, max=32, message="\u5fae\u4fe1\u975e\u6cd5") String wechat, @NotBlankOrLength(min=1, max=64, message="\u90ae\u7bb1\u975e\u6cd5") String email, @NotBlankOrLength(min=1, max=128, message="\u5730\u5740\u975e\u6cd5") String address, @NotBlankOrLength(min=1, max=256, message="\u8363\u8a89\u975e\u6cd5") String honor, @NotBlankOrLength(min=1, max=32, message="\u6837\u5f0f\u6a21\u677f") String styleTemplateCode, @NotBlankOrLength(min=1, max=256, message="\u80cc\u666f") String backgroundUrl, @NotBlankAndLength(min=1, max=256, message="\u5934\u50cf\u975e\u6cd5") String headImage) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String appId = this.getAppId();
        BusinessCard businessCard = new BusinessCard();
        BaseDomainUtil.initBaseDomain((BaseDomain)businessCard, (String)appId);
        businessCard.setAddress(address);
        businessCard.setCompany(company);
        businessCard.setEmail(email);
        businessCard.setHeadImage(headImage);
        businessCard.setHonor(honor);
        businessCard.setCollectQuantity(0);
        businessCard.setMemberId(memberId);
        businessCard.setName(name);
        businessCard.setPhone(phone);
        businessCard.setPosition(position);
        businessCard.setTop(0);
        businessCard.setViewQuantity(0);
        businessCard.setWechat(wechat);
        businessCard.setBackgroundUrl(backgroundUrl);
        businessCard.setStyleTemplateCode(styleTemplateCode);
        Checker.checkCondition((boolean)this.service.overQuantity(memberId, appId), (String)"\u60a8\u4e0d\u80fd\u7ee7\u7eed\u6dfb\u52a0\u540d\u7247\u4e86");
        this.service.insertBusinessCardAndVisibility(businessCard);
        return RestResponse.success(null, (String)"ok");
    }

    @GetMapping(value={"/api/v1/my-business-card/get"})
    public RestResponse get(@NotBlankAndLength String id) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCard businessCard = this.service.selectByIdAndMemberId(id, memberId);
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        return RestResponse.success((Object)new MyBusinessCardResponse(businessCard), (String)"ok");
    }

    @PostMapping(value={"/api/v1/my-business-card/update"})
    public RestResponse update(@NotBlankAndLength String id, @NotBlankAndLength(min=1, max=16, message="\u59d3\u540d\u975e\u6cd5") String name, @NotBlankAndLength(min=1, max=64, message="\u516c\u53f8\u975e\u6cd5") String company, @NotBlankAndLength(min=1, max=32, message="\u804c\u4f4d\u975e\u6cd5") String position, @NotBlankAndLength(min=1, max=16, message="\u624b\u673a\u975e\u6cd5") String phone, @NotBlankOrLength(min=1, max=32, message="\u5fae\u4fe1\u975e\u6cd5") String wechat, @NotBlankOrLength(min=1, max=64, message="\u90ae\u7bb1\u975e\u6cd5") String email, @NotBlankOrLength(min=1, max=128, message="\u5730\u5740\u975e\u6cd5") String address, @NotBlankOrLength(min=1, max=64, message="\u6837\u5f0f\u6a21\u677f") String styleTemplateCode, @NotBlankOrLength(min=1, max=256, message="\u80cc\u666f") String backgroundUrl, @NotBlankOrLength(min=1, max=256, message="\u8363\u8a89\u975e\u6cd5") String honor) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCard businessCard = this.service.selectByIdAndMemberId(id, memberId);
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        BusinessCard param = new BusinessCard();
        param.setId(id);
        param.setAddress(address);
        param.setCompany(company);
        param.setEmail(email);
        param.setHonor(honor);
        param.setMemberId(memberId);
        param.setName(name);
        param.setPhone(phone);
        param.setPosition(position);
        param.setWechat(wechat);
        param.setBackgroundUrl(backgroundUrl);
        param.setStyleTemplateCode(styleTemplateCode);
        param.setUpdateTime(new Date());
        BusinessCardVisibility visibility = (BusinessCardVisibility)((Object)this.visibilityService.selectById(id));
        this.service.buildSearchColumn(businessCard, visibility);
        this.service.updateSelective((Object)param);
        return RestResponse.success(null, (String)"ok");
    }

    @PostMapping(value={"/api/v1/my-business-card/update-style"})
    public RestResponse update(@NotBlankAndLength String id, @NotBlankAndLength(min=1, max=64, message="\u6837\u5f0f\u6a21\u677f") String styleTemplateCode, @NotBlankAndLength(min=1, max=256, message="\u80cc\u666f") String backgroundUrl) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCard businessCard = this.service.selectByIdAndMemberId(id, memberId);
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        BusinessCard param = new BusinessCard();
        param.setId(id);
        param.setBackgroundUrl(backgroundUrl);
        param.setStyleTemplateCode(styleTemplateCode);
        param.setUpdateTime(new Date());
        this.service.updateSelective((Object)param);
        return RestResponse.success(null, (String)"ok");
    }

    @PostMapping(value={"/api/v1/my-business-card/delete"})
    public RestResponse update(@NotBlankAndLength String id) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCard businessCard = this.service.selectByIdAndMemberId(id, memberId);
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        BusinessCard param = new BusinessCard();
        param.setId(id);
        param.setIsDeleted(true);
        param.setUpdateTime(new Date());
        this.service.updateSelective((Object)param);
        return RestResponse.success(null, (String)"ok");
    }

    @PostMapping(value={"/api/v1/my-business-card/set-top"})
    public RestResponse setTop(@NotBlankAndLength String id) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCard businessCard = this.service.selectByIdAndMemberId(id, memberId);
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        this.service.setTop(id, memberId);
        return RestResponse.success(null, (String)"ok");
    }

    @PostMapping(value={"/api/v1/my-business-card/cancel-top"})
    public RestResponse cancelTop(@NotBlankAndLength String id) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCard businessCard = this.service.selectByIdAndMemberId(id, memberId);
        Checker.checkCondition((businessCard == null ? 1 : 0) != 0, (String)"\u8be5\u540d\u7247\u4e0d\u5b58\u5728");
        this.service.cancelTop(id);
        return RestResponse.success(null, (String)"ok");
    }

    @GetMapping(value={"/api/v1/my-business-card/list"})
    public RestResponse selectList() {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        List<MyBusinessCardListResponse> list = this.service.selectMemberList(memberId);
        return RestResponse.success(list, (String)"ok");
    }

    @GetMapping(value={"/api/v1/my-business-card/collect-page"})
    public RestResponse selectCollectPage(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Page page = super.buildPage(request);
        List<BusinessCardCollectionListResponse> list = this.service.selectCollectPage(this.getAppId(), memberId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/my-business-card/max-quantity"})
    public RestResponse getMaxQuantity() {
        int maxQuantity = this.service.getMaxBusinessCardQuantityPerMember(this.getAppId());
        return RestResponse.success((Object)maxQuantity, (String)"ok");
    }
}

