/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.controller.wechat;

import com.wego168.coweb.domain.BusinessCard;
import com.wego168.coweb.domain.BusinessCardVisibility;
import com.wego168.coweb.enums.BusinessCardVisibilityType;
import com.wego168.coweb.model.response.BusinessCardVisibilityResponse;
import com.wego168.coweb.service.BusinessCardService;
import com.wego168.coweb.service.BusinessCardVisibilityService;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.Checker;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class MyBusinessCardVisibilityController
extends SimpleController {
    @Autowired
    private BusinessCardVisibilityService service;
    @Autowired
    private BusinessCardService cardService;

    @GetMapping(value={"/api/v1/my-business-card-visibility/get"})
    public RestResponse get(@NotBlankAndLength String id) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCardVisibility businessCardVisibility = this.service.selectByIdAndMemberId(id, memberId);
        Checker.checkCondition((businessCardVisibility == null ? 1 : 0) != 0, (String)"\u8be5\u8bbe\u7f6e\u4e0d\u5b58\u5728");
        return RestResponse.success((Object)new BusinessCardVisibilityResponse(businessCardVisibility), (String)"ok");
    }

    @PostMapping(value={"/api/v1/my-business-card-visibility/update"})
    public RestResponse update(@NotBlankAndLength String id, @NotBlankAndLength(min=1, message="\u59d3\u540d\u53ef\u89c1\u6027\u975e\u6cd5") String nameVisibility, @NotBlankAndLength(min=1, message="\u516c\u53f8\u53ef\u89c1\u6027\u975e\u6cd5") String companyVisibility, @NotBlankAndLength(min=1, message="\u804c\u4f4d\u53ef\u89c1\u6027\u975e\u6cd5") String positionVisibility, @NotBlankAndLength(min=1, message="\u624b\u673a\u53ef\u89c1\u6027\u975e\u6cd5") String phoneVisibility, @NotBlankAndLength(min=1, message="\u5fae\u4fe1\u53ef\u89c1\u6027\u975e\u6cd5") String wechatVisibility, @NotBlankAndLength(min=1, message="\u90ae\u7bb1\u53ef\u89c1\u6027\u975e\u6cd5") String emailVisibility, @NotBlankAndLength(min=1, message="\u5730\u5740\u53ef\u89c1\u6027\u975e\u6cd5") String addressVisibility, @NotBlankAndLength(min=1, message="\u8363\u8a89\u53ef\u89c1\u6027\u975e\u6cd5") String honorVisibility) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        BusinessCardVisibility businessCardVisibility = this.service.selectByIdAndMemberId(id, memberId);
        Checker.checkCondition((businessCardVisibility == null ? 1 : 0) != 0, (String)"\u8be5\u8bbe\u7f6e\u4e0d\u5b58\u5728");
        BusinessCardVisibilityType[] range = BusinessCardVisibilityType.values();
        Checker.checkInRange((Object)((Object)BusinessCardVisibilityType.get(nameVisibility)), (Object[])range, (String)"\u9519\u8bef\u7684\u59d3\u540d\u53ef\u89c1\u6027");
        Checker.checkInRange((Object)((Object)BusinessCardVisibilityType.get(companyVisibility)), (Object[])range, (String)"\u9519\u8bef\u7684\u516c\u53f8\u53ef\u89c1\u6027");
        Checker.checkInRange((Object)((Object)BusinessCardVisibilityType.get(positionVisibility)), (Object[])range, (String)"\u9519\u8bef\u7684\u804c\u4f4d\u53ef\u89c1\u6027");
        Checker.checkInRange((Object)((Object)BusinessCardVisibilityType.get(phoneVisibility)), (Object[])range, (String)"\u9519\u8bef\u7684\u624b\u673a\u53ef\u89c1\u6027");
        Checker.checkInRange((Object)((Object)BusinessCardVisibilityType.get(wechatVisibility)), (Object[])range, (String)"\u9519\u8bef\u7684\u5fae\u4fe1\u53ef\u89c1\u6027");
        Checker.checkInRange((Object)((Object)BusinessCardVisibilityType.get(emailVisibility)), (Object[])range, (String)"\u9519\u8bef\u7684\u90ae\u7bb1\u53ef\u89c1\u6027");
        Checker.checkInRange((Object)((Object)BusinessCardVisibilityType.get(addressVisibility)), (Object[])range, (String)"\u9519\u8bef\u7684\u5730\u5740\u53ef\u89c1\u6027");
        Checker.checkInRange((Object)((Object)BusinessCardVisibilityType.get(honorVisibility)), (Object[])range, (String)"\u9519\u8bef\u7684\u8363\u8a89\u53ef\u89c1\u6027");
        BusinessCardVisibility param = new BusinessCardVisibility();
        param.setId(id);
        param.setAddressVisibility(addressVisibility);
        param.setCompanyVisibility(companyVisibility);
        param.setEmailVisibility(emailVisibility);
        param.setHonorVisibility(honorVisibility);
        param.setNameVisibility(nameVisibility);
        param.setPhoneVisibility(phoneVisibility);
        param.setPositionVisibility(positionVisibility);
        param.setUpdateTime(new Date());
        param.setWechatVisibility(wechatVisibility);
        this.service.updateSelective((Object)param);
        BusinessCard businessCard = this.cardService.selectByIdAndMemberId(id, memberId);
        String searchColumn = this.cardService.buildSearchColumn(businessCard, param);
        BusinessCard cardParam = new BusinessCard();
        cardParam.setId(id);
        cardParam.setSearchColumn(searchColumn);
        this.cardService.updateSelective((Object)cardParam);
        return RestResponse.success(null, (String)"ok");
    }
}

