/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.interceptor;

import com.wego168.authority.AuthcStatusCode;
import com.wego168.authority.domain.SysAccount;
import com.wego168.bbs.util.JsonUtil;
import com.wego168.coweb.enums.MyAccountBindStatusEnum;
import com.wego168.member.domain.MemberAccount;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.IntegerUtil;
import com.wego168.util.SimpleJackson;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.RestStatus;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AlumniContextInterceptor
implements HandlerInterceptor {
    private static Logger logger = LoggerFactory.getLogger(AlumniContextInterceptor.class);
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String path = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (StringUtils.length((CharSequence)contextPath) > 0) {
            path = StringUtils.substring((String)path, (int)contextPath.length());
        }
        String sessionId = request.getHeader("WPGSESSID");
        MemberAccount memberAccount = (MemberAccount)this.simpleRedisTemplate.get("WPGSESSID" + sessionId, MemberAccount.class);
        if (!(!path.startsWith("/api/v1") || path.startsWith("/api/v1/member/getSessionByProgram") || path.startsWith("/api/v1/app/isDirectLogin") || path.startsWith("/api/v1/attachments") || path.startsWith("/api/v1/payNotify") || !StringUtils.isBlank((CharSequence)sessionId) && memberAccount != null)) {
            response.setContentType("text/json;charset=UTF-8");
            RestResponse error = RestResponse.reply((RestStatus)AuthcStatusCode.USER_NOT_LOGIN);
            String json = SimpleJackson.toJson((Object)error);
            JsonUtil.out((HttpServletResponse)response, (String)json);
            return false;
        }
        logger.debug("\u8def\u5f84\uff1a{}", (Object)path);
        if (path.startsWith("/api/v1/app/beforeLogin") || path.startsWith("/api/v1/app/login") || path.startsWith("/api/v1/app/validateCode") || path.startsWith("/api/v1/app/isDirectLogin") || path.startsWith("/api/v1/attachment") || path.startsWith("/api/v1/payNotify") || path.startsWith("/api/v1/navigation/get") || path.startsWith("/api/v1/contacts/getStuId") || path.startsWith("/api/v1/privilegeStr/get") || path.startsWith("/api/v1/contacts/statistics") || path.startsWith("/api/mobileAdmin/v1/login") || path.startsWith("/api/v1/hotCity/get") || path.startsWith("/api/v1/memberSurvey/submit") || path.startsWith("/api/v1/profession/get") || path.startsWith("/api/v1/category") || path.startsWith("/api/v1/singleContent") || path.startsWith("/api/v1/donateOrder") || path.startsWith("/api/v1/donate") || path.startsWith("/api/v1/pay") || path.startsWith("/api/v1/donateRecord") || path.startsWith("/api/v1/activitySign") || path.startsWith("/api/v1/activityCheckin") || path.startsWith("/api/v1/activity") || path.startsWith("/api/v1/verifyType/get") || path.startsWith("/api/v1/member/getSessionByProgram") || path.startsWith("/api/v1/app/relogin") || path.startsWith("/api/v1/app/changeMobile") || path.startsWith("/api/v1/app/decryptPhone") || path.startsWith("/api/v1/app/getWechatSessionKey") || path.startsWith("/api/v1/profession") || path.startsWith("/api/v1/agreement")) {
            return true;
        }
        if (path.startsWith("/api/mobileAdmin/v1")) {
            String wego168SessionKey = request.getParameter("wego168SessionKey");
            if (StringUtils.isBlank((CharSequence)wego168SessionKey)) {
                response.setContentType("text/json;charset=UTF-8");
                RestResponse error = RestResponse.reply((RestStatus)AuthcStatusCode.USER_NOT_LOGIN);
                String json = SimpleJackson.toJson((Object)error);
                JsonUtil.out((HttpServletResponse)response, (String)json);
                return false;
            }
            SysAccount sysAccount = (SysAccount)this.simpleRedisTemplate.get("admin_login_" + wego168SessionKey, SysAccount.class);
            if (sysAccount == null) {
                response.setContentType("text/json;charset=UTF-8");
                RestResponse error = RestResponse.reply((RestStatus)AuthcStatusCode.USER_NOT_LOGIN);
                String json = SimpleJackson.toJson((Object)error);
                JsonUtil.out((HttpServletResponse)response, (String)json);
                return false;
            }
            this.simpleRedisTemplate.set("admin_login_" + wego168SessionKey, (Object)sysAccount, 600L);
            return true;
        }
        if (path.startsWith("/api/v1")) {
            if (!IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.BINDED.value())) {
                response.setContentType("text/json;charset=UTF-8");
                RestResponse error = RestResponse.reply((RestStatus)AuthcStatusCode.USER_NOT_AUTHORITY);
                String json = SimpleJackson.toJson((Object)error);
                JsonUtil.out((HttpServletResponse)response, (String)json);
                return false;
            }
            this.simpleRedisTemplate.set("WPGSESSID" + sessionId, (Object)memberAccount, 3600L);
            this.simpleRedisTemplate.setStringEx("session_member_id" + sessionId, memberAccount.getMemberId(), 3600L);
            return true;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

