/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wego168.base.util.BodyReaderHttpServletRequestWrapper;
import com.wego168.util.RequestUtil;
import com.wego168.web.util.ParamUtils;
import com.wego168.web.util.ServletContextHolder;
import com.wego168.wx.service.WxMiniFormService;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AlumniWxMiniFormInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AlumniWxMiniFormInterceptor.class);
    private static final String WX_MINI_FORM = "wxMiniFormId";
    private static final String DEVELOPER_FORM = "the formId is a mock one";
    @Autowired
    private WxMiniFormService wxMiniFormService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        JSONObject parameterMap;
        String wxMiniFormId = ParamUtils.getString((ServletRequest)request, (String)WX_MINI_FORM);
        String openId = ServletContextHolder.getOpenId();
        if (StringUtils.isBlank((CharSequence)wxMiniFormId) && (parameterMap = JSON.parseObject((String)new BodyReaderHttpServletRequestWrapper(request).getBodyString((ServletRequest)request))) != null) {
            wxMiniFormId = parameterMap.getString(WX_MINI_FORM);
        }
        logger.error("push form id,mapping->{},form id->{},open id->{}", new Object[]{RequestUtil.getRequestMapping((HttpServletRequest)request), wxMiniFormId, openId});
        if (StringUtils.isNotBlank((CharSequence)wxMiniFormId) && StringUtils.isNotBlank((CharSequence)openId) && !DEVELOPER_FORM.equals(wxMiniFormId)) {
            this.wxMiniFormService.asyncPush(openId, wxMiniFormId);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

