/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.alibaba.fastjson.JSONObject;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Config;
import com.wego168.base.util.MobileMessageUtil;
import com.wego168.base.util.SmsResponse;
import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.enums.AlumniStatusCode;
import com.wego168.coweb.enums.MyAccountBindStatusEnum;
import com.wego168.coweb.enums.VerifyTypeEnum;
import com.wego168.coweb.scheduler.Task;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.MyConfigService;
import com.wego168.coweb.service.MyMemberService;
import com.wego168.coweb.service.ThirdpartyInterfaceRecordService;
import com.wego168.coweb.util.CheckRealName;
import com.wego168.exception.SendMobileMessageFailException;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.redis.RedisLockUtil;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.DateUtil;
import com.wego168.util.IntegerUtil;
import com.wego168.util.RequestUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.util.SimpleJackson;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.RestStatus;
import com.wego168.wechat.api.IWechatMiniProgramSession;
import com.wego168.wechat.api.IWechatPhoneNumber;
import com.wego168.wechat.exception.WechatFansException;
import com.wego168.wechat.model.login.WechatMiniProgramLogin;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="communityAppLoginController")
public class AppLoginController
extends CrudController<MemberAccount> {
    private static final Logger log = LoggerFactory.getLogger(AppLoginController.class);
    @Autowired
    private MyMemberService myMemberService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private MyConfigService myConfigService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private Task asyncTask;
    @Autowired
    private RedisLockUtil smsRedisLockUtil;
    @Autowired
    private IWechatPhoneNumber wechatPhoneNumberHelper;
    @Autowired
    private IWechatMiniProgramSession wechatMiniProgramSession;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private ThirdpartyInterfaceRecordService thirdpartyInterfaceRecordService;

    public CrudService<MemberAccount> getService() {
        return this.memberAccountService;
    }

    @PostMapping(value={"/api/v1/app/isDirectLogin"})
    public RestResponse isDirectLogin(String code, String name, String headImage, HttpServletRequest request, HttpServletResponse response) {
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        MemberAccount memberAccount = this.memberAccountService.selectByUsername(openId);
        if (null != memberAccount && IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.BINDED.value())) {
            this.myMemberService.updateMemberInfo(memberAccount.getMemberId(), name, headImage);
        } else if (StringUtil.isBlank((String)memberAccount.getMemberId())) {
            memberAccount = this.myMemberService.createVisitorsMember(memberAccount, name, headImage);
        } else {
            this.myMemberService.updateMemberInfo(memberAccount.getMemberId(), name, headImage);
        }
        String sessionId = request.getHeader("WPGSESSID");
        this.simpleRedisTemplate.set("WPGSESSID" + sessionId, (Object)memberAccount, 3600L);
        this.simpleRedisTemplate.setStringEx("session_member_id" + sessionId, memberAccount.getMemberId(), 3600L);
        HashMap<String, Constable> json = new HashMap<String, Constable>();
        long todayTime = DateUtil.getToday0oClock().getTime();
        String times = this.simpleRedisTemplate.getString(openId + "_" + todayTime);
        if (StringUtil.isBlank((String)times)) {
            json.put("todaySurplusTimes", Integer.valueOf(2));
        } else {
            json.put("todaySurplusTimes", Integer.valueOf(2 - Integer.parseInt(times)));
        }
        Contacts contacts = this.contactsService.selectByMemberId(memberAccount.getMemberId());
        if (contacts != null && IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.BINDED.value())) {
            if (contacts.getIsReal() != null && 1 == contacts.getIsReal()) {
                json.put("isRealName", Boolean.valueOf(true));
            } else {
                json.put("isRealName", Boolean.valueOf(false));
            }
            json.put("totalSurplusTimes", Integer.valueOf(6 - (contacts.getCheckTimes() != null ? contacts.getCheckTimes() : 0)));
        } else {
            json.put("isRealName", Boolean.valueOf(false));
            json.put("totalSurplusTimes", Integer.valueOf(6));
        }
        json.put("isContacts", Boolean.valueOf(IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.BINDED.value())));
        json.put("isFrozen", Boolean.valueOf(IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.FROZEN.value())));
        System.out.println("=======" + json + "======");
        return RestResponse.success(json);
    }

    @GetMapping(value={"/api/v1/app/beforeLogin"})
    public RestResponse beforeLogin(String studentId, String year, String phone, String className, String name, HttpServletRequest request, HttpServletResponse response) {
        Integer verifyType = this.myConfigService.getVerifyType();
        Contacts contacts = null;
        if (IntegerUtil.equals((Integer)verifyType, (Integer)VerifyTypeEnum.STUDENT_ID.value())) {
            Checker.checkBlank((String)studentId, (String)"\u5b66\u53f7");
            contacts = this.contactsService.selectByStudentId(studentId);
        } else if (IntegerUtil.equals((Integer)verifyType, (Integer)VerifyTypeEnum.CLASS_AND_NAME.value())) {
            Checker.checkBlank((String)className, (String)"\u73ed\u7ea7");
            Checker.checkBlank((String)name, (String)"\u59d3\u540d");
            String classId = this.classAndGradeService.getClassIdByName(className);
            contacts = this.contactsService.selectByClassAndName(classId, name);
        } else if (IntegerUtil.equals((Integer)verifyType, (Integer)VerifyTypeEnum.YEAR_AND_NAME.value())) {
            Checker.checkBlank((String)year, (String)"\u5165\u5b66\u5e74\u4efd");
            Checker.checkBlank((String)name, (String)"\u59d3\u540d");
            contacts = name.contains("\u5fae\u4fe1\u5ba1\u6838") ? this.getContancts(name) : this.contactsService.selectByPhoneYearName(phone, year, name);
        } else {
            Shift.throwsIfInvalid((boolean)true, (String)"\u8bf7\u5148\u914d\u7f6e\u9a8c\u8bc1\u65b9\u5f0f");
        }
        Shift.throwsIfInvalid((contacts == null || contacts.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u5c1a\u672a\u5f55\u5165\u60a8\u7684\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
        Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u8be5\u8d26\u53f7\u5df2\u88ab\u51bb\u7ed3");
        String message = "";
        HashMap<String, String> map = new HashMap<String, String>();
        String firstHalf = "";
        String lastHalf = "";
        map.put("firstHalf", firstHalf);
        map.put("lastHalf", lastHalf);
        return RestResponse.success(map, (String)message);
    }

    private Contacts getContancts(String name) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().like("name", (Object)name).eq("isBind", (Object)0);
        List contactsList = this.contactsService.selectList(jpaCriteria);
        return (Contacts)((Object)contactsList.get(0));
    }

    @PostMapping(value={"/api/coweb/v2/app/login"})
    public RestResponse v2Login(@RequestBody Contacts contactsVo, HttpServletRequest request) {
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        Boolean isNewMember = false;
        Contacts contacts = null;
        if (StringUtils.isNotBlank((CharSequence)contactsVo.getName()) && contactsVo.getName().contains("\u5fae\u4fe1\u5ba1\u6838")) {
            contacts = this.getContancts(contactsVo.getName());
        } else {
            contactsVo.setName(null);
            contacts = this.contactsService.selectByContacts(contactsVo);
        }
        Shift.throwsIfInvalid((contacts == null || contacts.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u5c1a\u672a\u5f55\u5165\u60a8\u7684\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
        Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u8be5\u8d26\u53f7\u5df2\u88ab\u51bb\u7ed3");
        ClassAndGrade classAndGrade = (ClassAndGrade)((Object)this.classAndGradeService.selectById(contacts.getClassId()));
        Shift.throwsIfInvalid((classAndGrade == null || classAndGrade.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u8be5\u73ed\u7ea7\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        String phone = contacts.getPhone();
        MemberAccount memberAccount = this.memberAccountService.selectByUsername(openId);
        Shift.throwsIfNull((Object)memberAccount, (String)"\u627e\u4e0d\u5230\u7528\u6237");
        contacts.setPhone(phone);
        if (!contacts.getIsBind().booleanValue() && StringUtils.isBlank((CharSequence)contacts.getMemberId())) {
            log.error("contacts->{}, memberAccount->{}, classAndGrade->{}", new Object[]{contacts, memberAccount.getId(), classAndGrade});
            memberAccount = this.contactsService.bindAccountToNewContacts(contacts, memberAccount, classAndGrade);
            isNewMember = true;
        } else {
            memberAccount = this.contactsService.bindAccountToOldContacts(contacts, memberAccount);
            isNewMember = false;
        }
        this.contactsService.updatePersonalityLabel(contacts.getId());
        this.contactsService.createMemberLevelJoin(contacts);
        HashMap<String, Boolean> json = new HashMap<String, Boolean>();
        json.put("isNewMember", isNewMember);
        json.put("isContacts", IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.BINDED.value()));
        json.put("isFrozen", IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.FROZEN.value()));
        this.asyncTask.sendRegisterTemple(this.getAppId(), openId, contacts.getName());
        return RestResponse.success(json, (String)"\u767b\u5f55\u6210\u529f");
    }

    @PostMapping(value={"/api/coweb/v2/app/register"})
    public RestResponse v2Register(@RequestBody Contacts contactsVo, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        MemberAccount memberAccount = this.memberAccountService.selectMiniProgramAccount(memberId);
        Map<String, Object> map = this.contactsService.registerContacts(contactsVo, memberAccount);
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("isNewMember", map.get("isMemberAccount"));
        json.put("isContacts", IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.BINDED.value()));
        json.put("isFrozen", IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.FROZEN.value()));
        this.asyncTask.sendRegisterTemple(this.getAppId(), openId, contactsVo.getName());
        return RestResponse.success(json, (String)"\u6ce8\u518c\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u7ba1\u7406\u5458\u5ba1\u6838");
    }

    @PostMapping(value={"/api/v1/app/relogin"})
    public RestResponse relogin(String phone, HttpServletRequest request) {
        Shift.throwsIfBlank((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Contacts contacts = (Contacts)((Object)this.contactsService.select(JpaCriteria.builder().eq("phone", (Object)phone)));
        Shift.throwsIfInvalid((contacts == null || contacts.getIsDeleted() != false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u5c1a\u672a\u5f55\u5165\u60a8\u7684\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
        Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u8be5\u8d26\u53f7\u5df2\u88ab\u51bb\u7ed3");
        Shift.throwsIfInvalid((contacts.getIsBind() == false ? 1 : 0) != 0, (String)"\u8bf7\u5148\u9a8c\u8bc1\u5e76\u6ce8\u518c");
        String sessionId = request.getHeader("WPGSESSID");
        MemberAccount memberAccount = (MemberAccount)this.simpleRedisTemplate.get("WPGSESSID" + sessionId, MemberAccount.class);
        memberAccount = this.contactsService.bindAccountToOldContacts(contacts, memberAccount);
        this.simpleRedisTemplate.set("WPGSESSID" + sessionId, (Object)memberAccount, 3600L);
        this.simpleRedisTemplate.setStringEx("session_member_id" + sessionId, memberAccount.getMemberId(), 3600L);
        HashMap<String, Boolean> json = new HashMap<String, Boolean>();
        json.put("isContacts", IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.BINDED.value()));
        json.put("isFrozen", IntegerUtil.equals((Integer)memberAccount.getBindStatus(), (Integer)MyAccountBindStatusEnum.FROZEN.value()));
        return RestResponse.success(json);
    }

    @PostMapping(value={"/api/v1/app/validateCode"})
    public RestResponse validateCode(String studentId, String className, String name, String phone, Boolean isRelogin, HttpServletRequest request) {
        Integer verifyType = this.myConfigService.getVerifyType();
        Contacts contacts = null;
        if (isRelogin != null && isRelogin.booleanValue()) {
            contacts = (Contacts)((Object)this.contactsService.select(JpaCriteria.builder().eq("phone", (Object)phone).eq("isDeleted", (Object)false)));
            Shift.throwsIfNull((Object)((Object)contacts), (String)"\u7cfb\u7edf\u5c1a\u672a\u5f55\u5165\u60a8\u7684\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
            Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u8be5\u8d26\u53f7\u5df2\u88ab\u51bb\u7ed3");
            Shift.throwsIfInvalid((contacts.getIsBind() == false ? 1 : 0) != 0, (String)"\u8bf7\u5148\u9a8c\u8bc1\u5e76\u6ce8\u518c");
        } else {
            if (IntegerUtil.equals((Integer)verifyType, (Integer)VerifyTypeEnum.STUDENT_ID.value())) {
                Checker.checkBlank((String)studentId, (String)"\u5b66\u53f7");
                contacts = this.contactsService.selectByStudentId(studentId);
            } else {
                Checker.checkBlank((String)className, (String)"\u73ed\u7ea7");
                Checker.checkBlank((String)name, (String)"\u59d3\u540d");
                String classId = this.classAndGradeService.getClassIdByName(className);
                contacts = this.contactsService.selectByClassAndName(classId, name);
            }
            Shift.throwsIfNull((Object)((Object)contacts), (String)"\u7cfb\u7edf\u5c1a\u672a\u5f55\u5165\u60a8\u7684\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
            Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u8be5\u8d26\u53f7\u5df2\u88ab\u51bb\u7ed3");
            Shift.throwsIfInvalid((StringUtil.isNotBlank((String)contacts.getPhone()) && !StringUtil.equals((String)contacts.getPhone(), (String)phone) ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u4e0e\u7cfb\u7edf\u540e\u53f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        String realIp = RequestUtil.getRealIp((HttpServletRequest)request);
        try {
            this.smsRedisLockUtil.checkLock(phone, realIp);
        }
        catch (SendMobileMessageFailException e) {
            return RestResponse.error((String)e.getMessage());
        }
        Config config = this.myConfigService.getByKey("verification_code_msg_config");
        Shift.throwsIfNull((Object)config, (String)"\u672a\u914d\u7f6e\u77ed\u4fe1\u9a8c\u8bc1\u7801");
        String[] split = config.getValue().split("_");
        Shift.throwsIfInvalid((split.length < 4 ? 1 : 0) != 0, (String)"\u672a\u6b63\u786e\u914d\u7f6e\u77ed\u4fe1\u9a8c\u8bc1\u7801");
        Integer sdkAppId = Integer.valueOf(split[0]);
        String sdkAppKey = split[1];
        Integer templateId = Integer.valueOf(split[2]);
        String validMinutes = split[3];
        ArrayList<String> parameters = new ArrayList<String>(2);
        String code = SequenceUtil.createRandomNumberSequence((int)6);
        parameters.add(code);
        parameters.add(validMinutes);
        SmsResponse smsResponse = MobileMessageUtil.sendMessage((String)phone, parameters, (int)templateId, (int)sdkAppId, (String)sdkAppKey, null);
        String registCode = (String)smsResponse.getParameters().get(0);
        String key = String.format("alumni_regist_%s", phone);
        this.simpleRedisTemplate.setStringEx(key, registCode, (long)(Integer.valueOf(validMinutes) * 60));
        this.smsRedisLockUtil.addLock(phone, realIp);
        return RestResponse.success((String)"\u53d1\u9001\u6210\u529f");
    }

    private boolean isBackDoor(Page page, Integer verifyType) {
        return IntegerUtil.equals((Integer)VerifyTypeEnum.STUDENT_ID.value(), (Integer)verifyType) ? StringUtil.equals((String)"870504", (String)page.getString("studentId")) && StringUtils.equals((CharSequence)"1024", (CharSequence)page.getString("validateCodeByMember")) : IntegerUtil.equals((Integer)VerifyTypeEnum.CLASS_AND_NAME.value(), (Integer)verifyType) && StringUtil.equals((String)"2018-\u672c\u79d1-\u7ecf\u6d4e\u5b66", (String)page.getString("className")) && StringUtils.equals((CharSequence)"\u6d4b\u8bd5", (CharSequence)page.getString("name")) && StringUtils.equals((CharSequence)"1024", (CharSequence)page.getString("validateCodeByMember"));
    }

    @PostMapping(value={"/api/v1/app/checkRealName"})
    public RestResponse checkRealName(String idCard, HttpServletRequest request) {
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        long todayTime = DateUtil.getToday0oClock().getTime();
        MemberAccount memberAccount = this.memberAccountService.selectByUsername(openId);
        Shift.throwsIfNull((Object)memberAccount, (String)"\u8bf7\u9000\u51fa\u5e76\u91cd\u65b0\u6253\u5f00\u5c0f\u7a0b\u5e8f");
        Contacts contacts = this.contactsService.selectByMemberId(memberAccount.getMemberId());
        Shift.throwsIfNull((Object)((Object)contacts), (String)"\u7cfb\u7edf\u5c1a\u672a\u5f55\u5165\u60a8\u7684\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
        Integer checkTimes = contacts.getCheckTimes() != null ? contacts.getCheckTimes() : 0;
        if (checkTimes >= 6) {
            return RestResponse.error((String)"\u60a8\u8ba4\u8bc1\u7684\u6b21\u6570\u8fc7\u591a,\u8bf7\u8054\u7cfb\u6821\u65b9\u7ba1\u7406\u5458\u8fdb\u884c\u4eba\u5de5\u8ba4\u8bc1");
        }
        String times = this.simpleRedisTemplate.getString(openId + "_" + todayTime);
        if (StringUtils.isBlank((CharSequence)times) || Integer.parseInt(times) < 2) {
            if (StringUtils.isBlank((CharSequence)times)) {
                this.simpleRedisTemplate.setString(openId + "_" + todayTime, "1");
            } else {
                this.simpleRedisTemplate.setString(openId + "_" + todayTime, "2");
            }
            contacts.setCheckTimes(checkTimes + 1);
            int count = this.thirdpartyInterfaceRecordService.selectCount(JpaCriteria.builder().like("post", (Object)idCard).like("post", (Object)contacts.getName()));
            if (count > 0) {
                this.contactsService.updateSelective((Object)contacts);
                HashMap<String, String> bodys = new HashMap<String, String>();
                bodys.put("idCard", idCard);
                bodys.put("name", contacts.getName());
                ThirdpartyInterfaceRecordService.insertRecord(request.getRequestURL() + "?" + request.getQueryString(), "http://fephone.market.alicloudapi.com/IDCard", JSONObject.toJSONString(bodys), "\u8bb0\u5f55\u91cd\u590d\u8bf7\u6c42\u6570\u636e");
                return RestResponse.error((String)"\u5b9e\u540d\u8ba4\u8bc1\u4e0d\u901a\u8fc7");
            }
            String result = CheckRealName.phoneCheck(idCard, contacts.getPhone(), contacts.getName(), request);
            if (StringUtil.isNotBlank((String)result)) {
                JSONObject objmeg = JSONObject.parseObject((String)result);
                if ("01".equals(objmeg.get((Object)"status").toString())) {
                    contacts.setRealName(objmeg.getString("name"));
                    contacts.setIdCardNo(objmeg.getString("idCard"));
                    contacts.setIsReal(1);
                    this.contactsService.updateSelective((Object)contacts);
                    return RestResponse.success((String)objmeg.get((Object)"msg").toString());
                }
                this.contactsService.updateSelective((Object)contacts);
                return RestResponse.error((String)objmeg.get((Object)"msg").toString());
            }
            this.contactsService.updateSelective((Object)contacts);
            return RestResponse.error((String)"\u8ba4\u8bc1\u5931\u8d25");
        }
        return RestResponse.error((String)"\u4eca\u65e5\u8ba4\u8bc1\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
    }

    @GetMapping(value={"/api/v1/app/getWechatSessionKey"})
    public RestResponse getWechatSessionKey(String code, HttpServletRequest request) {
        WechatMiniProgramLogin program;
        Shift.throwsIfBlank((String)code, (String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        WxApp wxApp = this.wxAppService.getCacheByAppId(this.getAppId(), WxAppServiceTypeEnum.MINI_PROGRAM.value());
        if (wxApp != null && (program = this.wechatMiniProgramSession.exchangeSessionByCode(wxApp.getWxAppId(), wxApp.getWxAppSecret(), code)) != null) {
            return RestResponse.success((String)"\u83b7\u53d6seseionKey\u6210\u529f");
        }
        return RestResponse.error((String)"\u83b7\u53d6sessionKey\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
    }

    @PostMapping(value={"/api/v1/app/decryptPhone"})
    public RestResponse decryptPhone(String code, String encryptedData, String iv) {
        String result = "";
        Shift.throwsIfBlank((String)code, (String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        WxApp wxApp = this.wxAppService.getCacheByAppId(this.getAppId(), WxAppServiceTypeEnum.MINI_PROGRAM.value());
        if (wxApp != null) {
            Map paramMap;
            WechatMiniProgramLogin program = this.wechatMiniProgramSession.exchangeSessionByThirdPartyPlatforms(wxApp.getWxAppId(), code);
            if (program != null) {
                try {
                    result = this.wechatPhoneNumberHelper.decrypt(program.getWechatSessionKey(), encryptedData, iv);
                }
                catch (WechatFansException e) {
                    return RestResponse.reply((RestStatus)AlumniStatusCode.AUTORIZE_ERROR);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)result) && (paramMap = SimpleJackson.toMap((String)result)).containsKey("phoneNumber")) {
                String mobile = String.valueOf(paramMap.get("phoneNumber"));
                return RestResponse.success((String)mobile);
            }
        }
        return RestResponse.error((String)"\u89e3\u6790\u5931\u8d25");
    }

    @GetMapping(value={"/api/v1/app/changeMobile"})
    public RestResponse changeMobile(String phone) {
        Shift.throwsIfBlank((String)phone, (String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        MemberAccount memberAccount = this.memberAccountService.selectByUsername(openId);
        Shift.throwsIfNull((Object)memberAccount, (String)"\u8d44\u6599\u5e93\u4e2d\u6ca1\u6709\u60a8\u7684\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0");
        Contacts contacts = this.contactsService.selectByMemberId(memberAccount.getMemberId());
        Member member = this.memberService.selectById(memberAccount.getMemberId());
        int count = this.memberService.selectCount(JpaCriteria.builder().eq("mobilePhoneNumber", (Object)phone));
        if (phone.equals(member.getMobilePhoneNumber())) {
            return RestResponse.error((String)"\u66f4\u6362\u524d\u540e\u53f7\u7801\u4e00\u81f4");
        }
        if (count > 0) {
            return RestResponse.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        contacts.setPhone(phone);
        member.setMobilePhoneNumber(phone);
        this.contactsService.updateSelective((Object)contacts);
        this.memberService.updateSelective((Object)member);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }
}

