/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.activity.domain.Activity;
import com.wego168.activity.service.ActivityService;
import com.wego168.base.domain.Config;
import com.wego168.base.domain.SingleContent;
import com.wego168.base.domain.SourceData;
import com.wego168.base.enums.CommentAuditStatusEnum;
import com.wego168.base.mobile.CommentControllerSupport;
import com.wego168.base.service.CommentService;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.SingleContentService;
import com.wego168.base.service.SourceDataService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.service.BbsPointService;
import com.wego168.bbs.service.InformationService;
import com.wego168.course.domain.Course;
import com.wego168.course.service.CourseService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.enums.CommentSourceTypeEnum;
import com.wego168.coweb.scheduler.Task;
import com.wego168.coweb.service.ContactsService;
import com.wego168.domain.GenericDomain;
import com.wego168.member.util.SessionUtil;
import com.wego168.redis.RedisLockUtil;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.StatusCode;
import com.wego168.wechat.api.IMsgSecCheck;
import com.wego168.wechat.api.IWechatAccessToken;
import com.wego168.wechat.exception.GetAccessTokenFailException;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="cowebCommentController")
public class CommentController
extends CommentControllerSupport {
    private static final Logger log = LoggerFactory.getLogger(CommentController.class);
    @Autowired
    private CommentService commentService;
    @Autowired
    private SourceDataService sourceDataService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private RedisLockUtil smsRedisLockUtil;
    @Autowired
    private Task asyncTask;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private SingleContentService singleContentService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private IMsgSecCheck iMsgSecCheck;
    @Autowired
    private IWechatAccessToken wechatAccessToken;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private BbsPointService bbsPointService;
    private static String COMMENT_SPACE_KEY = "comment_space_%s";

    @PostMapping(value={"/api/coweb/v1/app/comment/insert"})
    public RestResponse publishComment(String sourceId, String content, Integer sourceType, String parentId, HttpServletRequest request, HttpServletResponse response) {
        Contacts contacts;
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        String openId = SessionUtil.getOpenId((HttpServletRequest)request);
        if (StringUtil.isBlank((String)openId) && StringUtil.isBlank((String)memberId)) {
            Shift.throwsIfInvalid((boolean)true, (String)"\u8bf7\u5148\u6388\u6743");
        }
        if (null != (contacts = this.contactsService.selectByMemberId(memberId))) {
            Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u60a8\u7684\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        WxApp wxApp = this.wxAppService.selectByAppId(this.getAppId(), WxAppServiceTypeEnum.MINI_PROGRAM.value());
        String accessToken = null;
        try {
            accessToken = this.wechatAccessToken.getToken(wxApp.getWxAppId(), wxApp.getWxAppSecret(), false);
        }
        catch (GetAccessTokenFailException e) {
            Shift.throwsIfInvalid((boolean)true, (String)"token\u83b7\u53d6\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        boolean isOk = this.iMsgSecCheck.contentIsOk(accessToken, content);
        if (!isOk) {
            return RestResponse.error((String)"\u60a8\u53d1\u5e03\u7684\u5185\u5bb9\u672a\u901a\u8fc7\u4fe1\u606f\u5b89\u5168\u68c0\u6d4b\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5");
        }
        sourceType = sourceType == null ? CommentSourceTypeEnum.BBS_INFORMATION.value() : sourceType.intValue();
        Integer auditStatus = this.getStatus(sourceId, sourceType);
        RestResponse restResponse = null;
        if (StringUtil.isNotBlank((String)memberId)) {
            Information topic;
            restResponse = super.publishComment(memberId, content, sourceId, sourceType, auditStatus, parentId, null, request, response);
            if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.BBS_INFORMATION.value()) && (topic = (Information)this.informationService.selectById((Object)sourceId)) != null) {
                this.bbsPointService.giveReplyTopicPointAsync(memberId, topic, content);
                this.bbsPointService.giveTopicRepliedPointAsync(sourceId, topic.getContent(), topic.getMemberId(), topic.getAppId());
            }
        } else {
            restResponse = super.publishCommentOpenId(openId, content, sourceId, sourceType, auditStatus, parentId, null, request, response);
        }
        Shift.throwsIfNull((Object)(restResponse == null ? 1 : 0), (String)"\u8bc4\u8bba\u5931\u8d25");
        if (restResponse.getCode() == StatusCode.OK.code()) {
            Config config = this.configService.getByKey("heat_rate");
            String[] scoreValue = config.getValue().split("_");
            Integer score = Integer.valueOf(scoreValue[2]);
            this.sourceDataService.updateHeatRate(sourceId, score);
            if (contacts != null) {
                this.asyncTask.sendCommentTemple(content, contacts.getAppId(), memberId, parentId, sourceId, sourceType);
            }
        }
        return restResponse;
    }

    private Integer getStatus(String sourceId, int sourceType) {
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.SINGLECONTENT.value())) {
            SingleContent singleContent = (SingleContent)this.singleContentService.selectById((Object)sourceId);
            if (null != singleContent.getIsEnableCommentAudit() && singleContent.getIsEnableCommentAudit().booleanValue()) {
                return CommentAuditStatusEnum.UNAUDIT.value();
            }
            return CommentAuditStatusEnum.AUDITED.value();
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.COURSE.value())) {
            Course course = (Course)this.courseService.selectById((Object)sourceId);
            if (null != course.getIsEnableCommentAudit() && course.getIsEnableCommentAudit().booleanValue()) {
                return CommentAuditStatusEnum.UNAUDIT.value();
            }
            return CommentAuditStatusEnum.AUDITED.value();
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.ACTIVITY.value())) {
            Activity activity = (Activity)this.activityService.selectById((Object)sourceId);
            if (null != activity.getIsEnableCommentAudit() && activity.getIsEnableCommentAudit().booleanValue()) {
                return CommentAuditStatusEnum.UNAUDIT.value();
            }
            return CommentAuditStatusEnum.AUDITED.value();
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.BBS_INFORMATION.value())) {
            Information information = (Information)this.informationService.selectById((Object)sourceId);
            if (null != information.getIsEnableCommentAudit() && information.getIsEnableCommentAudit().booleanValue()) {
                return CommentAuditStatusEnum.UNAUDIT.value();
            }
            return CommentAuditStatusEnum.AUDITED.value();
        }
        return CommentAuditStatusEnum.AUDITED.value();
    }

    @GetMapping(value={"/api/coweb/v1/app/comment/page"})
    public RestResponse selectComment(String sourceId, Integer auditStatus, HttpServletRequest request) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        auditStatus = null != auditStatus ? auditStatus.intValue() : CommentAuditStatusEnum.AUDITED.value();
        return super.selectComment(sourceId, auditStatus, request);
    }

    @PostMapping(value={"/api/coweb/v1/app/comment/delete"})
    public RestResponse deleteComment(String id, String sourceId, HttpServletRequest request, HttpServletResponse response) {
        RestResponse restResponse;
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        if (null != contacts) {
            Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u60a8\u7684\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if ((restResponse = super.deleteComment(id, sourceId, memberId, Integer.valueOf(CommentSourceTypeEnum.BBS_INFORMATION.value()), request, response)).getCode() == StatusCode.OK.code()) {
            Config config = this.configService.getByKey("heat_rate");
            String[] scoreValue = config.getValue().split("_");
            Integer score = Integer.valueOf(scoreValue[2]);
            this.sourceDataService.updateHeatRate(sourceId, Integer.valueOf(-score.intValue()));
        }
        return restResponse;
    }

    protected GenericDomain sourceIsValid(String sourceId, int sourceType) {
        log.error("\u5224\u65ad\u6765\u6e90{}->{}", (Object)sourceId, (Object)sourceType);
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.BBS_INFORMATION.value())) {
            Information information;
            SourceData sourceData = this.sourceDataService.selectBySourceId(sourceId);
            if (sourceData == null && (information = (Information)this.informationService.selectById((Object)sourceId)) != null) {
                sourceData = this.sourceDataService.create(sourceId, sourceType, information.getTitle(), information.getAppId());
                this.sourceDataService.insert((Object)sourceData);
            }
            return sourceData;
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.ACTIVITY.value())) {
            Activity activity = (Activity)this.activityService.selectById((Object)sourceId);
            return activity;
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.SINGLECONTENT.value())) {
            SingleContent singleContent = (SingleContent)this.singleContentService.selectById((Object)sourceId);
            return singleContent;
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.COURSE.value())) {
            Course course = (Course)this.courseService.selectById((Object)sourceId);
            return course;
        }
        return null;
    }

    protected CommentService getCommentService() {
        return this.commentService;
    }

    protected String getLoginMemberId(HttpServletRequest request, HttpServletResponse response) {
        return SessionUtil.getMemberId((HttpServletRequest)request);
    }

    protected void addSpaceLock(String memberId, String sourceId) {
        String key = String.format(COMMENT_SPACE_KEY, memberId + sourceId);
        this.smsRedisLockUtil.addSpaceLock(key, 10);
    }

    protected void checkSpaceLock(String memberId, String sourceId) {
        String key = String.format(COMMENT_SPACE_KEY, memberId);
        this.smsRedisLockUtil.checkSpaceLock(key);
    }

    protected SourceDataService getSourceDataService() {
        return this.sourceDataService;
    }
}

