/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.base.domain.SingleContent;
import com.wego168.base.domain.Visitable;
import com.wego168.base.domain.VisitableBean;
import com.wego168.base.enums.VisitSourceTypeEnum;
import com.wego168.base.service.PraiseService;
import com.wego168.base.service.SingleContentService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/coweb/v1/singleContent"})
public class CowebSingleContentController
extends CrudController<SingleContent> {
    @Autowired
    private SingleContentService singleContentService;
    @Autowired
    private PraiseService praiseService;

    public CrudService<SingleContent> getService() {
        return this.singleContentService;
    }

    @GetMapping(value={"/get"})
    public RestResponse get(String id, HttpServletRequest request) {
        SingleContent singleContent = this.singleContentService.get(id);
        int sourceType = VisitSourceTypeEnum.SINGLE_CONTENT.value();
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        request.setAttribute("VISITABLE_TARGET", (Object)new VisitableBean((Visitable)singleContent, sourceType, memberId));
        String openId = SessionUtil.getOpenId((HttpServletRequest)request);
        if (StringUtil.isNotBlank((String)memberId)) {
            List praises = this.praiseService.selectBySourceId(id, memberId);
            if (praises.size() > 0) {
                singleContent.setIsPraise(Boolean.valueOf(true));
            } else {
                singleContent.setIsPraise(Boolean.valueOf(false));
            }
        } else {
            List praises = this.praiseService.selectBySourceIdAndOpenId(id, openId);
            if (praises.size() > 0) {
                singleContent.setIsPraise(Boolean.valueOf(true));
            } else {
                singleContent.setIsPraise(Boolean.valueOf(false));
            }
        }
        return RestResponse.success((Object)singleContent);
    }
}

