/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.DonateOrder;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.DonateOrderService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DonateOrderController
extends CrudController<DonateOrder> {
    @Autowired
    private DonateOrderService donateOrderService;
    @Autowired
    private ContactsService contactsService;

    public CrudService<DonateOrder> getService() {
        return this.donateOrderService;
    }

    @PostMapping(value={"/api/v1/donateOrder/create"})
    public RestResponse createDonateOrder(@Valid DonateOrder donateOrder) {
        Shift.throwsIfBlank((String)donateOrder.getSourceId(), (String)"\u8bf7\u9009\u62e9\u6350\u8d60\u6d3b\u52a8");
        Shift.throwsIfNull((Object)donateOrder.getIsContacts(), (String)"\u8bf7\u9009\u62e9\u662f\u5426\u6821\u53cb");
        Shift.throwsIfNull((Object)donateOrder.getIsAnonymity(), (String)"\u8bf7\u9009\u62e9\u662f\u5426\u533f\u540d");
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        donateOrder = this.donateOrderService.create(donateOrder, memberId);
        super.insert((Object)donateOrder);
        return RestResponse.success((String)donateOrder.getId());
    }

    @PostMapping(value={"/api/v1/donateOrder/getDefaultInfo"})
    public RestResponse getDefaultInfo(String code, String sourceId, HttpServletRequest request, HttpServletResponse response) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        DonateOrder order = this.donateOrderService.getDefaultInfo(sourceId, contacts);
        return RestResponse.success((Object)((Object)order));
    }
}

