/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.coweb.domain.Donate;
import com.wego168.coweb.domain.DonateRecord;
import com.wego168.coweb.service.DonateRecordService;
import com.wego168.coweb.service.DonateService;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DonateRecordController
extends CrudController<DonateRecord> {
    @Autowired
    private DonateRecordService donateRecordService;
    @Autowired
    private DonateService donateService;

    public CrudService<DonateRecord> getService() {
        return this.donateRecordService;
    }

    @GetMapping(value={"/api/v1/donateRecord/page"})
    public RestResponse page(String sourceId, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.buildPage(request);
        List<DonateRecord> list = this.donateRecordService.selectRecordPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/donateRecord/getCredential"})
    public RestResponse getCredential(String recordId, String orderId, HttpServletRequest request) {
        DonateRecord donateRecord = null;
        donateRecord = StringUtil.isNotBlank((String)recordId) ? (DonateRecord)((Object)this.donateRecordService.selectById(recordId)) : this.donateRecordService.selectByOrderId(orderId);
        Shift.throwsIfNull((Object)((Object)donateRecord), (String)"\u6350\u8d60\u8bb0\u5f55\u4e0d\u5b58\u5728");
        Donate donate = (Donate)((Object)this.donateService.selectById(donateRecord.getSourceId()));
        Double amount = (double)donateRecord.getAmount().intValue() / 100.0;
        String credentialContent = donate.getCredentialContent().replace("\uffe5", String.format("%.2f", amount));
        Bootmap bootmap = new Bootmap();
        bootmap.put((Object)"donator", (Object)donateRecord.getDonator());
        bootmap.put((Object)"donateDate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(donateRecord.getCreateTime()));
        bootmap.put((Object)"credentialContent", (Object)credentialContent);
        bootmap.put((Object)"sponsor", (Object)donate.getSponsor());
        return RestResponse.success((Object)bootmap);
    }
}

