/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.sdk.green.AliyunGreenSDK;
import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.Config;
import com.wego168.base.domain.SourceData;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.SourceDataService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.enums.InformationAuditStatusEnum;
import com.wego168.bbs.enums.InformationOrderByTypeEnum;
import com.wego168.bbs.mobile.InformationControllerSupport;
import com.wego168.bbs.service.BBSCommentService;
import com.wego168.bbs.service.BBSPraiseService;
import com.wego168.bbs.service.BbsPointService;
import com.wego168.bbs.service.InformationService;
import com.wego168.bbs.service.SensitiveWordService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.enums.InformationListTypeEnum;
import com.wego168.coweb.scheduler.Task;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.MyInformationService;
import com.wego168.domain.CosAccess;
import com.wego168.exception.WegoException;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.Checker;
import com.wego168.util.EnvironmentUtil;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import com.wego168.wx.token.SmallProgramUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InformationController
extends InformationControllerSupport {
    @Autowired
    private InformationService informationService;
    @Autowired
    private MyInformationService myInformationService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private BBSPraiseService bbsPraiseService;
    @Autowired
    private BBSCommentService bbsCommentService;
    @Autowired
    private SourceDataService sourceDataService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SensitiveWordService sensitiveWordService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private Task asyncTask;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private Environment env;
    @Autowired
    private BbsPointService bbsPointService;
    @Autowired
    private SimpleRedisTemplate redisTemplate;

    @PostMapping(value={"/api/v1/app/information/save"})
    public RestResponse save(@Valid Information information) {
        String memberId = "";
        String appId = "";
        information.setIsEnableComment(Boolean.valueOf(true));
        information.setIsEnableCommentAudit(Boolean.valueOf(true));
        if (StringUtil.isNotBlank((String)information.getMemberId()) && StringUtil.isNotBlank((String)information.getAppId())) {
            WxApp wxApp = this.wxAppService.selectByAppId(information.getAppId(), WxAppServiceTypeEnum.MINI_PROGRAM.value());
            Shift.throwsIfNull((Object)wxApp, (String)"\u627e\u4e0d\u5230\u914d\u7f6e\u6570\u636e");
            Member member = this.memberService.selectById(information.getMemberId());
            Shift.throwsIfNull((Object)member, (String)"\u627e\u4e0d\u5230\u7528\u6237");
            memberId = information.getMemberId();
            appId = information.getAppId();
        } else {
            memberId = SessionUtil.getMemberIdIfNotAuthToThrow();
            appId = this.getAppId();
            information.setMemberId(memberId);
            information.setAppId(appId);
        }
        MemberAccount memberAccount = this.memberAccountService.selectMiniProgramAccount(memberId);
        Integer templeType = this.myInformationService.checkStatusAndContent(information);
        if (StringUtil.isBlank((String)information.getTitle())) {
            information.setTitle("\u8d44\u8baf\u5206\u4eab");
        }
        information = super.publishInformation(information, memberId, new Date());
        Member member = this.memberService.selectById(memberId);
        this.asyncTask.sendPublishTemple(information.getId(), memberAccount.getUsername(), member.getName(), templeType, information.getUnAutoAuditedReason());
        String msg = "\u53d1\u5e03\u6210\u529f";
        if (IntegerUtil.equals((Integer)information.getAuditStatus(), (Integer)InformationAuditStatusEnum.WAIT.value())) {
            msg = "\u8bf7\u7b49\u5f85\u7ba1\u7406\u5ba1\u6838";
        } else {
            this.bbsPointService.givePublishTopicPointAsync(information);
        }
        return RestResponse.success((Object)information, (String)msg);
    }

    @PostMapping(value={"/api/v1/app/information/share"})
    public RestResponse share(String id, HttpServletRequest request) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"\u5e16\u5b50", (int)32);
            Information topic = (Information)this.informationService.selectById((Object)id);
            Checker.checkCondition((topic == null ? 1 : 0) != 0, (String)"\u8be5\u5e16\u5b50\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
            if (StringUtil.isBlank((String)memberId)) {
                return RestResponse.success(null, (String)"\u672a\u5206\u4eab\u6210\u529f\uff0c\u4f1a\u5458\u672a\u767b\u5f55");
            }
            int givePoint = this.bbsPointService.giveShareTopicPoint(memberId, topic);
            return RestResponse.success((Object)givePoint, (String)"\u5206\u4eab\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/app/information/getMemberIdAndAppId"})
    public RestResponse getMemberIdAndAppId() {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        Shift.throwsIfNull((Object)((Object)contacts), (String)"\u7528\u6237\u672a\u52a0\u5165\u6821\u53cb\u5e93");
        Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u6b64\u8d26\u53f7\u65e0\u6cd5\u64cd\u4f5c");
        Bootmap bootmap = new Bootmap();
        bootmap.put((Object)"appId", (Object)this.getAppId());
        bootmap.put((Object)"memberId", (Object)memberId);
        return RestResponse.success((Object)bootmap);
    }

    @GetMapping(value={"/api/v1/app/information/get"})
    public RestResponse get(String id, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        String openId = SessionUtil.getOpenId((HttpServletRequest)request);
        Bootmap map = super.getInformation(id);
        Boolean isAudit = true;
        Integer auditStatus = map.getInteger("auditStatus");
        Boolean isReportAudit = map.getBoolean("isReportAudit");
        if (!IntegerUtil.equals((Integer)auditStatus, (Integer)InformationAuditStatusEnum.AUDIT.value()) || !isReportAudit.booleanValue()) {
            String sourceMemberId = map.getString("memberId");
            Shift.throwsIfInvalid((!StringUtil.equals((String)memberId, (String)sourceMemberId) ? 1 : 0) != 0, (String)"\u8be5\u8d44\u8baf\u5c1a\u672a\u5ba1\u6838\u901a\u8fc7");
            isAudit = false;
        }
        if (map != null) {
            List praises;
            SourceData sourceData = this.sourceDataService.selectBySourceId(id);
            if (sourceData != null) {
                Config config = this.configService.getByKey("heat_rate");
                String[] scoreValue = config.getValue().split("_");
                Integer score = Integer.valueOf(scoreValue[1]);
                sourceData.setVisitQuantity(Integer.valueOf(sourceData.getVisitQuantity() + 1));
                sourceData.setHeatRate(Integer.valueOf(sourceData.getHeatRate() + score));
                this.sourceDataService.updateSelectiveByLockVersion((Object)sourceData);
            }
            if (StringUtil.isNotBlank((String)memberId)) {
                praises = this.bbsPraiseService.selectBySourceId(id, memberId);
                if (praises != null && praises.size() > 0) {
                    map.put((Object)"isPraise", (Object)true);
                } else {
                    map.put((Object)"isPraise", (Object)false);
                }
            } else {
                praises = this.bbsPraiseService.selectBySourceIdAndOpenId(id, openId);
                if (praises != null && praises.size() > 0) {
                    map.put((Object)"isPraise", (Object)true);
                } else {
                    map.put((Object)"isPraise", (Object)false);
                }
            }
            Date createTime = map.getDate("createTime");
            map.put((Object)"createTimeStr", (Object)DateTimeUtil.convertFormat((Date)createTime));
            String informationMemberId = map.getString("memberId");
            Contacts contacts = null;
            contacts = StringUtil.equals((String)informationMemberId, (String)"admin") ? this.contactsService.selectByMemberIdIgnoreIsDeleted(informationMemberId) : this.contactsService.selectByMemberId(informationMemberId);
            if (contacts != null) {
                if (contacts.getIsMembership().booleanValue()) {
                    map.put((Object)"isMembership", (Object)true);
                }
                map.put((Object)"className", (Object)contacts.getClassName());
            }
            map.put((Object)"isAudit", (Object)isAudit);
        }
        return RestResponse.success((Object)map);
    }

    @GetMapping(value={"/api/v1/app/information/gets"})
    public RestResponse gets(String id, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        Bootmap map = super.getInformation(id);
        Boolean isAudit = true;
        Integer auditStatus = map.getInteger("auditStatus");
        Boolean isReportAudit = map.getBoolean("isReportAudit");
        if (!IntegerUtil.equals((Integer)auditStatus, (Integer)InformationAuditStatusEnum.AUDIT.value()) || !isReportAudit.booleanValue()) {
            isAudit = false;
        }
        if (map != null) {
            SourceData sourceData = this.sourceDataService.selectBySourceId(id);
            if (sourceData != null) {
                Config config = this.configService.getByKey("heat_rate");
                String[] scoreValue = config.getValue().split("_");
                Integer score = Integer.valueOf(scoreValue[1]);
                sourceData.setVisitQuantity(Integer.valueOf(sourceData.getVisitQuantity() + 1));
                sourceData.setHeatRate(Integer.valueOf(sourceData.getHeatRate() + score));
                this.sourceDataService.updateSelectiveByLockVersion((Object)sourceData);
            }
            if (StringUtil.isNotBlank((String)memberId)) {
                List praises = this.bbsPraiseService.selectBySourceId(id, memberId);
                if (praises != null && praises.size() > 0) {
                    map.put((Object)"isPraise", (Object)true);
                } else {
                    map.put((Object)"isPraise", (Object)false);
                }
            } else {
                map.put((Object)"isPraise", (Object)false);
            }
            Date createTime = map.getDate("createTime");
            map.put((Object)"createTimeStr", (Object)DateTimeUtil.convertFormat((Date)createTime));
            String informationMemberId = map.getString("memberId");
            Contacts contacts = null;
            contacts = StringUtil.equals((String)informationMemberId, (String)"admin") ? this.contactsService.selectByMemberIdIgnoreIsDeleted(informationMemberId) : this.contactsService.selectByMemberId(informationMemberId);
            if (contacts != null) {
                if (contacts.getIsMembership().booleanValue()) {
                    map.put((Object)"isMembership", (Object)true);
                }
                map.put((Object)"className", (Object)contacts.getClassName());
            }
            map.put((Object)"isAudit", (Object)isAudit);
        }
        return RestResponse.success((Object)map);
    }

    @GetMapping(value={"/api/v1/app/information/page"})
    public RestResponse page(String keyword, String categoryId, String tagInfo, Integer listType, Integer type, Integer pageNum, Integer pageSize, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Page page = new Page();
        page.setPageNum((pageNum == null ? page.getInteger("pageNum") : pageNum).intValue());
        page.setPageSize((pageSize == null ? page.getInteger("pageSize") : pageSize).intValue());
        page.put((Object)"categoryId", (Object)categoryId);
        page.put((Object)"tagInfo", (Object)tagInfo);
        page.put((Object)"keyword", (Object)keyword);
        if (type == null || !InformationOrderByTypeEnum.isValid((int)type)) {
            type = InformationOrderByTypeEnum.SERVERS_CREATE_TIME.value();
        }
        page.put((Object)"type", (Object)type);
        if (IntegerUtil.equals((Integer)listType, (Integer)InformationListTypeEnum.MY.value())) {
            page.put((Object)"memberId", (Object)memberId);
        } else {
            page.put((Object)"auditStatus", (Object)InformationAuditStatusEnum.AUDIT.value());
            page.put((Object)"isReportAudit", (Object)true);
        }
        List<Bootmap> list = this.myInformationService.selectInformationPage(page, memberId);
        if (list != null && list.size() > 0) {
            list = this.bbsCommentService.addCommentToList(list, Integer.valueOf(3));
            list = this.bbsPraiseService.addPraiseToList((List)list, Integer.valueOf(Integer.MAX_VALUE));
            list = this.myInformationService.addIsAuditToList(list);
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/app/information/pages"})
    public RestResponse pages(HttpServletRequest request) {
        Page page = this.buildPage(request);
        if (request.getParameter("type") == null) {
            page.eq("type", (Object)InformationOrderByTypeEnum.SERVERS_CREATE_TIME.value());
            page.put((Object)"auditStatus", (Object)InformationAuditStatusEnum.AUDIT.value());
            page.put((Object)"isReportAudit", (Object)true);
        }
        page.like("title");
        List<Bootmap> list = this.myInformationService.selectInformationPage(page);
        if (list != null && list.size() > 0) {
            list = this.bbsCommentService.addCommentToList(list, Integer.valueOf(3));
            list = this.bbsPraiseService.addPraiseToList((List)list, Integer.valueOf(Integer.MAX_VALUE));
            list = this.myInformationService.addIsAuditToList(list);
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/app/information/joined"})
    public RestResponse joinedPage(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Page page = this.buildPage(request);
        page.put((Object)"memberId", (Object)memberId);
        page.put((Object)"auditStatus", (Object)InformationAuditStatusEnum.AUDIT.value());
        page.put((Object)"isReportAudit", (Object)true);
        List list = this.myInformationService.selectJoinedPage(page, memberId);
        if (list != null && list.size() > 0) {
            list = this.bbsCommentService.addCommentToList(list, Integer.valueOf(3));
            list = this.bbsPraiseService.addPraiseToList(list, Integer.valueOf(Integer.MAX_VALUE));
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/v1/app/information/update"})
    public RestResponse update(Information information, HttpServletResponse response) {
        Shift.throwsIfInvalid((boolean)true, (String)"\u4e0d\u652f\u6301\u4fee\u6539");
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u6b64\u8d26\u53f7\u65e0\u6cd5\u64cd\u4f5c");
        Information vo = (Information)this.getInformationService().selectById((Object)information.getId());
        Shift.throwsIfInvalid((!StringUtils.equals((CharSequence)memberId, (CharSequence)vo.getMemberId()) ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u4fee\u6539");
        String message = "";
        if (!StringUtils.equals((CharSequence)vo.getContent(), (CharSequence)information.getContent())) {
            String tip;
            JSONObject jsonObject = AliyunGreenSDK.sendScanTask((String)information.getContent());
            if (StringUtil.equals((String)((String)jsonObject.get((Object)"suggestion")), (String)"block") && !(tip = jsonObject.get((Object)"tip").toString()).contains("\u5e7f\u544a")) {
                return RestResponse.error((String)tip);
            }
            Set sensitiveWordSet = this.sensitiveWordService.getSensitiveWord(information.getContent());
            if (sensitiveWordSet.size() > 0) {
                information.setIsAutoAudit(Boolean.valueOf(false));
                information.setAuditStatus(Integer.valueOf(InformationAuditStatusEnum.WAIT.value()));
                information.setUnAutoAuditedReason("\u5305\u542b\u654f\u611f\u8bcd:" + sensitiveWordSet);
                message = "\u5305\u542b\u654f\u611f\u8bcd:" + sensitiveWordSet + ",\u8bf7\u7b49\u5f85\u7ba1\u7406\u5458\u5ba1\u6838";
            } else {
                information.setIsAutoAudit(Boolean.valueOf(true));
                if (IntegerUtil.equals((Integer)information.getAuditStatus(), (Integer)InformationAuditStatusEnum.UNAUDIT.value())) {
                    information.setAuditStatus(Integer.valueOf(InformationAuditStatusEnum.WAIT.value()));
                } else {
                    information.setAuditStatus(vo.getAuditStatus());
                }
                message = "\u4fee\u6539\u6210\u529f";
            }
        } else {
            information.setAuditStatus(vo.getAuditStatus());
            message = "\u4fee\u6539\u6210\u529f";
        }
        return super.updateInformation(information, message);
    }

    @PostMapping(value={"/api/v1/app/information/delete"})
    public RestResponse delete(String id, HttpServletRequest request, HttpServletResponse response) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        Member member = this.memberService.selectById(memberId);
        Shift.throwsIfInvalid((boolean)member.getIsFrozen(), (String)"\u6b64\u8d26\u53f7\u65e0\u6cd5\u64cd\u4f5c");
        Information information = (Information)this.getInformationService().selectById((Object)id);
        Shift.throwsIfInvalid((boolean)information.getIsDeleted(), (String)"\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        Shift.throwsIfInvalid((!StringUtils.equals((CharSequence)memberId, (CharSequence)information.getMemberId()) ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u5220\u9664");
        return super.deleteInformation(id);
    }

    @GetMapping(value={"/api/v1/app/information/getQRCode"})
    public RestResponse getQRCode(String id) throws IOException {
        String path = this.redisTemplate.getString("weapp-information-qrcode-" + id);
        if (StringUtil.isBlank((String)path)) {
            BufferedImage bufferedImage = SmallProgramUtil.getSmallProgramCode((String)this.getAppId(), (String)"pagesCoWebs/information/detail/index", (String)id);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            CosAccess cosAccess = EnvironmentUtil.createCosAccess((Environment)this.env);
            Shift.throwsIfNull((Object)cosAccess, (String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
            path = FileUploadUtil.upload((InputStream)is, (String)(this.getAppId() + ".png"), (String)"memberShare", (CosAccess)cosAccess);
            this.redisTemplate.setString("weapp-information-qrcode-" + id, path);
        }
        Bootmap bootMap = new Bootmap();
        bootMap.put((Object)"path", (Object)path);
        bootMap.put((Object)"name", (Object)this.wxAppService.selectByAppId(this.getAppId(), WxAppServiceTypeEnum.MINI_PROGRAM.value()).getName());
        return RestResponse.success((Object)bootMap);
    }

    protected InformationService getInformationService() {
        return this.informationService;
    }

    protected BBSPraiseService getBBSPraiseService() {
        return this.bbsPraiseService;
    }
}

