/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.base.service.ConfigService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.domain.Report;
import com.wego168.bbs.enums.InformationAuditStatusEnum;
import com.wego168.bbs.enums.ReportTypeEnum;
import com.wego168.bbs.mobile.ReportControllerSupport;
import com.wego168.bbs.service.InformationService;
import com.wego168.bbs.service.ReportService;
import com.wego168.coweb.scheduler.Task;
import com.wego168.coweb.service.InformationReportService;
import com.wego168.domain.GenericDomain;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/informationReport"})
public class InformationReportController
extends ReportControllerSupport {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private InformationReportService informationReportService;
    @Autowired
    private Task task;

    @GetMapping(value={"/getReportOptions"})
    public RestResponse getReportOptions() {
        return RestResponse.success((Object)this.configService.getByKey("report_options"));
    }

    @PostMapping(value={"/save"})
    public RestResponse save(String sourceId, Integer sourceType, String reportReason, String otherReason, HttpServletRequest request, HttpServletResponse response) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Information information = (Information)this.informationService.selectById((Object)sourceId);
        if (information != null) {
            Shift.throwsIfInvalid((!IntegerUtil.equals((Integer)information.getAuditStatus(), (Integer)InformationAuditStatusEnum.AUDIT.value()) && information.getIsReportAudit() == false ? 1 : 0) != 0, (String)"\u8be5\u8d44\u8baf\u672a\u901a\u8fc7\u5ba1\u6838");
        }
        Report report = super.publishReport(sourceId, sourceType, memberId, reportReason, otherReason, null, request, response);
        if (this.informationReportService.isChangeToUnAudited(sourceId, information).booleanValue()) {
            information.setIsReportAudit(Boolean.valueOf(false));
            this.informationService.updateSelective((Object)information);
            this.task.sendInformationReportTemple(information, report);
        }
        return RestResponse.success((Object)report, (String)"\u4e3e\u62a5\u6210\u529f");
    }

    protected GenericDomain sourceIsValid(String sourceId, int sourceType) {
        Information information;
        if (IntegerUtil.equals((Integer)sourceType, (Integer)ReportTypeEnum.INFORMATION.value()) && (information = (Information)this.informationService.selectById((Object)sourceId)) != null && !information.getIsDeleted().booleanValue()) {
            return information;
        }
        return null;
    }

    protected Boolean ckeckReportOneself(String sourceId, Integer sourceType, String reportMemberId) {
        Information information;
        if (IntegerUtil.equals((Integer)sourceType, (Integer)ReportTypeEnum.INFORMATION.value()) && (information = (Information)this.informationService.selectById((Object)sourceId)) != null && !information.getIsDeleted().booleanValue() && StringUtil.equals((String)information.getMemberId(), (String)reportMemberId)) {
            return true;
        }
        return false;
    }

    protected Boolean checkRepetitive(String sourceId, Integer sourceType, String reportMemberId) {
        Report report = this.reportService.selectByReportMemberId(sourceId, reportMemberId);
        if (report != null && !report.getIsDeleted().booleanValue()) {
            return true;
        }
        return false;
    }

    protected ReportService getReportService() {
        return this.reportService;
    }
}

