/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.coweb.domain.ClassAndGrade;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.service.ClassAndGradeService;
import com.wego168.coweb.service.ContactsService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MemberClassAndGradeController
extends CrudController<ClassAndGrade> {
    @Autowired
    private ClassAndGradeService classAndGradeService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;

    public CrudService<ClassAndGrade> getService() {
        return this.classAndGradeService;
    }

    @GetMapping(value={"/api/v1/class/rank"})
    public RestResponse classRank(HttpServletRequest request, HttpServletResponse response) {
        Page page = this.buildPage(request);
        page.setPageNum(1);
        page.setPageSize(Integer.MAX_VALUE);
        List<ClassAndGrade> list = this.classAndGradeService.selectClassAndGradeRank();
        page.setList(list);
        page.setTotal((long)list.size());
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/class/info"})
    public RestResponse myClass(String memberId, HttpServletRequest request, HttpServletResponse response) {
        String sessionId = request.getHeader("WPGSESSID");
        MemberAccount memberAccount = (MemberAccount)this.simpleRedisTemplate.get("WPGSESSID" + sessionId, MemberAccount.class);
        if (StringUtil.isBlank((String)memberId)) {
            memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        }
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        Member member = this.memberService.selectById(memberId);
        ClassAndGrade classAndGrade = (ClassAndGrade)((Object)this.classAndGradeService.selectById(contacts.getClassId()));
        Bootmap map = new Bootmap();
        map.put((Object)"classAndGrade", (Object)classAndGrade);
        map.put((Object)"name", (Object)contacts.getName());
        map.put((Object)"headImage", (Object)member.getHeadImage());
        map.put((Object)"isMembership", (Object)contacts.getIsMembership());
        if (StringUtil.equals((String)memberId, (String)memberAccount.getMemberId())) {
            map.put((Object)"content", (Object)"\u6211\u7684");
        } else {
            map.put((Object)"content", (Object)"\u4ed6\u7684");
        }
        return RestResponse.success((Object)map);
    }
}

