/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.enums.ContactsStatusEnum;
import com.wego168.coweb.service.ContactsService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.PersonalityLabel;
import com.wego168.member.model.response.PersonalityLabelMemberPageResponse;
import com.wego168.member.service.impl.MemberLevelJoinService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.service.impl.PersonalityLabelService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MemberContactsController
extends CrudController<Contacts> {
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberLevelJoinService memberLevelJoinService;
    @Autowired
    private PersonalityLabelService personalityLabelService;

    public CrudService<Contacts> getService() {
        return this.contactsService;
    }

    @GetMapping(value={"/api/v1/contacts/list"})
    public RestResponse list(String city, String classId, String trade, String company, Integer bindStatus, HttpServletRequest request, HttpServletResponse response) {
        Page page = this.buildPage(request);
        List<Contacts> list = null;
        page.put((Object)"bindStatus", (Object)bindStatus);
        page.put((Object)"status", (Object)ContactsStatusEnum.PASS.value());
        page.like("name");
        list = this.contactsService.selectContacts(page);
        for (Contacts contacts : list) {
            String memberId = contacts.getMemberId();
            if (StringUtil.isNotBlank((String)memberId)) {
                contacts.setMemberLevelJoin(this.memberLevelJoinService.findByMemberId(memberId));
                this.contactsService.setMemberLevelInfo(contacts);
            }
            if (!StringUtil.isBlank((String)contacts.getMemberId()) || !StringUtil.isNotBlank((String)contacts.getTagName())) continue;
            String tagName = contacts.getTagName();
            String[] tagNames = tagName.split("/");
            ArrayList<PersonalityLabelMemberPageResponse> pList = new ArrayList<PersonalityLabelMemberPageResponse>();
            for (String s : tagNames) {
                PersonalityLabel pl = new PersonalityLabel();
                pl.setId(SequenceUtil.createUuid());
                pl.setName(s);
                pl.setSortNumber(Integer.valueOf(0));
                pList.add(new PersonalityLabelMemberPageResponse(pl));
            }
            contacts.setLabels(pList);
        }
        String labelOrderBy = "newFirst";
        this.assemblePersonalityLabelIfNecessary(list, labelOrderBy);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/contacts/get"})
    public RestResponse get(String id, String memberId, HttpServletRequest request) {
        SessionUtil.getOpenIdIfAbsentToThrow();
        memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Contacts contacts = null;
        boolean self = false;
        if (StringUtils.isBlank((CharSequence)id)) {
            contacts = this.contactsService.selectByMemberId(memberId);
            self = true;
        } else {
            contacts = this.contactsService.selectContactsById(id);
            if (contacts == null) {
                return RestResponse.success(null, (String)"ok");
            }
        }
        if (contacts == null) {
            return RestResponse.success((Object)((Object)new Contacts()), (String)"ok");
        }
        Shift.throwsIfInvalid((contacts.getIsBind() == false ? 1 : 0) != 0, (String)"\u8be5\u901a\u8baf\u5f55\u6210\u5458\u5c1a\u672a\u7ed1\u5b9a");
        Shift.throwsIfInvalid((!self && !IntegerUtil.equals((Integer)2, (Integer)contacts.getStatus()) ? 1 : 0) != 0, (String)"\u6821\u53cb\u5ba1\u6838\u4e0d\u901a\u8fc7");
        if (!StringUtil.equals((String)memberId, (String)contacts.getMemberId())) {
            Contacts my = this.contactsService.selectByMemberId(memberId);
            Shift.throwsIfInvalid((my.getIsPublic() == false ? 1 : 0) != 0, (String)"\u8bf7\u5148\u516c\u5f00\u81ea\u5df1\u7684\u901a\u8baf\u5f55");
            Shift.throwsIfInvalid((contacts.getIsPublic() == false ? 1 : 0) != 0, (String)"\u8be5\u6210\u5458\u672a\u516c\u5f00\u901a\u8baf\u5f55");
        }
        if (StringUtil.isNotBlank((String)memberId)) {
            contacts.setMemberLevelJoin(this.memberLevelJoinService.findByMemberId(memberId));
            this.contactsService.setMemberLevelInfo(contacts);
        }
        String labelOrderBy = "newFirst";
        this.assemblePersonalityLabelIfNecessary2(contacts, labelOrderBy);
        return RestResponse.success((Object)((Object)contacts));
    }

    @PostMapping(value={"/api/v1/contacts/update"})
    public RestResponse update(String name, String phone, String year, String degreeName, String departmentName, String studentId, String wechat, String company, String position, String trade, String city, String mailbox, String provide, String demand, Boolean isPublic, Integer sex, String nativePlace, String companyPhone, String qqNumber, String birthday, String hobby, String headImage) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Member member = this.memberService.selectById(memberId);
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        if (StringUtil.isNotBlank((String)name)) {
            member.setName(name);
            contacts.setName(name);
        }
        if (StringUtil.isNotBlank((String)phone)) {
            contacts.setPhone(phone);
            member.setMobilePhoneNumber(phone);
        }
        this.contactsService.updateContactsByMember(member, contacts, year, degreeName, departmentName, studentId, wechat, company, position, trade, city, mailbox, provide, demand, isPublic, sex, nativePlace, companyPhone, qqNumber, birthday, hobby, headImage);
        return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/api/v1/contacts/getStuId"})
    public RestResponse getStudentId(String name, HttpServletRequest request) {
        List list = this.contactsService.selectList(JpaCriteria.builder().eq("name", (Object)name));
        ArrayList<String> studentIds = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            for (Contacts contacts : list) {
                String studentId = contacts.getStudentId();
                studentId = studentId.substring(0, studentId.length() - 1) + "*";
                studentIds.add(studentId);
            }
        }
        return RestResponse.success(studentIds);
    }

    @GetMapping(value={"/api/v1/contacts/statistics"})
    public RestResponse statistics(HttpServletRequest request) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer bindAmount = this.contactsService.statistics(true);
        Integer totalAmount = this.contactsService.statistics(null);
        map.put("bindAmount", bindAmount);
        map.put("totalAmount", totalAmount);
        return RestResponse.success(map);
    }

    @GetMapping(value={"/api/v1/contacts/my-status"})
    public RestResponse myStatus() {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Member member = this.memberService.selectById(memberId);
        Integer memberStatus = member.getStatus();
        Bootmap response = new Bootmap();
        response.put((Object)"memberStatus", (Object)memberStatus);
        Contacts contacts = this.contactsService.selectByMemberId(memberId, this.getAppId());
        response.put((Object)"hasContact", (Object)(contacts != null ? 1 : 0));
        if (contacts != null) {
            response.put((Object)"contactStatus", (Object)contacts.getStatus());
        } else {
            response.put((Object)"contactStatus", null);
        }
        return RestResponse.success((Object)response);
    }

    private void assemblePersonalityLabelIfNecessary(List<Contacts> list, String labelOrderBy) {
        if (Checker.listIsEmpty(list)) {
            return;
        }
        String appId = list.get(0).getAppId();
        boolean assemble = this.needAssemblePersonalityLabel(appId);
        if (!assemble) {
            return;
        }
        Map map = this.personalityLabelService.selectMapInMemberIdList(list, labelOrderBy);
        for (Contacts contacts : list) {
            String memberId = contacts.getMemberId();
            List memberLabelList = (List)map.get(memberId);
            if (!Checker.listNotEmpty((List)memberLabelList)) continue;
            ArrayList<PersonalityLabelMemberPageResponse> responseLabelList = new ArrayList<PersonalityLabelMemberPageResponse>(memberLabelList.size());
            for (PersonalityLabel labelDb : memberLabelList) {
                responseLabelList.add(new PersonalityLabelMemberPageResponse(labelDb));
            }
            contacts.setLabels(responseLabelList);
        }
    }

    private void assemblePersonalityLabelIfNecessary2(Contacts contacts, String labelOrderBy) {
        if (contacts == null) {
            return;
        }
        String appId = contacts.getAppId();
        boolean assemble = this.needAssemblePersonalityLabel(appId);
        if (!assemble) {
            return;
        }
        ArrayList<Contacts> list = new ArrayList<Contacts>();
        list.add(contacts);
        Map map = this.personalityLabelService.selectMapInMemberIdList(list, labelOrderBy);
        String memberId = contacts.getMemberId();
        if (StringUtil.isBlank((String)memberId)) {
            return;
        }
        List memberLabelList = (List)map.get(memberId);
        if (Checker.listNotEmpty((List)memberLabelList)) {
            ArrayList<PersonalityLabelMemberPageResponse> responseLabelList = new ArrayList<PersonalityLabelMemberPageResponse>(memberLabelList.size());
            for (PersonalityLabel labelDb : memberLabelList) {
                responseLabelList.add(new PersonalityLabelMemberPageResponse(labelDb));
            }
            contacts.setLabels(responseLabelList);
        }
    }

    private boolean needAssemblePersonalityLabel(String appId) {
        return true;
    }
}

