/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.base.config.ServerConfig;
import com.wego168.base.domain.Config;
import com.wego168.base.service.AppService;
import com.wego168.base.service.ConfigService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.domain.MembershipOrder;
import com.wego168.coweb.domain.MembershipRecord;
import com.wego168.coweb.enums.OrderTypeEnum;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.MembershipOrderService;
import com.wego168.coweb.service.MembershipRecordService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.domain.WechatPayRequestParameter;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.interfaces.IPay;
import com.wego168.wxpay.service.PayService;
import com.wego168.wxpay.service.WxpayConfigService;
import com.wego168.wxpay.util.PayUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MembershipOrderController
extends CrudController<MembershipOrder> {
    @Autowired
    private MembershipOrderService membershipOrderService;
    @Autowired
    private MembershipRecordService membershipRecordService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private PayService payService;
    @Autowired
    private WxpayConfigService wxpayConfigService;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private ServerConfig serverConfig;
    @Autowired
    private AppService appService;

    public CrudService<MembershipOrder> getService() {
        return this.membershipOrderService;
    }

    @PostMapping(value={"/api/v1/membershipOrder/create"})
    public RestResponse createMembershipOrder(String openYear, HttpServletRequest request, HttpServletResponse response) {
        Shift.throwsIfInvalid((this.membershipOrderService.checkYear(openYear) == false ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u5e74\u4efd");
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        Shift.throwsIfInvalid((contacts == null || contacts.getIsFrozen() != false ? 1 : 0) != 0, (String)"\u6b64\u8d26\u53f7\u65e0\u6cd5\u64cd\u4f5c");
        MembershipRecord record = this.membershipRecordService.selectByContactsIdAndOpenYear(contacts.getId(), openYear);
        Shift.throwsIfNull((Object)((Object)record), (String)("\u60a8\u5df2\u7ecf\u5f00\u901a\u8fc7" + openYear + "\u5e74\u4f1a\u7c4d\u4e86"));
        Config config = this.configService.getByKey("membership_amount");
        Integer amount = Integer.valueOf(config.getValue());
        MembershipOrder membershipOrder = this.membershipOrderService.create(contacts, openYear, amount);
        this.membershipOrderService.insert((Object)membershipOrder);
        return RestResponse.success((String)membershipOrder.getId());
    }

    @PostMapping(value={"/api/v1/membershipOrder/pay"})
    public RestResponse createMembership(String openYear, HttpServletRequest request, HttpServletResponse response) {
        Shift.throwsIfInvalid((this.membershipOrderService.checkYear(openYear) == false ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u5e74\u4efd");
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        String appId = this.getAppId();
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        Shift.throwsIfInvalid((contacts == null || contacts.getIsFrozen() != false ? 1 : 0) != 0, (String)"\u6b64\u8d26\u53f7\u65e0\u6cd5\u64cd\u4f5c");
        MembershipRecord record = this.membershipRecordService.selectByContactsIdAndOpenYear(contacts.getId(), openYear);
        Shift.throwsIfInvalid((record != null ? 1 : 0) != 0, (String)("\u60a8\u5df2\u7ecf\u5f00\u901a\u8fc7" + openYear + "\u5e74\u4f1a\u7c4d\u4e86"));
        Config config = this.configService.getByKey("membership_amount");
        Integer amount = Integer.valueOf(config.getValue());
        MembershipOrder membershipOrder = this.membershipOrderService.create(contacts, openYear, amount);
        this.membershipOrderService.insert((Object)membershipOrder);
        WxpayConfig wxpayConfig = this.wxpayConfigService.selectMostSuitableOne(appId, WxAppServiceTypeEnum.MINI_PROGRAM.value());
        Pay pay = this.payService.createByCashTrade(amount.intValue(), membershipOrder.getId(), OrderTypeEnum.MEMBERSHIP.value(), "\u4f1a\u7c4d\u4f1a\u8d39\u652f\u4ed8", memberId, wxpayConfig);
        this.payService.insert((Object)pay);
        IPay payHelper = this.payUtil.determinePayHelperByCode(wxpayConfig.getCode());
        WxApp wxApp = this.wxAppService.selectByAppId(appId, WxAppServiceTypeEnum.MINI_PROGRAM.value());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6eApp");
        String wechatAppId = wxApp.getWxAppId();
        String payNotifyPreUrl = this.serverConfig.getDomain() + "/" + this.appService.selectByAppId(appId).getCode();
        String payNotifyMapping = this.payUtil.determineNotifyRequestMapping(wxpayConfig.getCode());
        WechatPayRequestParameter wechatPayRequestParameter = payHelper.preparePayParameterByMiniProgram(pay.getId(), pay.getOrderTitle(), pay.getAmount().intValue(), openId, wechatAppId, wxpayConfig.getMchKey(), wxpayConfig.getMchId(), payNotifyPreUrl + payNotifyMapping);
        return RestResponse.success((Object)wechatPayRequestParameter);
    }
}

