/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.activity.domain.Activity;
import com.wego168.bbs.domain.Information;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.service.ContactsService;
import com.wego168.coweb.service.MyActivityService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/myActivity"})
public class MyActivityController
extends CrudController<Activity> {
    private final Logger logger = LoggerFactory.getLogger(MyActivityController.class);
    @Autowired
    private MyActivityService myActivityService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberAccountService memberAccountService;

    public CrudService<Activity> getService() {
        return this.myActivityService;
    }

    @ApiOperation(value="\u65b0\u589e\u6d3b\u52a8(\u63a5\u9f99)")
    @PostMapping(value={"/insert"})
    public RestResponse insert(@Valid @RequestBody Activity activity) {
        Shift.throwsIfInvalid((!activity.getStartTime().before(activity.getEndTime()) ? 1 : 0) != 0, (String)"\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
        if (StringUtil.isBlank((String)activity.getAppId())) {
            activity.setAppId(this.getAppId());
        }
        String memberId = "";
        memberId = StringUtil.isNotBlank((String)activity.getMemberId()) ? activity.getMemberId() : SessionUtil.getMemberIdIfAbsentToThrow();
        Contacts contacts = this.contactsService.selectByMemberId(memberId, activity.getAppId());
        Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u6b64\u8d26\u53f7\u65e0\u6cd5\u64cd\u4f5c");
        Member member = this.memberService.selectById(memberId);
        MemberAccount memberAccount = this.memberAccountService.selectMiniProgramAccount(memberId);
        Information information = this.myActivityService.insertActivity(activity, memberAccount, member);
        return RestResponse.success((Object)information);
    }
}

