/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.activity.response.ActivityResponseParam;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.domain.Sign;
import com.wego168.base.domain.SignParam;
import com.wego168.coweb.provider.MyActivityProvider;
import com.wego168.coweb.service.MyActivitySignService;
import com.wego168.service.CrudService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/myActivitySign"})
public class MyActivitySignController
extends CrudController<Sign> {
    @Autowired
    private MyActivitySignService myActivitySignService;
    @Autowired
    private MyActivityProvider myActivityProvider;
    private final Logger logger = LoggerFactory.getLogger(MyActivitySignController.class);

    public CrudService<Sign> getService() {
        return this.myActivitySignService;
    }

    @ApiOperation(value="\u83b7\u53d6\u5df2\u62a5\u540d\u7684\u4eba")
    @GetMapping(value={"/signMembers"})
    public RestResponse signMembers(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.setPageSize(100);
        List<Bootmap> list = this.myActivitySignService.mobileSignMember(page);
        if (list != null && list.size() > 0) {
            for (Bootmap bootmap : list) {
                bootmap.put((Object)"signTimeStr", (Object)DateTimeUtil.convertFormat((Date)bootmap.getDate("signTime")));
            }
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/sign"})
    public RestResponse sign(@RequestBody SignParam activitySign, String code) {
        ActivityResponseParam activityResponseParam = this.myActivityProvider.sign(activitySign);
        return RestResponse.success((String)activityResponseParam.getId());
    }
}

