/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.base.domain.Config;
import com.wego168.base.domain.Content;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.ContentService;
import com.wego168.coweb.enums.ConfigEnum;
import com.wego168.coweb.service.MyConfigService;
import com.wego168.service.CrudService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="mobileMyConfigController")
@RequestMapping(value={"/api/v1/myConfig"})
public class MyConfigController
extends CrudController<Config> {
    @Autowired
    private MyConfigService myConfigService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ContentService contentService;

    @GetMapping(value={"/getVerifyType"})
    public RestResponse getVerifyType() {
        return RestResponse.success((Object)this.myConfigService.getVerifyType());
    }

    @GetMapping(value={"/isOpenJieLong"})
    public RestResponse isOpenJieLong() {
        Config config = this.configService.selectByKey("isOpenJieLong");
        return RestResponse.success((Object)config);
    }

    @GetMapping(value={"/getAppCustomer"})
    public RestResponse getAppCustomer() {
        Config config = this.configService.selectByKey("appCustomer");
        return RestResponse.success((Object)config);
    }

    @GetMapping(value={"/getAboutUs"})
    public RestResponse getAboutUs(HttpServletRequest request) {
        Config config = this.configService.selectByKey(ConfigEnum.COWEB_ABOUT.name());
        Content content = new Content();
        if (config != null) {
            content = (Content)this.contentService.selectById((Object)config.getValue());
        }
        return RestResponse.success((Object)content);
    }

    @GetMapping(value={"/informationPageTitle"})
    public RestResponse getInformationPageTitle() {
        Config config = this.configService.selectByKey(ConfigEnum.INFORMATION_PAGE_TITLE.name());
        if (null != config) {
            return RestResponse.success((String)config.getValue());
        }
        return RestResponse.success((String)"\u8d44\u6e90\u63a5\u9f99");
    }

    public CrudService<Config> getService() {
        return this.myConfigService;
    }
}

