/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.base.domain.Config;
import com.wego168.coweb.service.MyConfigService;
import com.wego168.util.Shift;
import com.wego168.web.response.RestResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MyMemberConfigController {
    @Autowired
    private MyConfigService myConfigService;

    @GetMapping(value={"/api/v1/memberConfig/getConfigList"})
    public RestResponse getConfigList(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> map = this.myConfigService.getClassAndTradeList();
        return RestResponse.success(map);
    }

    @GetMapping(value={"/api/v1/navigation/get"})
    public RestResponse getNavigationBar(HttpServletRequest request, HttpServletResponse response) {
        Config config = this.myConfigService.getByKey("navigation_bar");
        List<String> list = Arrays.asList(config.getValue().split("_"));
        return RestResponse.success(list);
    }

    @GetMapping(value={"/api/v1/privilegeStr/get"})
    public RestResponse getPrivilegeStr(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        Config privilegeConfig = this.myConfigService.getByKey("privilege");
        String privilegeStr = privilegeConfig.getValue();
        Config membershipConfig = this.myConfigService.getByKey("membership_amount");
        String membershipAmount = membershipConfig.getValue();
        map.put("privilegeStr", privilegeStr);
        map.put("membershipAmount", membershipAmount);
        return RestResponse.success(map);
    }

    @GetMapping(value={"/api/v1/hotCity/get"})
    public RestResponse getHotCity(HttpServletRequest request, HttpServletResponse response) {
        Config hotCityConfig = this.myConfigService.getByKey("hot_city");
        return RestResponse.success((String)hotCityConfig.getValue());
    }

    @GetMapping(value={"/api/v1/verifyType/get"})
    public RestResponse getVerifyType(HttpServletRequest request, HttpServletResponse response) {
        Integer verifyType = this.myConfigService.getVerifyType();
        return RestResponse.success((Object)verifyType);
    }

    @GetMapping(value={"/api/v1/informationType/get"})
    public RestResponse getInformationType() {
        Config informationTypeConfig = this.myConfigService.getByKey("information_type");
        Shift.throwsIfNull((Object)informationTypeConfig, (String)"\u672a\u6b63\u786e\u914d\u7f6e\u8d44\u8baf\u7c7b\u578b");
        List<String> list = Arrays.asList(informationTypeConfig.getValue().split("_"));
        return RestResponse.success(list);
    }
}

