/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.base.config.ServerConfig;
import com.wego168.base.domain.Sign;
import com.wego168.base.enums.OrderStatusEnum;
import com.wego168.base.service.AppService;
import com.wego168.base.service.SignService;
import com.wego168.coweb.domain.Order;
import com.wego168.coweb.enums.OrderTypeEnum;
import com.wego168.coweb.service.DonateOrderService;
import com.wego168.coweb.service.MembershipOrderService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.wx.domain.WxApp;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wx.service.WxAppService;
import com.wego168.wxpay.convert.WechatPayRequestParameterConversion;
import com.wego168.wxpay.domain.Pay;
import com.wego168.wxpay.domain.WechatPayRequestParameter;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.enums.PayStatusEnum;
import com.wego168.wxpay.interfaces.IPay;
import com.wego168.wxpay.service.PayService;
import com.wego168.wxpay.service.WechatPayRequestParameterService;
import com.wego168.wxpay.service.WxpayConfigService;
import com.wego168.wxpay.util.PayUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="cowebPayController")
@RequestMapping(value={"/api/coweb/v1"})
public class PayController
extends CrudController<Pay> {
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private PayService payService;
    @Autowired
    private AppService appService;
    @Autowired
    private ServerConfig serverConfig;
    @Autowired
    @Qualifier(value="wechatPayHelper")
    private IPay wechatPayHelper;
    @Autowired
    @Qualifier(value="swiftpassPayHelper")
    private IPay swiftpassPayHelper;
    @Autowired
    private MembershipOrderService membershipOrderService;
    @Autowired
    private DonateOrderService donateOrderService;
    @Autowired
    private WxpayConfigService wxpayConfigService;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private WechatPayRequestParameterService wechatPayRequestParameterService;
    @Autowired
    private SignService signService;
    private static final Logger logger = LoggerFactory.getLogger(PayController.class);

    public CrudService<Pay> getService() {
        return null;
    }

    @PostMapping(value={"/pay"})
    public RestResponse pay(String orderId, Integer orderType, String payReturnUrl, Integer mchType, HttpServletRequest request) {
        Shift.throwsIfInvalid((mchType == null || !WxAppServiceTypeEnum.isValid((Integer)mchType) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u8ba2\u5355\u7c7b\u578b");
        Shift.throwsIfInvalid((orderType == null || !OrderTypeEnum.isValid(orderType) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u8ba2\u5355\u7c7b\u578b");
        Checker.checkBlank((String)orderId, (String)"\u8ba2\u5355id");
        String appId = this.getAppId();
        WxpayConfig payConfig = this.wxpayConfigService.selectMostSuitableOne(appId, mchType.intValue());
        Shift.throwsIfNull((Object)payConfig, (String)"\u672a\u6b63\u786e\u914d\u7f6e\u652f\u4ed8\u914d\u7f6e");
        String payGateWayCode = payConfig.getCode();
        IPay payHelper = this.payUtil.determinePayHelperByCode(payGateWayCode);
        WxApp wxApp = this.wxAppService.selectByAppId(appId, WxAppServiceTypeEnum.MINI_PROGRAM.value());
        Shift.throwsIfNull((Object)wxApp, (String)"\u672a\u6b63\u786e\u914d\u7f6eApp");
        String wechatAppId = wxApp.getWxAppId();
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String merchentId = payConfig.getMchId();
        String merchentKey = payConfig.getMchKey();
        String payNotifyPreUrl = this.serverConfig.getDomain() + "/" + this.appService.selectByAppId(appId).getCode();
        String payNotifyMapping = this.payUtil.determineNotifyRequestMapping(payGateWayCode);
        String payNotifyUrl = payNotifyPreUrl + payNotifyMapping;
        Pay cashPay = this.determinePay(orderType, orderId, payConfig, memberId);
        this.payService.insert((Object)cashPay);
        WechatPayRequestParameter wechatPayRequestParameter = null;
        String payId = cashPay.getId();
        String orderContent = cashPay.getOrderTitle();
        int orderAmount = cashPay.getAmount();
        wechatPayRequestParameter = IntegerUtil.equals((Integer)mchType, (Integer)WxAppServiceTypeEnum.MINI_PROGRAM.value()) ? payHelper.preparePayParameterByMiniProgram(payId, orderContent, orderAmount, openId, wechatAppId, merchentKey, merchentId, payNotifyUrl) : payHelper.preparePayParameter(payId, orderContent, orderAmount, openId, wechatAppId, merchentKey, merchentId, payNotifyUrl);
        WechatPayRequestParameterConversion.wrap((WechatPayRequestParameter)wechatPayRequestParameter, (String)orderId, (int)orderType, (String)payReturnUrl);
        this.wechatPayRequestParameterService.insert((Object)wechatPayRequestParameter);
        return RestResponse.success((Object)wechatPayRequestParameter);
    }

    private Pay determinePay(int orderType, String orderId, WxpayConfig wxpayConfig, String memberId) {
        Shift.throwsIfInvalid((!OrderTypeEnum.isValid(orderType) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u8ba2\u5355\u7c7b\u578b");
        String channel = this.getPayChannelByWxpayConfig(wxpayConfig);
        Pay pay = null;
        if (IntegerUtil.equals((Integer)orderType, (Integer)OrderTypeEnum.MEMBERSHIP.value())) {
            Order order = (Order)((Object)this.membershipOrderService.selectById(orderId));
            Shift.throwsIfNull((Object)((Object)order), (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
            Shift.throwsIfInvalid((!IntegerUtil.equals((Integer)order.getOrderStatus(), (Integer)OrderStatusEnum.PAY.id()) ? 1 : 0) != 0, (String)"\u8be5\u8ba2\u5355\u65e0\u6cd5\u652f\u4ed8");
            Shift.throwsIfInvalid((!IntegerUtil.equals((Integer)order.getPayStatus(), (Integer)PayStatusEnum.NEW.value()) ? 1 : 0) != 0, (String)"\u8be5\u8ba2\u5355\u65e0\u6cd5\u652f\u4ed8");
            int orderAmount = order.getAmount();
            String appId = order.getAppId();
            pay = this.payService.createByCashTrade(orderAmount, orderId, orderType, order.getOrderName(), appId, memberId, wxpayConfig.getMchId(), wxpayConfig.getMchType().intValue());
            pay.setChannel(channel);
        } else if (IntegerUtil.equals((Integer)orderType, (Integer)OrderTypeEnum.DONATE.value())) {
            Order order = (Order)((Object)this.donateOrderService.selectById(orderId));
            Shift.throwsIfNull((Object)((Object)order), (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
            Shift.throwsIfInvalid((!IntegerUtil.equals((Integer)order.getOrderStatus(), (Integer)OrderStatusEnum.PAY.id()) ? 1 : 0) != 0, (String)"\u8be5\u8ba2\u5355\u65e0\u6cd5\u652f\u4ed8");
            Shift.throwsIfInvalid((!IntegerUtil.equals((Integer)order.getPayStatus(), (Integer)PayStatusEnum.NEW.value()) ? 1 : 0) != 0, (String)"\u8be5\u8ba2\u5355\u65e0\u6cd5\u652f\u4ed8");
            int orderAmount = order.getAmount();
            String appId = order.getAppId();
            pay = this.payService.createByCashTrade(orderAmount, orderId, orderType, order.getOrderName(), appId, memberId, wxpayConfig.getMchId(), wxpayConfig.getMchType().intValue());
            pay.setChannel(channel);
        } else if (IntegerUtil.equals((Integer)orderType, (Integer)OrderTypeEnum.ACTIVITY.value())) {
            Sign sign = (Sign)this.signService.selectById((Object)orderId);
            Shift.throwsIfNull((Object)sign, (String)"\u62a5\u540d\u8bb0\u5f55\u4e0d\u5b58\u5728");
            Shift.throwsIfInvalid((boolean)sign.getIsPay(), (String)"\u8be5\u62a5\u540d\u5df2\u652f\u4ed8");
            int orderAmount = sign.getPrice() - (sign.getPayAmount() == null ? 0 : sign.getPayAmount());
            String appId = sign.getAppId();
            pay = this.payService.createByCashTrade(orderAmount, orderId, orderType, "\u6d3b\u52a8\u8d39\u7528\u652f\u4ed8", appId, sign.getMemberId(), wxpayConfig.getMchId(), wxpayConfig.getMchType().intValue());
            pay.setChannel(channel);
        }
        Shift.throwsIfNull(pay, (String)"\u9519\u8bef\u7684\u8ba2\u5355\u7c7b\u578b");
        return pay;
    }

    private String getPayChannelByWxpayConfig(WxpayConfig wxpayConfig) {
        return wxpayConfig.getCode();
    }
}

