/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.coweb.domain.Poster;
import com.wego168.coweb.service.PosterService;
import com.wego168.coweb.util.MiniProgramUtil;
import com.wego168.domain.CosAccess;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.EnvironmentUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PosterController
extends CrudController<Poster> {
    @Autowired
    private PosterService posterService;
    @Autowired
    private Environment env;
    @Autowired
    private SimpleRedisTemplate redisTemplate;

    @GetMapping(value={"/api/v1/poster/getQRCode"})
    public RestResponse getQRCode() {
        String appId = super.getAppId();
        String url = this.redisTemplate.getString("weapp-index-qrcode-" + appId);
        if (StringUtil.isBlank((String)url)) {
            BufferedImage img = MiniProgramUtil.getSmallProgramCode(this.getAppId(), "", "123456");
            CosAccess cosAccess = EnvironmentUtil.createCosAccess((Environment)this.env);
            Shift.throwsIfNull((Object)cosAccess, (String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)img, "png", os);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                url = FileUploadUtil.upload((InputStream)is, (String)(this.getAppId() + ".png"), (String)"memberShare", (CosAccess)cosAccess);
                this.redisTemplate.setString("weapp-index-qrcode-" + appId, url);
            }
            catch (IOException e) {
                return RestResponse.error((String)"\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25");
            }
        }
        return RestResponse.success((String)url);
    }

    @GetMapping(value={"/api/v1/poster/getBgUrl"})
    public RestResponse getBgUrl() {
        Poster poster = (Poster)((Object)this.posterService.select(JpaCriteria.builder().eq("appId", (Object)this.getAppId())));
        return RestResponse.success((Object)((Object)poster));
    }

    public CrudService<Poster> getService() {
        return this.posterService;
    }
}

