/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.base.domain.Config;
import com.wego168.base.domain.Praisable;
import com.wego168.base.domain.SingleContent;
import com.wego168.base.domain.SourceData;
import com.wego168.base.mobile.PraiseControllerSupport;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.PraiseService;
import com.wego168.base.service.SingleContentService;
import com.wego168.base.service.SourceDataService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.service.BbsPointService;
import com.wego168.bbs.service.InformationService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.enums.CommentSourceTypeEnum;
import com.wego168.coweb.enums.PraiseSourceTypeEnum;
import com.wego168.coweb.scheduler.Task;
import com.wego168.coweb.service.ContactsService;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.StatusCode;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="cowebPraiseController")
public class PraiseController
extends PraiseControllerSupport {
    @Autowired
    private SourceDataService sourceDataService;
    @Autowired
    private PraiseService praiseService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private Task task;
    @Autowired
    private SingleContentService singleContentService;
    @Autowired
    private BbsPointService bbsPointService;

    @PostMapping(value={"/api/coweb/v1/app/praise/insert"})
    public RestResponse insertPraise(String sourceId, HttpServletRequest request, Integer sourceType) {
        Contacts contacts;
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        String openId = SessionUtil.getOpenId((HttpServletRequest)request);
        if (StringUtil.isBlank((String)openId) && StringUtil.isBlank((String)memberId)) {
            Shift.throwsIfInvalid((boolean)true, (String)"\u8bf7\u5148\u6388\u6743");
        }
        if (null != (contacts = this.contactsService.selectByMemberId(memberId))) {
            Shift.throwsIfInvalid((contacts == null || contacts.getIsFrozen() != false ? 1 : 0) != 0, (String)"\u60a8\u7684\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        sourceType = sourceType == null ? PraiseSourceTypeEnum.BBS_INFORMATION.value() : sourceType.intValue();
        RestResponse response = null;
        response = StringUtil.isNotBlank((String)memberId) ? super.insertPraise(sourceId, sourceType, memberId) : super.insertPraiseByOpenId(sourceId, sourceType, openId);
        Shift.throwsIfNull((Object)(response == null ? 1 : 0), (String)"\u70b9\u8d5e\u5931\u8d25");
        if (response.getCode() == StatusCode.OK.code()) {
            Information information = (Information)this.informationService.selectById((Object)sourceId);
            Config config = this.configService.getByKey("heat_rate");
            String[] scoreValue = config.getValue().split("_");
            Integer score = Integer.valueOf(scoreValue[0]);
            SourceData sourceData = this.sourceDataService.updateHeatRate(sourceId, score);
            if (sourceData != null && sourceData.getPraiseQuantity() % 2 == 0 && IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.BBS_INFORMATION.value())) {
                this.task.sendInformationPraiseTemple(information, sourceData, memberId);
            }
            if (IntegerUtil.equals((Integer)sourceType, (Integer)PraiseSourceTypeEnum.BBS_INFORMATION.value()) && information != null) {
                String title = "\u5e16\u5b50\u88ab\u8d5e";
                this.bbsPointService.giveTopicPraisedPointAsync(sourceId, title, information.getMemberId(), this.getAppId());
            }
        }
        return response;
    }

    @GetMapping(value={"/api/coweb/v1/app/praise/get"})
    public RestResponse isPraised(String sourceId, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String openId = SessionUtil.getOpenId((HttpServletRequest)request);
        if (StringUtil.isNotBlank((String)memberId)) {
            return super.isPraised(sourceId, memberId);
        }
        return super.isPraisedByOpenId(sourceId, openId);
    }

    @GetMapping(value={"/api/coweb/v1/app/praise/page"})
    public RestResponse selectPraise(String sourceId, HttpServletRequest request) {
        return super.selectPage(sourceId, request);
    }

    @PostMapping(value={"/api/coweb/v1/app/praise/delete"})
    public RestResponse deletePraise(String sourceId, Integer sourceType, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        String openId = SessionUtil.getOpenId((HttpServletRequest)request);
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        if (null != contacts) {
            Shift.throwsIfInvalid((contacts == null || contacts.getIsFrozen() != false ? 1 : 0) != 0, (String)"\u60a8\u7684\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        sourceType = sourceType == null ? PraiseSourceTypeEnum.BBS_INFORMATION.value() : sourceType.intValue();
        RestResponse restResponse = null;
        restResponse = StringUtil.isNotBlank((String)memberId) ? super.deletePraise(sourceId, sourceType, memberId) : super.deletePraiseByOpenId(sourceId, sourceType, openId);
        Shift.throwsIfNull((Object)(restResponse == null ? 1 : 0), (String)"\u53d6\u6d88\u70b9\u8d5e\u5931\u8d25");
        if (restResponse.getCode() == StatusCode.OK.code()) {
            Config config = this.configService.getByKey("heat_rate");
            String[] scoreValue = config.getValue().split("_");
            Integer score = Integer.valueOf(scoreValue[0]);
            this.sourceDataService.updateHeatRate(sourceId, Integer.valueOf(-score.intValue()));
        }
        return restResponse;
    }

    protected Praisable sourceIsValid(String sourceId, int sourceType) {
        Information information;
        SourceData sourceData;
        if (IntegerUtil.equals((Integer)sourceType, (Integer)PraiseSourceTypeEnum.BBS_INFORMATION.value()) && (sourceData = this.sourceDataService.selectBySourceId(sourceId)) != null && (information = (Information)this.informationService.selectById((Object)sourceId)) != null) {
            return sourceData;
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)PraiseSourceTypeEnum.SINGLECONTENT.value())) {
            SingleContent singleContent = (SingleContent)this.singleContentService.selectById((Object)sourceId);
            return singleContent;
        }
        return null;
    }

    protected PraiseService getPraiseService() {
        return this.praiseService;
    }

    protected SourceDataService getSourceDataService() {
        return this.sourceDataService;
    }
}

