/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.coweb.mobile;

import com.wego168.base.domain.Config;
import com.wego168.base.domain.Sharable;
import com.wego168.base.domain.SingleContent;
import com.wego168.base.domain.SourceData;
import com.wego168.base.mobile.ShareControllerSupport;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.ShareService;
import com.wego168.base.service.SingleContentService;
import com.wego168.base.service.SourceDataService;
import com.wego168.bbs.domain.Information;
import com.wego168.bbs.service.InformationService;
import com.wego168.coweb.domain.Contacts;
import com.wego168.coweb.enums.CommentSourceTypeEnum;
import com.wego168.coweb.enums.ShareSourceTypeEnum;
import com.wego168.coweb.service.ContactsService;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.IntegerUtil;
import com.wego168.util.Shift;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.StatusCode;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="cowebShareController")
@RequestMapping(value={"/api/coweb/v1/share"})
public class ShareController
extends ShareControllerSupport {
    @Autowired
    private ShareService shareService;
    @Autowired
    private SourceDataService sourceDataService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private ContactsService contactsService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SingleContentService singleContentService;

    @PostMapping(value={"/insert"})
    public RestResponse insertShare(String sourceId, String url, HttpServletRequest request, Integer sourceType) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        Contacts contacts = this.contactsService.selectByMemberId(memberId);
        if (contacts != null) {
            Shift.throwsIfInvalid((boolean)contacts.getIsFrozen(), (String)"\u6b64\u8d26\u53f7\u65e0\u6cd5\u64cd\u4f5c");
        }
        sourceType = sourceType == null ? ShareSourceTypeEnum.BBS_INFORMATION.value() : sourceType.intValue();
        RestResponse restResponse = null;
        restResponse = StringUtils.isNotBlank((CharSequence)memberId) ? super.insertShare(sourceId, sourceType, memberId, url, super.getAppId()) : super.insertShareByOpenId(sourceId, sourceType, openId, url, super.getAppId());
        Shift.throwsIfNull((Object)restResponse, (String)"\u8f6c\u53d1\u51fa\u9519");
        if (restResponse.getCode() == StatusCode.OK.code()) {
            Config config = this.configService.getByKey("heat_rate");
            String[] scoreValue = config.getValue().split("_");
            Integer score = Integer.valueOf(scoreValue[3]);
            this.sourceDataService.updateHeatRate(sourceId, score);
        }
        return restResponse;
    }

    @GetMapping(value={"/page"})
    public RestResponse selectShare(String sourceId, HttpServletRequest request) {
        return super.selectPage(sourceId, request);
    }

    protected Sharable sourceIsValid(String sourceId, int sourceType) {
        if (IntegerUtil.equals((Integer)sourceType, (Integer)ShareSourceTypeEnum.BBS_INFORMATION.value())) {
            Information information;
            SourceData sourceData = this.sourceDataService.selectBySourceId(sourceId);
            if (sourceData == null && (information = (Information)this.informationService.selectById((Object)sourceId)) != null) {
                sourceData = this.sourceDataService.create(sourceId, sourceType, information.getTitle(), information.getAppId());
                if (StringUtils.isBlank((CharSequence)sourceData.getTitle())) {
                    sourceData.setTitle("\u8bba\u575b\u6807\u9898");
                }
                this.sourceDataService.insert((Object)sourceData);
            }
            return sourceData;
        }
        if (IntegerUtil.equals((Integer)sourceType, (Integer)CommentSourceTypeEnum.SINGLECONTENT.value())) {
            SingleContent singleContent = (SingleContent)this.singleContentService.selectById((Object)sourceId);
            return singleContent;
        }
        return null;
    }

    protected ShareService getShareService() {
        return this.shareService;
    }

    protected SourceDataService getSourceDataService() {
        return this.sourceDataService;
    }
}

